/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.dialogs;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.tools.internal.i18n.I18n;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public final class NagDialog
extends MessageDialogWithToggle {
    private String m_helpId;

    private NagDialog(String msgText, String helpId, Shell parentShell) {
        super(parentShell, Messages.InfoNaggerDialogTitle, null, msgText, 2, new String[]{IDialogConstants.HELP_LABEL, IDialogConstants.PROCEED_LABEL}, 0, Messages.InfoNaggerDialogToggleMsg, false);
        this.m_helpId = helpId;
        this.setShellStyle(67616);
        this.setBlockOnOpen(true);
    }

    private NagDialog(Shell parentShell, String msgKey, String helpId) {
        this(I18n.getString((String)msgKey), helpId, parentShell);
    }

    public static void runNagDialog(Shell parentShell, String msgKey, String helpId) {
        Shell parent = parentShell == null ? Plugin.getShell() : parentShell;
        String prefKey = "InfoNagger." + msgKey;
        IPreferenceStore preferenceStore = Plugin.getDefault().getPreferenceStore();
        if (!preferenceStore.getString(prefKey).equals("always")) {
            NagDialog dialog = new NagDialog(parent, msgKey, helpId);
            dialog.setPrefStore(preferenceStore);
            dialog.setPrefKey(prefKey);
            dialog.open();
        }
    }

    public static void runNagDialog(Shell parentShell, String msgKey, String msgText, String helpId) {
        Shell parent = parentShell == null ? Plugin.getShell() : parentShell;
        String prefKey = "InfoNagger." + msgKey;
        IPreferenceStore preferenceStore = Plugin.getDefault().getPreferenceStore();
        if (!preferenceStore.getString(prefKey).equals("always")) {
            NagDialog dialog = new NagDialog(msgText, helpId, parent);
            dialog.setPrefStore(preferenceStore);
            dialog.setPrefKey(prefKey);
            dialog.open();
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 17) {
            Plugin.getHelpSystem().displayHelp(this.m_helpId);
        } else {
            super.buttonPressed(buttonId);
        }
    }

    public void create() {
        super.create();
        Plugin.getHelpSystem().setHelp((Control)this.getButton(0), this.m_helpId);
    }
}

