/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.editors;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.persistence.EntityManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.jubula.client.core.businessprocess.CentralTestDataBP;
import org.eclipse.jubula.client.core.businessprocess.TestDataCubeBP;
import org.eclipse.jubula.client.core.events.DataChangedEvent;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ITDManager;
import org.eclipse.jubula.client.core.model.ITestDataCategoryPO;
import org.eclipse.jubula.client.core.model.ITestDataCubePO;
import org.eclipse.jubula.client.core.persistence.EditSupport;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.IncompatibleTypeException;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.constants.RCPCommandIDs;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.objectmapping.LimitingDragSourceListener;
import org.eclipse.jubula.client.ui.rcp.editors.AbstractJBEditor;
import org.eclipse.jubula.client.ui.rcp.editors.JBEditorHelper;
import org.eclipse.jubula.client.ui.rcp.editors.PersistableEditorInput;
import org.eclipse.jubula.client.ui.rcp.events.GuiEventDispatcher;
import org.eclipse.jubula.client.ui.rcp.filter.JBBrowserPatternFilter;
import org.eclipse.jubula.client.ui.rcp.filter.JBFilteredTree;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.provider.contentprovider.CentralTestDataContentProvider;
import org.eclipse.jubula.client.ui.rcp.provider.labelprovider.CentralTestDataLabelProvider;
import org.eclipse.jubula.client.ui.utils.CommandHelper;
import org.eclipse.jubula.tools.internal.exception.ProjectDeletedException;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.dialogs.PatternFilter;

public class CentralTestDataEditor
extends AbstractJBEditor
implements DataEventDispatcher.IParamChangedListener {
    private Set<ITestDataCubePO> m_elementsToRefresh = new HashSet<ITestDataCubePO>();

    @Override
    protected void createPartControlImpl(Composite parent) {
        this.createMainPart(parent);
        GridData gridData = new GridData(1808);
        this.getMainTreeViewer().getControl().setLayoutData((Object)gridData);
        this.setControl(this.getMainTreeViewer().getControl());
        this.getMainTreeViewer().setContentProvider((IContentProvider)new CentralTestDataContentProvider());
        DecoratingLabelProvider lp = new DecoratingLabelProvider((ILabelProvider)new CentralTestDataLabelProvider(), Plugin.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator());
        this.getMainTreeViewer().setLabelProvider((IBaseLabelProvider)lp);
        this.getMainTreeViewer().setComparator(new ViewerComparator(){

            public int category(Object element) {
                if (element instanceof ITestDataCategoryPO) {
                    return 0;
                }
                if (element instanceof ITestDataCubePO) {
                    return 1;
                }
                return 2;
            }
        });
        int ops = 2;
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        CentralTestDataDropSupport dropSupport = new CentralTestDataDropSupport((Viewer)this.getMainTreeViewer());
        dropSupport.setFeedbackEnabled(false);
        this.getMainTreeViewer().addDragSupport(ops, transfers, (DragSourceListener)new LimitingDragSourceListener((ISelectionProvider)this.getMainTreeViewer(), null));
        this.getMainTreeViewer().addDropSupport(ops, transfers, (DropTargetListener)dropSupport);
        this.addDoubleClickListener("org.eclipse.jubula.client.ui.rcp.commands.EditParameters", (StructuredViewer)this.getMainTreeViewer());
        this.addFocusListener(this.getMainTreeViewer());
        this.getEditorHelper().addListeners();
        this.setActionHandlers();
        this.setInitialInput();
        DataEventDispatcher ded = DataEventDispatcher.getInstance();
        ded.addPropertyChangedListener((DataEventDispatcher.IPropertyChangedListener)this, true);
        ded.addParamChangedListener((DataEventDispatcher.IParamChangedListener)this, true);
        GuiEventDispatcher.getInstance().addEditorDirtyStateListener(this, true);
    }

    @Override
    public void dispose() {
        DataEventDispatcher ded = DataEventDispatcher.getInstance();
        ded.removeParamChangedListener((DataEventDispatcher.IParamChangedListener)this);
        this.getElementsToRefresh().clear();
        super.dispose();
    }

    @Override
    protected void createPartName() {
        this.setPartName(Messages.CentralTestDataEditorName);
    }

    private void addFocusListener(TreeViewer mainTreeViewer) {
        mainTreeViewer.getTree().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                CentralTestDataEditor.this.getMainTreeViewer().setSelection(CentralTestDataEditor.this.getMainTreeViewer().getSelection(), true);
            }
        });
    }

    @Override
    protected void fillContextMenu(IMenuManager mgr) {
        CommandHelper.createContributionPushItem((IMenuManager)mgr, (String)"org.eclipse.jubula.client.ui.rcp.commands.AddNewTestDataManager");
        CommandHelper.createContributionPushItem((IMenuManager)mgr, (String)"org.eclipse.jubula.client.ui.rcp.commands.CreateNewCategoryCommand");
        CommandHelper.createContributionPushItem((IMenuManager)mgr, (String)"org.eclipse.ui.edit.rename");
        CommandHelper.createContributionPushItem((IMenuManager)mgr, (String)"org.eclipse.jubula.client.ui.rcp.commands.EditParameters");
        mgr.add((IContributionItem)new Separator());
        CommandHelper.createContributionPushItem((IMenuManager)mgr, (String)"org.eclipse.jubula.client.ui.rcp.commands.ShowWhereUsed");
        CommandHelper.createContributionPushItem((IMenuManager)mgr, (String)"org.eclipse.jubula.client.ui.rcp.commands.RevertChanges");
        CommandHelper.createContributionPushItem((IMenuManager)mgr, (String)"org.eclipse.ui.edit.delete");
        mgr.add(CommandHelper.createContributionItem((String)RCPCommandIDs.FIND, null, (String)Messages.FindContextMenu, (int)8));
        mgr.add((IContributionItem)new Separator());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("importWizardId", "org.eclipse.jubula.client.ui.rcp.importWizard.ImportTestDataSetsWizard");
        mgr.add(CommandHelper.createContributionItem((String)RCPCommandIDs.ECLIPSE_RCP_FILE_IMPORT, params, null, (int)8));
    }

    @Override
    protected void setHelp(Composite parent) {
        Plugin.getHelpSystem().setHelp((Control)parent, "org.eclipse.jubula.client.ua.help.guidancerCentralTestDataEditorContextId");
    }

    @Override
    protected void setInitialInput() {
        ITestDataCategoryPO rootPOTop = (ITestDataCategoryPO)this.getEditorHelper().getEditSupport().getWorkVersion();
        try {
            this.getTreeViewer().getTree().getParent().setRedraw(false);
            this.getTreeViewer().setInput((Object)rootPOTop);
            this.getTreeViewer().expandAll();
        }
        finally {
            this.getTreeViewer().getTree().getParent().setRedraw(true);
        }
    }

    /*
     * Loose catch block
     */
    public void doSave(IProgressMonitor monitor) {
        monitor.beginTask(Messages.EditorsSaveEditors, -1);
        EditSupport editSupport = this.getEditorHelper().getEditSupport();
        try {
            try {
                editSupport.saveWorkVersion();
                EntityManager masterSession = GeneralStorage.getInstance().getMasterSession();
                IPersistentObject original = editSupport.getOriginal();
                if (original != null) {
                    masterSession.refresh((Object)original);
                    if (original instanceof ITestDataCategoryPO) {
                        this.refreshChilds(masterSession, original);
                    }
                }
                this.updateReferencedParamNodes();
                this.getEditorHelper().resetEditableState();
                this.getEditorHelper().setDirty(false);
            }
            catch (IncompatibleTypeException pmce) {
                this.handlePMCompNameException(pmce);
                monitor.done();
            }
            catch (PMException e) {
                PMExceptionHandler.handlePMExceptionForMasterSession(e);
                try {
                    this.reOpenEditor(((PersistableEditorInput)this.getEditorInput()).getNode());
                }
                catch (PMException pMException) {
                    PMExceptionHandler.handlePMExceptionForEditor(e, this);
                }
                monitor.done();
            }
            catch (ProjectDeletedException projectDeletedException) {
                PMExceptionHandler.handleProjectDeletedException();
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    private void refreshChilds(EntityManager session, IPersistentObject testDataCategory) {
        for (ITestDataCategoryPO catergory : ((ITestDataCategoryPO)testDataCategory).getCategoryChildren()) {
            session.refresh((Object)catergory);
            this.refreshChilds(session, (IPersistentObject)catergory);
        }
        for (ITestDataCubePO dataCube : ((ITestDataCategoryPO)testDataCategory).getTestDataChildren()) {
            session.refresh((Object)dataCube);
            ITDManager manager = dataCube.getDataManager();
            session.refresh((Object)manager);
        }
    }

    private void updateReferencedParamNodes() {
        HashSet nodesToRefresh = new HashSet();
        for (ITestDataCubePO tdc : this.getElementsToRefresh()) {
            nodesToRefresh.addAll(TestDataCubeBP.getReuser((IParameterInterfacePO)tdc));
        }
        EntityManager masterSession = GeneralStorage.getInstance().getMasterSession();
        for (INodePO node : nodesToRefresh) {
            masterSession.refresh((Object)node);
        }
        this.getElementsToRefresh().clear();
    }

    @Override
    public Image getDisabledTitleImage() {
        return IconConstants.DISABLED_CTD_EDITOR_IMAGE;
    }

    @Override
    public String getEditorPrefix() {
        return Messages.PluginCTD;
    }

    @Override
    public void handlePropertyChanged(boolean isCompNameChanged) {
        this.getMainTreeViewer().refresh();
    }

    public void handleParamChanged() {
        ISelection currentSelection = this.getMainTreeViewer().getSelection();
        if (currentSelection instanceof IStructuredSelection) {
            Object[] objectArray = ((IStructuredSelection)currentSelection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object selectedObj = objectArray[n2];
                if (selectedObj instanceof ITestDataCubePO) {
                    this.getElementsToRefresh().add((ITestDataCubePO)selectedObj);
                }
                ++n2;
            }
        }
        this.getMainTreeViewer().refresh();
    }

    public void handleDataChanged(DataChangedEvent ... events) {
        this.getMainTreeViewer().getTree().setRedraw(false);
        try {
            DataChangedEvent[] dataChangedEventArray = events;
            int n = events.length;
            int n2 = 0;
            while (n2 < n) {
                DataChangedEvent e = dataChangedEventArray[n2];
                this.handleDataChanged(e.getPo(), e.getDataState(), e.getUpdateState());
                ++n2;
            }
        }
        finally {
            this.getMainTreeViewer().getTree().setRedraw(true);
        }
    }

    public void handleDataChanged(IPersistentObject po, DataEventDispatcher.DataState dataState, DataEventDispatcher.UpdateState updateState) {
        if (po instanceof ITestDataCubePO) {
            if (updateState == DataEventDispatcher.UpdateState.onlyInEditor) {
                this.getEditorHelper().setDirty(true);
            }
            ITestDataCubePO tdc = (ITestDataCubePO)po;
            this.handleDataChanged(dataState, tdc);
        } else if (po instanceof ITestDataCategoryPO) {
            if (updateState == DataEventDispatcher.UpdateState.onlyInEditor) {
                this.getEditorHelper().setDirty(true);
            }
            this.handleDataChanged(dataState, (ITestDataCategoryPO)po);
        }
    }

    private void handleDataChanged(DataEventDispatcher.DataState dataState, ITestDataCubePO testData) {
        switch (dataState) {
            case Added: {
                this.getTreeViewer().add((Object)testData.getParent(), (Object)testData);
                this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)testData));
                break;
            }
            case Deleted: {
                this.getTreeViewer().remove((Object)testData);
                break;
            }
            case Renamed: {
                this.getTreeViewer().update((Object)testData, null);
                this.getElementsToRefresh().add(testData);
                break;
            }
            case ReuseChanged: {
                break;
            }
            case StructureModified: {
                this.getTreeViewer().update((Object)testData, null);
                this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)testData));
                break;
            }
        }
    }

    private void handleDataChanged(DataEventDispatcher.DataState dataState, ITestDataCategoryPO category) {
        switch (dataState) {
            case Added: {
                this.getTreeViewer().add((Object)category.getParent(), (Object)category);
                this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)category));
                break;
            }
            case Deleted: {
                this.getTreeViewer().remove((Object)category);
                break;
            }
            case Renamed: {
                this.getTreeViewer().update((Object)category, null);
                break;
            }
            case ReuseChanged: {
                break;
            }
            case StructureModified: {
                this.getTreeViewer().refresh((Object)category);
                break;
            }
        }
    }

    @Override
    protected void createMainPart(Composite parent) {
        JBFilteredTree ft = new JBFilteredTree(parent, 2818, (PatternFilter)new JBBrowserPatternFilter(), true);
        this.setMainTreeViewer(ft.getViewer());
        this.getMainTreeViewer().setUseHashlookup(true);
        this.getSite().setSelectionProvider((ISelectionProvider)this);
        this.firePropertyChange(258);
    }

    private Set<ITestDataCubePO> getElementsToRefresh() {
        return this.m_elementsToRefresh;
    }

    public String getTitleToolTip() {
        return "";
    }

    @Override
    protected void setActionHandlers() {
        this.getSite().setSelectionProvider((ISelectionProvider)this);
        this.getEditorSite().getActionBars().updateActionBars();
    }

    private class CentralTestDataDropSupport
    extends ViewerDropAdapter {
        public CentralTestDataDropSupport(Viewer viewer) {
            super(viewer);
        }

        public boolean validateDrop(Object target, int operation, TransferData transferType) {
            ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
            if (this.getTargetCategory(target) != null && selection instanceof IStructuredSelection) {
                Object[] objectArray = ((IStructuredSelection)selection).toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    if (!(element instanceof ITestDataCategoryPO) && !(element instanceof ITestDataCubePO)) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
            return false;
        }

        public boolean performDrop(Object data) {
            if (CentralTestDataEditor.this.getEditorHelper().requestEditableState() != JBEditorHelper.EditableState.OK) {
                return false;
            }
            ITestDataCategoryPO targetCategory = this.getTargetCategory(this.getCurrentTarget());
            ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
            HashSet<ITestDataCategoryPO> structuresToUpdate = new HashSet<ITestDataCategoryPO>();
            structuresToUpdate.add(targetCategory);
            Object[] objectArray = ((IStructuredSelection)selection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITestDataCategoryPO oldParent;
                Object element = objectArray[n2];
                if (element instanceof ITestDataCategoryPO) {
                    ITestDataCategoryPO category = (ITestDataCategoryPO)element;
                    if (!CentralTestDataBP.getAncestors((ITestDataCategoryPO)targetCategory).contains(category) && category.getParent() != targetCategory) {
                        oldParent = category.getParent();
                        structuresToUpdate.add(oldParent);
                        oldParent.removeCategory(category);
                        targetCategory.addCategory(category);
                    }
                } else if (element instanceof ITestDataCubePO) {
                    ITestDataCubePO testData = (ITestDataCubePO)element;
                    oldParent = testData.getParent();
                    structuresToUpdate.add(oldParent);
                    oldParent.removeTestData(testData);
                    targetCategory.addTestData(testData);
                }
                ++n2;
            }
            LinkedList<DataChangedEvent> events = new LinkedList<DataChangedEvent>();
            for (ITestDataCategoryPO categoryToUpdate : structuresToUpdate) {
                events.add(new DataChangedEvent((IPersistentObject)categoryToUpdate, DataEventDispatcher.DataState.StructureModified, DataEventDispatcher.UpdateState.onlyInEditor));
            }
            DataEventDispatcher.getInstance().fireDataChangedListener(events.toArray(new DataChangedEvent[events.size()]));
            return true;
        }

        private ITestDataCategoryPO getTargetCategory(Object target) {
            if (target == null) {
                return (ITestDataCategoryPO)this.getViewer().getInput();
            }
            if (target instanceof ITestDataCategoryPO) {
                return (ITestDataCategoryPO)target;
            }
            return null;
        }
    }
}

