/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.ui.handlers.AbstractHandler;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.editors.IJBEditor;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.ui.IWorkbenchPart;

public class RevertEditorChangesHandler
extends AbstractHandler {
    public Object executeImpl(ExecutionEvent event) {
        MessageDialog dialog;
        IWorkbenchPart activePart = Plugin.getActivePart();
        if (activePart == null) {
            return null;
        }
        IJBEditor editor = (IJBEditor)activePart.getAdapter(IJBEditor.class);
        if (editor != null && (dialog = this.showConfirmDialog()).getReturnCode() == 0) {
            this.revertEditorChanges(editor);
        }
        return null;
    }

    private MessageDialog showConfirmDialog() {
        MessageDialog dialog = new MessageDialog(this.getActiveShell(), Messages.RevertEditorChangesActionShellTitle, null, Messages.RevertEditorChangesActionQuestionText, 3, new String[]{Messages.DialogMessageButton_YES, Messages.DialogMessageButton_NO}, 0);
        dialog.create();
        DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
        dialog.open();
        return dialog;
    }

    private void revertEditorChanges(IJBEditor editor) {
        try {
            editor.reOpenEditor(editor.getEditorHelper().getEditSupport().getOriginal());
        }
        catch (PMException pMException) {
            ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_REVERT_EDITOR_CHANGES_FAILED);
        }
    }
}

