/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers.project;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.persistence.EntityManager;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jubula.client.core.businessprocess.UsedToolkitBP;
import org.eclipse.jubula.client.core.businessprocess.progress.ProgressMonitorTracker;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.IReusedProjectPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PMReadException;
import org.eclipse.jubula.client.core.persistence.ProjectPM;
import org.eclipse.jubula.client.core.persistence.TestResultPM;
import org.eclipse.jubula.client.core.utils.StringHelper;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.handlers.project.AbstractProjectHandler;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.businessprocess.ProjectUIBP;
import org.eclipse.jubula.client.ui.rcp.businessprocess.ToolkitBP;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.dialogs.NagDialog;
import org.eclipse.jubula.client.ui.rcp.dialogs.ProjectDialog;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.utils.Utils;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.toolkit.common.businessprocess.ToolkitSupportBP;
import org.eclipse.jubula.toolkit.common.exception.ToolkitPluginException;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.internal.exception.ConfigXmlException;
import org.eclipse.jubula.tools.internal.exception.JBException;
import org.eclipse.jubula.tools.internal.exception.ProjectDeletedException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class OpenProjectHandler
extends AbstractProjectHandler {
    private List<IProjectPO> checkAllAvailableProjects() {
        List projList = null;
        try {
            projList = ProjectPM.findAllProjects();
            if (projList.isEmpty()) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.I_NO_PROJECT_IN_DB);
                    }
                });
                Plugin.stopLongRunning();
            } else {
                TreeMap projNameToVersionMap = new TreeMap();
                for (IProjectPO proj : projList) {
                    String projName = proj.getName();
                    String projVersion = proj.getVersionString();
                    if (!StringUtils.isBlank((String)projName) && !projNameToVersionMap.containsKey(projName)) {
                        projNameToVersionMap.put(projName, new ArrayList());
                    }
                    ((List)projNameToVersionMap.get(projName)).add(projVersion);
                }
            }
        }
        catch (JBException e) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ErrorHandlingUtil.createMessageDialog((JBException)e, null, null);
                }
            });
        }
        return projList;
    }

    public ProjectDialog openProjectOpenDialog(List<IProjectPO> projList) {
        ProjectDialog dialog = null;
        if (GeneralStorage.getInstance().getProject() != null && !Plugin.getDefault().showSaveEditorDialog()) {
            Plugin.stopLongRunning();
        } else {
            dialog = this.openProjectSelectionDialog(projList);
            if (dialog.getReturnCode() == 1) {
                Plugin.stopLongRunning();
            }
        }
        return dialog;
    }

    public void loadProject(ProjectDialog.ProjectData projectData, List<IProjectPO> projList) {
        IProjectPO projectToOpen = null;
        for (IProjectPO project : projList) {
            if (!project.getGuid().equals(projectData.getGUID()) || !project.getVersionString().equals(projectData.getVersionString())) continue;
            projectToOpen = project;
            break;
        }
        if (projectToOpen == null) {
            this.openProjectOpenDialog(projList);
        } else {
            OpenProjectOperation openOperation = new OpenProjectOperation(projectToOpen);
            try {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)openOperation);
                DataEventDispatcher.getInstance().fireProjectStateChanged(DataEventDispatcher.ProjectState.opened);
                this.checkAndNagForMissingProjects();
            }
            catch (InvocationTargetException invocationTargetException) {
                openOperation.handleOperationException();
            }
            catch (InterruptedException interruptedException) {
                openOperation.handleOperationException();
            }
        }
    }

    private void checkAndNagForMissingProjects() {
        Set usedProjects;
        LinkedList<String> missingProjects = new LinkedList<String>();
        IProjectPO project = GeneralStorage.getInstance().getProject();
        if (project != null && (usedProjects = project.getUsedProjects()) != null) {
            for (IReusedProjectPO rProjects : usedProjects) {
                if (ProjectPM.doesProjectVersionExist((String)rProjects.getProjectGuid(), (Integer)rProjects.getMajorNumber(), (Integer)rProjects.getMinorNumber(), (Integer)rProjects.getMicroNumber(), (String)rProjects.getVersionQualifier())) continue;
                missingProjects.add(rProjects.getProjectGuid());
            }
        }
        if (!missingProjects.isEmpty()) {
            NagDialog.runNagDialog(this.getActiveShell(), "InfoNagger.ImportAllRequiredProjects", "org.eclipse.jubula.client.ua.help.openProjectImportAllRequiredProjectsContextId");
        }
    }

    private ProjectDialog openProjectSelectionDialog(List<IProjectPO> projList) {
        final ProjectDialog dialog = new ProjectDialog(this.getActiveShell(), projList, Messages.OpenProjectActionMessage, Messages.OpenProjectActionTitle, IconConstants.OPEN_PROJECT_DIALOG_IMAGE, Messages.OpenProjectActionCaption, false);
        dialog.setHelpAvailable(true);
        dialog.create();
        DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
        Plugin.getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.jubula.client.ua.help.openProjectDialogContextId");
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Plugin.startLongRunning(Messages.OpenProjectActionLoadProjectWaitMessage);
                dialog.open();
            }
        });
        return dialog;
    }

    public Object executeImpl(ExecutionEvent event) {
        ProjectDialog.ProjectData project = null;
        boolean cancelPressed = false;
        ProjectDialog dialog = null;
        List<IProjectPO> projList = this.checkAllAvailableProjects();
        if (!projList.isEmpty()) {
            if (ProjectUIBP.getInstance().shouldPerformAutoProjectLoad()) {
                project = ProjectUIBP.getMostRecentProjectData();
            } else {
                dialog = this.openProjectOpenDialog(projList);
                if (dialog == null || dialog.getReturnCode() == 1) {
                    cancelPressed = true;
                } else {
                    project = dialog.getSelection();
                }
            }
            if (!cancelPressed) {
                this.loadProject(project, projList);
            }
        }
        return null;
    }

    public static class OpenProjectOperation
    implements IRunnableWithProgress {
        private static final int TESTRESULT_DETAIL_JOB_CLEANUP_DELAY = 600000;
        private IProjectPO m_selectedProject;

        public OpenProjectOperation(IProjectPO selectedProject) {
            this.m_selectedProject = selectedProject;
        }

        public void run(IProgressMonitor monitor) throws InterruptedException {
            Utils.clearClient();
            int totalWork = this.getTotalWork();
            ProgressMonitorTracker.getInstance().setProgressMonitor(monitor);
            monitor.beginTask(NLS.bind((String)Messages.OpenProjectOperationOpeningProject, (Object[])new Object[]{this.m_selectedProject.getName(), this.m_selectedProject.getProjectVersion()}), totalWork);
            DataEventDispatcher ded = DataEventDispatcher.getInstance();
            try {
                try {
                    if (!this.checkProjectToolkits(this.m_selectedProject)) {
                        throw new InterruptedException();
                    }
                    this.checkToolkitAvailable(this.m_selectedProject.getToolkit());
                    try {
                        NodePM.getInstance().setUseCache(true);
                        this.load(this.m_selectedProject, monitor);
                        if (monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                    }
                    catch (ConfigXmlException ce) {
                        this.handleCapDataNotFound(ce);
                    }
                    ded.fireProjectLoadedListener(monitor);
                    StringHelper.getInstance();
                    OpenProjectOperation.startCleanTestresultsJob(GeneralStorage.getInstance().getProject());
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                }
                catch (JBException e) {
                    this.errorOccured();
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ErrorHandlingUtil.createMessageDialog((JBException)e, null, null);
                        }
                    });
                    ProgressMonitorTracker.getInstance().setProgressMonitor(null);
                    NodePM.getInstance().setUseCache(false);
                    monitor.done();
                }
            }
            finally {
                ProgressMonitorTracker.getInstance().setProgressMonitor(null);
                NodePM.getInstance().setUseCache(false);
                monitor.done();
            }
        }

        public static void startCleanTestresultsJob(IProjectPO project) {
            final int cleanupInterval = project.getTestResultCleanupInterval();
            final String projGUID = String.valueOf(project.getGuid());
            final Integer projMajVer = project.getMajorProjectVersion();
            final Integer projMinVer = project.getMinorProjectVersion();
            final Integer projMicVer = project.getMicroProjectVersion();
            final String projVerQual = project.getProjectVersionQualifier();
            if (cleanupInterval > 0) {
                Job job = new Job(NLS.bind((String)Messages.UIJobCleaningTestResultFromDB, (Object)project.getName())){

                    public IStatus run(IProgressMonitor monitor) {
                        TestResultPM.cleanTestresultDetails((int)cleanupInterval, (String)projGUID, (Integer)projMajVer, (Integer)projMinVer, (Integer)projMicVer, (String)projVerQual);
                        monitor.done();
                        return Status.OK_STATUS;
                    }
                };
                job.schedule(600000L);
            }
        }

        private void checkToolkitAvailable(String toolkitId) {
            try {
                if (!ComponentBuilder.getInstance().getLevelToolkitIds().contains(toolkitId) && "toolkit".equals(ToolkitSupportBP.getToolkitLevel((String)toolkitId))) {
                    ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.W_PROJECT_TOOLKIT_NOT_AVAILABLE);
                }
            }
            catch (ToolkitPluginException toolkitPluginException) {
                ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.W_PROJECT_TOOLKIT_NOT_AVAILABLE);
            }
        }

        private int getTotalWork() {
            int totalWork = 0;
            EntityManager masterSession = GeneralStorage.getInstance().getMasterSession();
            long selectedProjectId = this.m_selectedProject.getId();
            totalWork = (int)((long)totalWork + NodePM.getNumNodes((long)selectedProjectId, (EntityManager)masterSession));
            totalWork = (int)((long)totalWork + NodePM.getNumTestDataManagers((long)selectedProjectId, (EntityManager)masterSession));
            totalWork = (int)((long)totalWork + NodePM.getNumExecTestCases((long)selectedProjectId, (EntityManager)masterSession));
            for (IReusedProjectPO reused : this.m_selectedProject.getUsedProjects()) {
                try {
                    IProjectPO reusedProject = ProjectPM.loadReusedProject((IReusedProjectPO)reused);
                    if (reusedProject == null) continue;
                    long reusedId = reusedProject.getId();
                    totalWork = (int)((long)totalWork + NodePM.getNumNodes((long)reusedId, (EntityManager)masterSession));
                    totalWork = (int)((long)totalWork + NodePM.getNumTestDataManagers((long)reusedId, (EntityManager)masterSession));
                    totalWork = (int)((long)totalWork + NodePM.getNumExecTestCases((long)reusedId, (EntityManager)masterSession));
                }
                catch (JBException jBException) {}
            }
            return totalWork;
        }

        private void load(IProjectPO proj, IProgressMonitor monitor) throws InterruptedException {
            if (proj == null) {
                Plugin.stopLongRunning();
                this.showErrorDialog(Messages.OpenProjectActionInternalError);
                return;
            }
            try {
                try {
                    Plugin.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            Plugin.closeAllOpenedJubulaEditors(false);
                        }
                    });
                    IProjectPO prevProj = GeneralStorage.getInstance().getProject();
                    ProjectPM.loadProjectInROSession((IProjectPO)proj);
                    try {
                        IProjectPO project = GeneralStorage.getInstance().getProject();
                        try {
                            UsedToolkitBP.getInstance().refreshToolkitInfo(project);
                        }
                        catch (PMException e1) {
                            PMExceptionHandler.handlePMExceptionForMasterSession(e1);
                        }
                        catch (ProjectDeletedException projectDeletedException) {
                            PMExceptionHandler.handleProjectDeletedException();
                        }
                        if (monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                    }
                    catch (ConfigXmlException ce) {
                        if (prevProj == null) {
                            GeneralStorage.getInstance().reset();
                        } else {
                            ProjectPM.loadProjectInROSession((IProjectPO)prevProj);
                        }
                        throw ce;
                    }
                }
                catch (PMReadException pMReadException) {
                    this.showErrorDialog(Messages.ErrorMessageCantReadProject);
                    Plugin.stopLongRunning();
                }
                catch (OperationCanceledException operationCanceledException) {
                    Utils.clearClient();
                    Plugin.stopLongRunning();
                }
            }
            finally {
                Plugin.stopLongRunning();
            }
        }

        public void handleOperationException() {
            IProjectPO clearedProject = GeneralStorage.getInstance().getProject();
            if (clearedProject != null) {
                Utils.clearClient();
                GeneralStorage.getInstance().setProject(null);
                DataEventDispatcher ded = DataEventDispatcher.getInstance();
                ded.fireDataChangedListener((IPersistentObject)clearedProject, DataEventDispatcher.DataState.Deleted, DataEventDispatcher.UpdateState.all);
            }
        }

        private boolean checkProjectToolkits(IProjectPO proj) throws PMException {
            Set usedToolkits = UsedToolkitBP.getInstance().readUsedToolkitsFromDB(proj);
            return ToolkitBP.getInstance().checkXMLVersion(usedToolkits);
        }

        private void handleCapDataNotFound(ConfigXmlException ce) {
            ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_LOAD_PROJECT_CONFIG_CONFLICT, null, (String[])new String[]{ce.getMessage()});
        }

        private void showErrorDialog(String message) {
            ErrorHandlingUtil.createMessageDialog((JBException)new JBException(message, MessageIDs.E_UNEXPECTED_EXCEPTION), null, (String[])new String[]{message});
        }

        protected void errorOccured() {
            Plugin.stopLongRunning();
        }
    }
}

