/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.provider.contentprovider;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.IReusedProjectPO;
import org.eclipse.jubula.client.core.model.ISpecObjContPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.ProjectPM;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.provider.contentprovider.AbstractTreeViewContentProvider;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.internal.exception.JBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCaseBrowserContentProvider
extends AbstractTreeViewContentProvider {
    private static final Logger LOG = LoggerFactory.getLogger(TestCaseBrowserContentProvider.class);

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ISpecObjContPO[]) {
            return new Object[]{((ISpecObjContPO[])parentElement)[0]};
        }
        if (parentElement instanceof ISpecObjContPO) {
            ISpecObjContPO specObjects = (ISpecObjContPO)parentElement;
            ArrayList elements = new ArrayList();
            elements.addAll(specObjects.getSpecObjList());
            IProjectPO activeProject = GeneralStorage.getInstance().getProject();
            if (activeProject != null) {
                elements.addAll(activeProject.getUsedProjects());
            } else {
                LOG.error(Messages.TestCaseBrowser_NoActiveProject);
            }
            return elements.toArray();
        }
        if (parentElement instanceof IExecTestCasePO) {
            ISpecTestCasePO referencedTestCase = ((IExecTestCasePO)parentElement).getSpecTestCase();
            if (referencedTestCase != null) {
                return ArrayUtils.addAll((Object[])Collections.unmodifiableCollection(referencedTestCase.getAllEventEventExecTC()).toArray(), (Object[])referencedTestCase.getUnmodifiableNodeList().toArray());
            }
            return ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        if (parentElement instanceof INodePO) {
            INodePO parentNode = (INodePO)parentElement;
            Object[] children = parentNode.getUnmodifiableNodeList().toArray();
            if (parentElement instanceof ISpecTestCasePO) {
                children = ArrayUtils.addAll((Object[])Collections.unmodifiableCollection(((ISpecTestCasePO)parentElement).getAllEventEventExecTC()).toArray(), (Object[])children);
            }
            return children;
        }
        if (parentElement instanceof IReusedProjectPO) {
            try {
                IProjectPO reusedProject = ProjectPM.loadReusedProjectInMasterSession((IReusedProjectPO)((IReusedProjectPO)parentElement));
                if (reusedProject != null) {
                    return reusedProject.getSpecObjCont().getSpecObjList().toArray();
                }
                return ArrayUtils.EMPTY_OBJECT_ARRAY;
            }
            catch (JBException e) {
                ErrorHandlingUtil.createMessageDialog((JBException)e, null, null);
                return ArrayUtils.EMPTY_OBJECT_ARRAY;
            }
        }
        return ArrayUtils.EMPTY_OBJECT_ARRAY;
    }
}

