/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesDecorator;
import org.eclipse.jubula.client.core.businessprocess.IParamNameMapper;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameCache;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBP;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBPDecorator;
import org.eclipse.jubula.client.core.businessprocess.ProjectComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.ProjectNameBP;
import org.eclipse.jubula.client.core.model.IAUTConfigPO;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PMSaveException;
import org.eclipse.jubula.client.core.persistence.ProjectPM;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.databinding.validators.AutIdValidator;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.wizards.pages.AUTSettingWizardPage;
import org.eclipse.jubula.client.ui.rcp.wizards.pages.AutConfigSettingWizardPage;
import org.eclipse.jubula.client.ui.rcp.wizards.pages.ProjectSettingWizardPage;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.internal.exception.JBException;
import org.eclipse.jubula.tools.internal.exception.ProjectDeletedException;
import org.eclipse.jubula.tools.internal.jarutils.IVersion;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ToolkitDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectWizard
extends Wizard
implements INewWizard {
    private static final String PROJECT_SETTING_WP = "org.eclipse.jubula.client.ui.rcp.wizards.pages.ProjectSettingWizardPage";
    private static final String AUT_SETTING_WP = "org.eclipse.jubula.client.ui.rcp.wizards.pages.AUTSettingWizardPage";
    private static final String AUT_CONFIG_SETTING_WP = "org.eclipse.jubula.client.ui.rcp.wizards.pages.AutConfigSettingWizardPage";
    private static final String LIBRARY_PREFIX = "unbound_modules_";
    private static Logger log = LoggerFactory.getLogger(ProjectWizard.class);
    private IProjectPO m_newProject;
    private IAUTMainPO m_autMain;
    private IAUTConfigPO m_autConfig;
    private ProjectSettingWizardPage m_projectSettingWizardPage;
    private AUTSettingWizardPage m_autSettingWizardPage;
    private AutConfigSettingWizardPage m_autConfigSettingWizardPage;

    public ProjectSettingWizardPage getProjectSettingWizardPage() {
        return this.m_projectSettingWizardPage;
    }

    public AUTSettingWizardPage getAutSettingWizardPage() {
        return this.m_autSettingWizardPage;
    }

    public String getAutConfigSettingWpID() {
        return AUT_CONFIG_SETTING_WP;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(Messages.ProjectWizardNewProjectWizard);
        this.setDefaultPageImageDescriptor(IconConstants.PROJECT_WIZARD_IMAGE_DESCRIPTOR);
        this.setNeedsProgressMonitor(true);
        this.setHelpAvailable(true);
    }

    public boolean performFinish() {
        final String name = this.m_projectSettingWizardPage.getNewProjectName();
        if (ProjectPM.doesProjectNameExist((String)name)) {
            ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_PROJECTNAME_ALREADY_EXISTS, (Object[])new Object[]{name}, null);
            return false;
        }
        try {
            PlatformUI.getWorkbench().getProgressService().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InterruptedException {
                    monitor.beginTask(NLS.bind((String)Messages.ProjectWizardCreatingProject, (Object)name), -1);
                    try {
                        ProjectWizard.this.createNewProject(name, monitor);
                        ProjectWizard.this.m_newProject = null;
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException ite) {
            log.error(ite.getLocalizedMessage(), ite.getCause());
        }
        catch (InterruptedException interruptedException) {}
        return true;
    }

    public boolean performCancel() {
        this.m_newProject = null;
        Plugin.stopLongRunning();
        ProjectNameBP.getInstance().clearCache();
        return true;
    }

    public void addPages() {
        Plugin.startLongRunning();
        this.m_newProject = NodeMaker.createProjectPO((String)"", (Integer)IVersion.JB_CLIENT_METADATA_VERSION);
        this.m_autMain = PoMaker.createAUTMainPO((String)"");
        this.m_newProject.addAUTMain(this.m_autMain);
        this.m_autConfig = PoMaker.createAUTConfigPO();
        this.m_autMain.addAutConfigToSet(this.m_autConfig);
        AutIdValidator autIdValidator = new AutIdValidator(this.m_newProject, null, this.m_autConfig);
        this.m_projectSettingWizardPage = new ProjectSettingWizardPage(PROJECT_SETTING_WP, this.m_newProject);
        this.m_projectSettingWizardPage.setTitle(Messages.ProjectWizardProjectSettings);
        this.m_projectSettingWizardPage.setDescription(Messages.ProjectWizardNewProject);
        this.addPage((IWizardPage)this.m_projectSettingWizardPage);
        this.m_autSettingWizardPage = new AUTSettingWizardPage(AUT_SETTING_WP, this.m_newProject, this.m_autMain);
        this.m_autSettingWizardPage.setTitle(Messages.ProjectWizardAutSettings);
        this.m_autSettingWizardPage.setDescription(Messages.ProjectWizardNewAUT);
        this.m_autSettingWizardPage.setPageComplete(true);
        this.addPage((IWizardPage)this.m_autSettingWizardPage);
        this.m_autConfigSettingWizardPage = new AutConfigSettingWizardPage(AUT_CONFIG_SETTING_WP, this.m_autConfig, autIdValidator);
        this.m_autConfigSettingWizardPage.setTitle(Messages.ProjectWizardAutSettings);
        this.m_autConfigSettingWizardPage.setDescription(Messages.ProjectWizardAUTData);
        this.m_autConfigSettingWizardPage.setPageComplete(true);
        this.addPage((IWizardPage)this.m_autConfigSettingWizardPage);
        Plugin.stopLongRunning();
    }

    private void createNewProject(String newProjectName, IProgressMonitor monitor) throws InterruptedException {
        Plugin.closeAllOpenedJubulaEditors(false);
        this.m_newProject.setIsReusable(this.m_projectSettingWizardPage.isProjectReusable());
        this.m_newProject.setIsProtected(this.m_projectSettingWizardPage.isProjectProtected());
        if (this.m_autMain.getName() == null || "".equals(this.m_autMain.getName())) {
            this.m_newProject.removeAUTMain(this.m_autMain);
        }
        if (this.m_autConfig.getName() == null || "".equals(this.m_autConfig.getName())) {
            this.m_autMain.removeAutConfig(this.m_autConfig);
        }
        ParamNameBPDecorator paramNameMapper = new ParamNameBPDecorator((IParamNameMapper)ParamNameBP.getInstance());
        ProjectComponentNameMapper compNamesMapper = new ProjectComponentNameMapper((IWritableComponentNameCache)new ComponentNamesDecorator(null), this.m_newProject);
        ArrayList<ParamNameBPDecorator> mapperList = new ArrayList<ParamNameBPDecorator>();
        ArrayList<ProjectComponentNameMapper> compNameCacheList = new ArrayList<ProjectComponentNameMapper>();
        this.addUnboundModules(this.m_newProject);
        mapperList.add(paramNameMapper);
        compNameCacheList.add(compNamesMapper);
        try {
            GeneralStorage.getInstance().reset();
            ProjectPM.attachProjectToROSession((IProjectPO)this.m_newProject, (String)newProjectName, mapperList, compNameCacheList, (IProgressMonitor)monitor);
        }
        catch (PMSaveException e) {
            PMExceptionHandler.handlePMExceptionForMasterSession((PMException)((Object)new PMSaveException(e.getMessage(), MessageIDs.E_CREATE_NEW_PROJECT_FAILED)));
        }
        catch (PMException e) {
            PMExceptionHandler.handlePMExceptionForMasterSession(e);
        }
        catch (ProjectDeletedException projectDeletedException) {
            PMExceptionHandler.handleProjectDeletedException();
        }
        catch (InterruptedException ie) {
            throw ie;
        }
    }

    private void addUnboundModules(IProjectPO newProject) {
        ToolkitDescriptor desc = ComponentBuilder.getInstance().getCompSystem().getToolkitDescriptor(newProject.getToolkit());
        while (desc != null) {
            try {
                String moduleName = LIBRARY_PREFIX + desc.getName();
                IProjectPO ubmProject = ProjectPM.loadLatestVersionOfProjectByName((String)moduleName);
                if (ubmProject != null) {
                    newProject.addUsedProject(PoMaker.createReusedProjectPO((IProjectPO)ubmProject));
                } else if (log.isInfoEnabled()) {
                    log.info(String.valueOf(Messages.Project) + " " + "'" + moduleName + "'" + Messages.DoesNotExist + ".");
                }
            }
            catch (JBException e) {
                log.error((Object)((Object)e) + ":" + " " + e.getMessage());
            }
            desc = ComponentBuilder.getInstance().getCompSystem().getToolkitDescriptor(desc.getIncludes());
        }
    }

    public boolean canFinish() {
        return this.getContainer().getCurrentPage().isPageComplete();
    }

    public IAUTMainPO getAutMain() {
        return this.m_autMain;
    }
}

