/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.commands;

import org.apache.commons.lang.Validate;
import org.eclipse.jubula.communication.internal.ICommand;
import org.eclipse.jubula.communication.internal.message.CAPTestMessage;
import org.eclipse.jubula.communication.internal.message.CAPTestResponseMessage;
import org.eclipse.jubula.communication.internal.message.Message;
import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.rc.common.AUTServer;
import org.eclipse.jubula.rc.common.AUTServerConfiguration;
import org.eclipse.jubula.rc.common.exception.ComponentNotFoundException;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.exception.StepVerifyFailedException;
import org.eclipse.jubula.rc.common.exception.UnsupportedComponentException;
import org.eclipse.jubula.rc.common.util.Verifier;
import org.eclipse.jubula.tools.internal.i18n.CompSystemI18n;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.tools.internal.objects.event.EventFactory;
import org.eclipse.jubula.tools.internal.utils.TimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CapTestCommand
implements ICommand {
    private static final Logger LOG = LoggerFactory.getLogger(CapTestCommand.class);
    private CAPTestMessage m_capTestMessage;

    public Message getMessage() {
        return this.m_capTestMessage;
    }

    public void setMessage(Message message) {
        this.m_capTestMessage = (CAPTestMessage)message;
    }

    private void handleComponentNotFound(CAPTestResponseMessage response, Throwable e) {
        if (LOG.isWarnEnabled()) {
            LOG.warn(e.getLocalizedMessage(), e);
        }
        response.setTestErrorEvent(EventFactory.createComponentNotFoundErrorEvent());
    }

    private void handleInvalidInput(String e) {
        throw new StepExecutionException(e, EventFactory.createImplClassErrorEvent());
    }

    protected Object getImplClass(CAPTestResponseMessage response) {
        Object implClass = null;
        MessageCap messageCap = this.m_capTestMessage.getMessageCap();
        IComponentIdentifier ci = messageCap.getCi();
        if (LOG.isInfoEnabled()) {
            LOG.info("component class name: " + (ci == null ? "(none)" : ci.getComponentClassName()));
        }
        try {
            if (!messageCap.hasDefaultMapping()) {
                Validate.notNull((Object)ci);
            }
            int timeout = 500;
            boolean isWaitForComponent = "rcWaitForComponent".equals(messageCap.getMethod());
            if (isWaitForComponent) {
                MessageParam timeoutParam = (MessageParam)messageCap.getMessageParams().get(0);
                try {
                    timeout = Integer.parseInt(timeoutParam.getValue());
                }
                catch (NumberFormatException e) {
                    LOG.warn("Error while parsing timeout parameter. Using default value.", (Throwable)e);
                }
            }
            AUTServerConfiguration rcConfig = AUTServerConfiguration.getInstance();
            if (!messageCap.hasDefaultMapping()) {
                Object component = AUTServer.getInstance().findComponent(ci, timeout);
                implClass = rcConfig.prepareImplementationClass(component, component.getClass());
            } else {
                implClass = rcConfig.getImplementationClass(ci.getComponentClassName());
            }
            if (isWaitForComponent) {
                MessageParam delayParam = (MessageParam)messageCap.getMessageParams().get(1);
                try {
                    int delay = Integer.parseInt(delayParam.getValue());
                    TimeUtil.delay((long)delay);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.handleInvalidInput("Invalid input: " + CompSystemI18n.getString((String)"CompSystem.DelayAfterVisibility") + " must be a non-negative integer.");
                }
            }
        }
        catch (IllegalArgumentException e) {
            this.handleComponentNotFound(response, e);
        }
        catch (ComponentNotFoundException e) {
            if ("rcVerifyExists".equals(messageCap.getMethod())) {
                MessageParam isVisibleParam = (MessageParam)messageCap.getMessageParams().get(0);
                this.handleComponentDoesNotExist(response, Boolean.valueOf(isVisibleParam.getValue()));
            } else {
                this.handleComponentNotFound(response, (Throwable)((Object)e));
            }
        }
        catch (UnsupportedComponentException buce) {
            LOG.error(buce.getLocalizedMessage(), (Throwable)((Object)buce));
            response.setTestErrorEvent(EventFactory.createConfigErrorEvent());
        }
        catch (Throwable e) {
            if (LOG.isErrorEnabled()) {
                LOG.error(e.getLocalizedMessage(), e);
            }
            response.setTestErrorEvent(EventFactory.createImplClassErrorEvent());
        }
        return implClass;
    }

    private void handleComponentDoesNotExist(CAPTestResponseMessage response, boolean shouldExist) {
        try {
            Verifier.equals(shouldExist, false);
        }
        catch (StepVerifyFailedException stepVerifyFailedException) {
            response.setTestErrorEvent(EventFactory.createVerifyFailed((String)String.valueOf(shouldExist), (String)String.valueOf(false)));
        }
    }

    /*
     * Exception decompiling
     */
    public Message execute() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void timeout() {
        LOG.error(String.valueOf(this.getClass().getName()) + "timeout() called");
    }
}

