/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.tester;

import java.util.Arrays;
import java.util.LinkedList;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.DragAndDropHelper;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.tester.AbstractTextVerifiableTester;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.IListComponent;
import org.eclipse.jubula.rc.common.util.IndexConverter;
import org.eclipse.jubula.rc.common.util.ListSelectionVerifier;
import org.eclipse.jubula.rc.common.util.MatchUtil;
import org.eclipse.jubula.rc.common.util.SelectionUtil;
import org.eclipse.jubula.rc.common.util.Verifier;
import org.eclipse.jubula.toolkit.enums.ValueSets;
import org.eclipse.jubula.tools.internal.objects.event.EventFactory;
import org.eclipse.jubula.tools.internal.utils.StringParsing;

public class ListTester
extends AbstractTextVerifiableTester {
    private String[] split(String values, String separator) {
        String[] list = StringParsing.splitToArray((String)values, (char)(separator == null || separator.length() == 0 ? (char)',' : separator.charAt(0)), (char)'\\');
        list = StringUtils.stripAll((String[])list);
        return list;
    }

    private int[] getCheckedSelectedIndices() throws StepExecutionException {
        int[] selected = this.getListAdapter().getSelectedIndices();
        SelectionUtil.validateSelection(selected);
        return selected;
    }

    private IListComponent getListAdapter() {
        return (IListComponent)this.getComponent();
    }

    public void rcVerifySelectedIndex(String index, boolean expectSelected) {
        int implIndex;
        int[] selected = this.getCheckedSelectedIndices();
        boolean isSelected = ArrayUtils.contains((int[])selected, (int)(implIndex = IndexConverter.toImplementationIndex(Integer.parseInt(index))));
        if (expectSelected != isSelected) {
            throw new StepExecutionException("Selection check failed for index: " + index, EventFactory.createVerifyFailed((String)String.valueOf(expectSelected), (String)String.valueOf(isSelected)));
        }
    }

    public void rcVerifySelectedValue(String valueList) {
        this.rcVerifySelectedValue(valueList, MatchUtil.DEFAULT_OPERATOR, true);
    }

    public void rcVerifySelectedValue(String value, String operator, boolean isSelected) {
        String[] current = this.getListAdapter().getSelectedValues();
        ListSelectionVerifier listSelVerifier = new ListSelectionVerifier();
        int i = 0;
        while (i < current.length) {
            listSelVerifier.addItem(i, current[i], true);
            ++i;
        }
        listSelVerifier.verifySelection(value, operator, isSelected);
    }

    public void rcVerifyText(String text, String operator) {
        Object[] selected = this.getListAdapter().getSelectedValues();
        int selCount = selected.length;
        SelectionUtil.validateSelection(selected);
        int i = 0;
        while (i < selCount) {
            Verifier.match((String)selected[i], text, operator);
            ++i;
        }
    }

    public void rcSelectIndex(String indexList, String extendSelection, int button, int clickCount) {
        this.selectIndices(IndexConverter.toImplementationIndices(this.parseIndices(indexList)), ClickOptions.create().setClickCount(clickCount).setMouseButton(button).setClickModifier(this.getClickModifier(extendSelection)));
    }

    public void rcSelectValue(String valueList, String operator, String searchType, String extendSelection, int button, int clickCount) {
        this.selectValue(valueList, String.valueOf(','), operator, searchType, ClickOptions.create().setClickCount(clickCount).setMouseButton(button).setClickModifier(this.getClickModifier(extendSelection)));
    }

    public void rcVerifyContainsValue(String value) {
        Verifier.equals(true, this.containsValue(value));
    }

    public void rcVerifyContainsValue(String value, String operator, boolean exists) {
        Verifier.equals(exists, this.containsValue(value, operator));
    }

    public String rcReadValue(String variable) {
        Object[] selected = this.getListAdapter().getSelectedValues();
        SelectionUtil.validateSelection(selected);
        return selected[0];
    }

    public void rcDragValue(int mouseButton, String modifier, String value, String operator, String searchType) {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        dndHelper.setModifier(modifier);
        dndHelper.setMouseButton(mouseButton);
        Integer[] indices = this.findIndicesOfValues(new String[]{value}, operator, searchType);
        this.selectIndices(ArrayUtils.toPrimitive((Integer[])indices), ClickOptions.create().setClickCount(0));
        this.pressOrReleaseModifiers(modifier, true);
        this.getRobot().mousePress(null, null, mouseButton);
    }

    public void rcDropValue(String value, String operator, String searchType, int delayBeforeDrop) {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        try {
            Integer[] indices = this.findIndicesOfValues(new String[]{value}, operator, searchType);
            this.selectIndices(ArrayUtils.toPrimitive((Integer[])indices), ClickOptions.create().setClickCount(0));
            ListTester.waitBeforeDrop(delayBeforeDrop);
        }
        finally {
            this.getRobot().mouseRelease(null, null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
        }
    }

    public void rcDragIndex(int mouseButton, String modifier, int index) {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        dndHelper.setModifier(modifier);
        dndHelper.setMouseButton(mouseButton);
        this.selectIndices(new int[]{IndexConverter.toImplementationIndex(index)}, ClickOptions.create().setClickCount(0));
        this.pressOrReleaseModifiers(modifier, true);
        this.getRobot().mousePress(null, null, mouseButton);
    }

    public void rcDropIndex(int index, int delayBeforeDrop) {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        try {
            this.selectIndices(new int[]{IndexConverter.toImplementationIndex(index)}, ClickOptions.create().setClickCount(0));
            ListTester.waitBeforeDrop(delayBeforeDrop);
        }
        finally {
            this.getRobot().mouseRelease(null, null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
        }
    }

    public boolean containsValue(String value) {
        Integer[] indices = this.findIndicesOfValues(new String[]{value}, MatchUtil.EQUALS, ValueSets.SearchType.absolute.rcValue());
        return indices.length > 0;
    }

    public boolean containsValue(String value, String operator) {
        Integer[] indices = null;
        if (operator.equals(MatchUtil.NOT_EQUALS)) {
            indices = this.findIndicesOfValues(new String[]{value}, MatchUtil.EQUALS, ValueSets.SearchType.absolute.rcValue());
            return indices.length == 0;
        }
        indices = this.findIndicesOfValues(new String[]{value}, operator, ValueSets.SearchType.absolute.rcValue());
        return indices.length > 0;
    }

    private void selectValue(String valueList, String separator, String operator, String searchType, ClickOptions co) {
        String[] values = null;
        values = "".equals(valueList) ? new String[]{""} : this.split(valueList, separator);
        Object[] indices = this.findIndicesOfValues(values, operator, searchType);
        Arrays.sort(indices);
        if (!operator.equals(MatchUtil.NOT_EQUALS) && indices.length < values.length) {
            throw new StepExecutionException("One or more values not found of set: " + Arrays.asList(values).toString(), EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
        this.selectIndices(ArrayUtils.toPrimitive((Integer[])indices), co);
    }

    private int[] parseIndices(String indexList) {
        String[] list = StringParsing.splitToArray((String)indexList, (char)',', (char)'\\');
        int[] indices = new int[list.length];
        int i = 0;
        while (i < list.length) {
            indices[i] = IndexConverter.intValue(list[i]);
            ++i;
        }
        return indices;
    }

    private void selectIndices(int[] indices, ClickOptions co) {
        int indexToStart = 0;
        int noOfItemsToSelect = indices.length;
        ClickOptions.ClickModifier currentClickModifier = co.getClickModifier();
        boolean isExtendSelection = currentClickModifier.hasModifiers(1);
        IListComponent listAdapter = this.getListAdapter();
        if (!isExtendSelection) {
            if (noOfItemsToSelect > 0) {
                listAdapter.clickOnIndex(indices[0], co);
            }
            ++indexToStart;
        }
        if (noOfItemsToSelect > 1) {
            currentClickModifier.add(1);
        }
        int i = indexToStart;
        while (i < noOfItemsToSelect) {
            listAdapter.clickOnIndex(indices[i], co);
            ++i;
        }
    }

    public String[] getTextArrayFromComponent() {
        return null;
    }

    private Integer[] findIndicesOfValues(String[] values, String operator, String searchType) {
        String[] listValues = this.getListAdapter().getValues();
        int startIndex = this.getStartingIndex(searchType);
        int valuesCount = values.length;
        LinkedList<Integer> indexList = new LinkedList<Integer>();
        MatchUtil matchUtil = MatchUtil.getInstance();
        int i = 0;
        while (i < valuesCount) {
            String value = values[i];
            int j = startIndex;
            while (j < listValues.length) {
                String listItem = listValues[j];
                if (matchUtil.match(listItem, value, operator)) {
                    indexList.add(j);
                }
                ++j;
            }
            ++i;
        }
        return indexList.toArray(new Integer[indexList.size()]);
    }

    private int getStartingIndex(String searchType) {
        int[] selectedIndices;
        int startingIndex = 0;
        if (searchType.equalsIgnoreCase(ValueSets.SearchType.relative.rcValue()) && (selectedIndices = this.getListAdapter().getSelectedIndices()).length > 0) {
            startingIndex = selectedIndices[selectedIndices.length - 1] + 1;
        }
        return startingIndex;
    }
}

