/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.javafx.components;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.collections.ObservableList;
import org.eclipse.jubula.rc.common.components.AUTComponent;
import org.eclipse.jubula.rc.javafx.components.ChildrenGetter;
import org.eclipse.jubula.rc.javafx.components.ChildrenListenerHelper;

public class JavaFXComponent
extends AUTComponent {
    private Object m_realComponent;
    private Class<?> m_type;

    public JavaFXComponent(Object component) {
        super(component);
        this.m_type = component.getClass();
        this.m_realComponent = component;
        this.addChangeListener();
    }

    public Object getRealComponent() {
        return this.m_realComponent;
    }

    public Class<?> getRealComponentType() {
        return this.m_type;
    }

    public void addChangeListener() {
        Object children = ChildrenGetter.getAsRealType(this.m_realComponent);
        if (children instanceof ReadOnlyObjectProperty) {
            ChildrenListenerHelper.addListener((ReadOnlyObjectProperty)children);
        } else if (children instanceof ObservableList) {
            ChildrenListenerHelper.addListener((ObservableList)children);
        }
    }

    public void removeChangeListener() {
        Object children = ChildrenGetter.getAsRealType(this.m_realComponent);
        if (children instanceof ObjectProperty) {
            ChildrenListenerHelper.removeListener((ObjectProperty)children);
        } else if (children instanceof ObservableList) {
            ChildrenListenerHelper.removeListener((ObservableList)children);
        }
    }
}

