/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.javafx.driver;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javafx.application.Platform;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.rc.common.driver.IEventThreadQueuer;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;

public class EventThreadQueuerJavaFXImpl
implements IEventThreadQueuer {
    private static AutServerLogger log = new AutServerLogger(EventThreadQueuerJavaFXImpl.class);

    public static <V> V invokeAndWait(String name, Callable<V> call) {
        if (Platform.isFxApplicationThread()) {
            try {
                return call.call();
            }
            catch (Exception e) {
                Throwable thrown = e.getCause();
                if (thrown == null) {
                    thrown = e;
                }
                if (thrown instanceof StepExecutionException) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)e);
                    }
                    throw (StepExecutionException)thrown;
                }
                log.error((Object)("exception thrown by '" + name + "':"), thrown);
                throw new StepExecutionException(thrown);
            }
        }
        try {
            FutureTask<V> task = new FutureTask<V>(call);
            Platform.runLater(task);
            return task.get();
        }
        catch (InterruptedException ie) {
            log.error((Object)ie);
            throw new StepExecutionException((Throwable)ie);
        }
        catch (ExecutionException ee) {
            Throwable thrown = ee.getCause();
            if (thrown instanceof StepExecutionException) {
                if (log.isInfoEnabled()) {
                    log.info((Object)ee);
                }
                throw (StepExecutionException)thrown;
            }
            log.error((Object)("exception thrown by '" + name + "':"), thrown);
            throw new StepExecutionException(thrown);
        }
    }

    public static void waitForIdle() {
        EventThreadQueuerJavaFXImpl.invokeAndWait("waitForIdle", new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                return null;
            }
        });
    }

    public static void checkEventThread() throws IllegalStateException {
        if (!Platform.isFxApplicationThread()) {
            throw new IllegalStateException("Not on FX application thread; currentThread = " + Thread.currentThread().getName());
        }
    }

    public static void checkNotEventThread() throws IllegalStateException {
        if (Platform.isFxApplicationThread()) {
            throw new IllegalStateException("On FX application thread, although this is not allowed.");
        }
    }

    public Object invokeAndWait(String name, final IRunnable runnable) {
        return EventThreadQueuerJavaFXImpl.invokeAndWait(name, new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return runnable.run();
            }
        });
    }

    public void invokeLater(String name, Runnable runnable) {
        Validate.notNull((Object)runnable, (String)"runnable must not be null");
        Platform.runLater((Runnable)runnable);
    }
}

