/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.javafx.listener;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReentrantLock;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Skinnable;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import org.eclipse.jubula.rc.common.AUTServerConfiguration;
import org.eclipse.jubula.rc.common.adaptable.AdapterFactoryRegistry;
import org.eclipse.jubula.rc.common.exception.ComponentNotFoundException;
import org.eclipse.jubula.rc.common.exception.ComponentNotManagedException;
import org.eclipse.jubula.rc.common.exception.NoIdentifierForComponentException;
import org.eclipse.jubula.rc.common.listener.BaseAUTListener;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.javafx.components.AUTJavaFXHierarchy;
import org.eclipse.jubula.rc.javafx.components.CurrentStages;
import org.eclipse.jubula.rc.javafx.components.FindJavaFXComponentBP;
import org.eclipse.jubula.rc.javafx.components.JavaFXComponent;
import org.eclipse.jubula.rc.javafx.driver.EventThreadQueuerJavaFXImpl;
import org.eclipse.jubula.rc.javafx.listener.sync.IStageResizeSync;
import org.eclipse.jubula.rc.javafx.listener.sync.StageResizeSyncFactory;
import org.eclipse.jubula.rc.javafx.tester.adapter.IContainerAdapter;
import org.eclipse.jubula.rc.javafx.util.NodeBounds;
import org.eclipse.jubula.rc.javafx.util.NodeTraverseHelper;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ComponentClass;

public class ComponentHandler
implements ListChangeListener<Stage>,
BaseAUTListener {
    private static AutServerLogger log = new AutServerLogger(ComponentHandler.class);
    private static AUTJavaFXHierarchy hierarchy = new AUTJavaFXHierarchy();
    private static FindJavaFXComponentBP findBP = new FindJavaFXComponentBP();
    private static IStageResizeSync stageResizeSync = StageResizeSyncFactory.instance();
    private static volatile ReentrantLock lock = AUTJavaFXHierarchy.getLock();

    public ComponentHandler() {
        CurrentStages.addStagesListener(this);
    }

    public void onChanged(ListChangeListener.Change<? extends Stage> change) {
        change.next();
        for (final Stage stage : change.getRemoved()) {
            hierarchy.removeComponentFromHierarchy(stage);
        }
        for (final Stage stage : change.getAddedSubList()) {
            stage.addEventFilter(WindowEvent.WINDOW_SHOWN, (EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent event) {
                    hierarchy.createHierarchyFrom(stage);
                    stageResizeSync.register(stage);
                    stage.removeEventFilter(WindowEvent.WINDOW_SHOWN, (EventHandler)this);
                }
            });
        }
    }

    public long[] getEventMask() {
        return null;
    }

    public static AUTJavaFXHierarchy getAutHierarchy() {
        return hierarchy;
    }

    public static <T> List<? extends T> getAssignableFrom(final Class<T> type) {
        return (List)EventThreadQueuerJavaFXImpl.invokeAndWait("getAssignableFrom", new Callable<List<? extends T>>(){

            @Override
            public List<? extends T> call() throws Exception {
                Set keys = hierarchy.getHierarchyMap().keySet();
                ArrayList result = new ArrayList();
                for (JavaFXComponent object : keys) {
                    if (!type.isAssignableFrom(object.getRealComponentType())) continue;
                    result.add(type.cast(object.getRealComponent()));
                }
                return result;
            }
        });
    }

    private static List<Node> getAllNodesforPos(Parent parent, Point2D pos, List<Node> resultList) {
        List<Node> result = resultList;
        if (parent.isVisible()) {
            for (Node child : parent.getChildrenUnmodifiable()) {
                if (!child.isVisible() || !NodeBounds.checkIfContains(pos, child)) continue;
                result.add(child);
                if (!(child instanceof Parent)) continue;
                result = ComponentHandler.getAllNodesforPos((Parent)child, pos, result);
            }
        }
        return result;
    }

    public static Node getComponentByPos(Point2D pos) {
        List<Window> comps = ComponentHandler.getAssignableFrom(Window.class);
        List<Node> matches = new ArrayList<Node>();
        for (Window window : comps) {
            if (!window.isFocused() || !window.isShowing()) continue;
            Parent root = window.getScene().getRoot();
            matches = ComponentHandler.getAllNodesforPos(root, pos, matches);
        }
        ArrayList<Node> result = new ArrayList<Node>();
        for (Node n : matches) {
            if (n.getScene() == null || !ComponentHandler.isSupported(n.getClass()) || !n.isVisible()) continue;
            boolean add = true;
            Parent parent = n.getParent();
            while (parent != null) {
                if (parent instanceof Skinnable || ComponentHandler.isContainer((Node)parent)) {
                    if (ComponentHandler.isContentNode(n, parent)) break;
                    Skin skin = ((Skinnable)parent).getSkin();
                    if (skin instanceof SkinBase) {
                        if (!ComponentHandler.isSkinNode(n, (SkinBase)skin)) continue;
                        add = false;
                        break;
                    }
                    parent = parent.getParent();
                    continue;
                }
                parent = parent.getParent();
            }
            if (!add) continue;
            result.add(n);
        }
        if (result.size() == 0) {
            return null;
        }
        if (result.size() == 1) {
            return (Node)result.get(0);
        }
        return ComponentHandler.filterMatches(result);
    }

    private static boolean isContainer(Node n) {
        IContainerAdapter adapter = (IContainerAdapter)AdapterFactoryRegistry.getInstance().getAdapter(IContainerAdapter.class, (Object)n);
        return adapter != null;
    }

    private static boolean isSupported(Class<?> c) {
        Set supportedTypes = AUTServerConfiguration.getInstance().getSupportedTypes();
        Class<?> currentClass = c;
        while (currentClass != null) {
            for (Object object : supportedTypes) {
                if (!((ComponentClass)object).getName().equals(currentClass.getName())) continue;
                return true;
            }
            currentClass = currentClass.getSuperclass();
        }
        return false;
    }

    private static boolean isContentNode(Node n, Parent parent) {
        IContainerAdapter adapter = (IContainerAdapter)AdapterFactoryRegistry.getInstance().getAdapter(IContainerAdapter.class, (Object)parent);
        if (adapter != null) {
            List<? extends Node> content = adapter.getContent();
            if (content.contains(n)) {
                return true;
            }
            NodeTraverseHelper helper = new NodeTraverseHelper();
            for (Node node : content) {
                if (!(node instanceof Parent) || !helper.isChildOf(n, (Parent)node)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isSkinNode(Node node, SkinBase<?> skin) {
        ObservableList skinChildren = skin.getChildren();
        NodeTraverseHelper help = new NodeTraverseHelper();
        for (Node n : skinChildren) {
            if (n == node) {
                return true;
            }
            if (!(n instanceof Parent) || !help.isChildOf(node, (Parent)n)) continue;
            return true;
        }
        return false;
    }

    private static Node filterMatches(List<Node> matches) {
        List<Node> filteredMatches = ComponentHandler.filterOutUnfocussedNodes(matches);
        if (filteredMatches.size() == 1) {
            return filteredMatches.get(0);
        }
        Node firstCommonAncestor = ComponentHandler.findFirstCommonAncestor(filteredMatches);
        if (firstCommonAncestor != null) {
            return ComponentHandler.topMostDescendant((Parent)firstCommonAncestor, filteredMatches);
        }
        return null;
    }

    private static List<Node> filterOutUnfocussedNodes(List<Node> matches) {
        ArrayList<Node> filteredMatches = new ArrayList<Node>();
        for (Node match : matches) {
            if (!match.getScene().getWindow().isFocused()) continue;
            filteredMatches.add(match);
        }
        return filteredMatches;
    }

    private static List<Node> filterDescendants(Parent parent, List<Node> matches) {
        ArrayList<Node> descendants = new ArrayList<Node>();
        for (Node match : matches) {
            if (!ComponentHandler.isDescendant(match, (Node)parent)) continue;
            descendants.add(match);
        }
        return descendants;
    }

    private static Node topMostDescendant(Parent parent, List<Node> matches) {
        ObservableList children = parent.getChildrenUnmodifiable();
        ArrayList revertedChildren = new ArrayList(children);
        Collections.reverse(revertedChildren);
        for (Node child : revertedChildren) {
            if (child instanceof Parent) {
                List<Node> remainingMatches = ComponentHandler.filterDescendants((Parent)child, matches);
                if (remainingMatches.size() == 1) {
                    return remainingMatches.get(0);
                }
                if (remainingMatches.size() > 1) {
                    return ComponentHandler.topMostDescendant((Parent)child, remainingMatches);
                }
            }
            if (!matches.contains(child)) continue;
            return child;
        }
        return null;
    }

    private static boolean isDescendant(Node candidate, Node node) {
        if (candidate == null) {
            return false;
        }
        if (candidate == node) {
            return true;
        }
        return ComponentHandler.isDescendant((Node)candidate.getParent(), node);
    }

    private static Node findFirstCommonAncestor(List<Node> nodelist) {
        if (nodelist == null || nodelist.size() <= 0) {
            return null;
        }
        if (nodelist.size() == 1) {
            return nodelist.get(0);
        }
        return ComponentHandler.findFirstCommonAncestor(nodelist.get(0), ComponentHandler.findFirstCommonAncestor(nodelist.subList(1, nodelist.size())));
    }

    private static Node findFirstCommonAncestor(Node node1, Node node2) {
        if (node1 == null || node2 == null) {
            return null;
        }
        if (ComponentHandler.isDescendant(node1, node2)) {
            return node2;
        }
        return ComponentHandler.findFirstCommonAncestor(node1, (Node)node2.getParent());
    }

    public static IComponentIdentifier getIdentifier(Node node) throws NoIdentifierForComponentException {
        try {
            return hierarchy.getComponentIdentifier(node);
        }
        catch (ComponentNotManagedException cnme) {
            log.warn((Object)cnme);
            throw new NoIdentifierForComponentException("unable to create an identifier for '" + node + "'", MessageIDs.E_COMPONENT_ID_CREATION);
        }
    }

    public static Node findNodeByID(IComponentIdentifier id) {
        Object comp = findBP.findComponent(id, hierarchy);
        if (comp != null && comp instanceof Node) {
            return (Node)comp;
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public static Object findComponent(IComponentIdentifier componentIdentifier, boolean retry, int timeout) throws ComponentNotFoundException, IllegalArgumentException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void syncStageResize() {
        stageResizeSync.await();
    }
}

