/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.javafx.listener;

import java.util.concurrent.Executor;
import javafx.application.Platform;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import org.eclipse.jubula.rc.javafx.util.concurrent.JBExecutors;

public class MouseMoveDone
implements EventHandler<MouseEvent> {
    private double m_deltaX;
    private double m_deltaY;
    private final long m_threshold;
    private volatile MouseEvent m_lastEvent;
    private Service<MouseEvent> m_timeService;

    public MouseMoveDone(long threshold, double deltaX, double deltaY) {
        this.m_threshold = threshold;
        this.m_deltaX = deltaX;
        this.m_deltaY = deltaY;
        this.m_timeService = new Service<MouseEvent>(){

            protected Task<MouseEvent> createTask() {
                return new WaitingTask();
            }
        };
        this.m_timeService.setExecutor((Executor)JBExecutors.newSingleDaemonThreadExecutor(MouseMoveDone.class.getSimpleName()));
    }

    public void handle(MouseEvent event) {
        if (this.m_lastEvent == null) {
            this.m_lastEvent = event;
        }
        double currDX = Math.abs(event.getSceneX() - this.m_lastEvent.getSceneX());
        double currDY = Math.abs(event.getSceneX() - this.m_lastEvent.getSceneX());
        if (currDX >= this.m_deltaX && currDY >= this.m_deltaY) {
            this.m_timeService.restart();
            this.m_lastEvent = event;
        }
    }

    public void addMoveDoneHandler(final EventHandler<WorkerStateEvent> hl) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                MouseMoveDone.this.m_timeService.setOnSucceeded(hl);
            }
        });
    }

    public void removeMoveDoneHandler(final EventHandler<WorkerStateEvent> hl) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                MouseMoveDone.this.m_timeService.removeEventHandler(WorkerStateEvent.WORKER_STATE_SUCCEEDED, hl);
            }
        });
    }

    private class WaitingTask
    extends Task<MouseEvent> {
        private WaitingTask() {
        }

        protected MouseEvent call() throws Exception {
            Thread.sleep(MouseMoveDone.this.m_threshold);
            return MouseMoveDone.this.m_lastEvent;
        }
    }
}

