/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.javafx.tester;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.stage.WindowEvent;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.listener.EventLock;
import org.eclipse.jubula.rc.common.tester.AbstractMenuTester;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.IComponent;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.IMenuComponent;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.IMenuItemComponent;
import org.eclipse.jubula.rc.javafx.driver.EventThreadQueuerJavaFXImpl;
import org.eclipse.jubula.rc.javafx.listener.ComponentHandler;
import org.eclipse.jubula.rc.javafx.tester.adapter.MenuAdapter;
import org.eclipse.jubula.rc.javafx.tester.adapter.MenuItemAdapter;
import org.eclipse.jubula.tools.internal.objects.event.EventFactory;

public class MenuTester
extends AbstractMenuTester {
    public String[] getTextArrayFromComponent() {
        return null;
    }

    protected IMenuItemComponent newMenuItemAdapter(Object component) {
        return new MenuItemAdapter<MenuItem>((MenuItem)component);
    }

    protected void closeMenu(IMenuComponent menu, String[] textPath, String operator) {
        boolean successful;
        IMenuComponent currMenu = menu;
        ArrayList<IMenuComponent> openMenus = new ArrayList<IMenuComponent>();
        String[] stringArray = textPath;
        int n = textPath.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            IMenuItemComponent[] items = currMenu.getItems();
            int index = this.getIndexForName(currMenu, name, operator);
            IMenuItemComponent item = null;
            int j = index;
            while (j < items.length) {
                item = items[j];
                if (!item.isSeparator() && item.isEnabled() && item.isShowing()) break;
                ++j;
            }
            if (item != null && item.hasSubMenu()) {
                currMenu = new MenuAdapter((Menu)item.getRealComponent());
                openMenus.add(currMenu);
            }
            ++n2;
        }
        int i = openMenus.size() - 1;
        while (i >= 0) {
            boolean successful2 = this.waitForMenuToClose((Menu)((IMenuComponent)openMenus.get(i)).getRealComponent());
            if (!successful2) {
                throw new StepExecutionException("Popup could not be closed", EventFactory.createActionError((String)"TestErrorEvent.PopupNotFound"));
            }
            --i;
        }
        if (menu.getRealComponent() instanceof ContextMenu && !(successful = this.closeContextMenu((ContextMenu)menu.getRealComponent()))) {
            throw new StepExecutionException("Popup could not be closed", EventFactory.createActionError((String)"TestErrorEvent.PopupNotFound"));
        }
    }

    protected void closeMenu(IMenuComponent menu, int[] path) {
        boolean successful;
        IMenuComponent currMenu = menu;
        ArrayList<IMenuComponent> openMenus = new ArrayList<IMenuComponent>();
        int[] nArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            IMenuItemComponent[] items = currMenu.getItems();
            IMenuItemComponent item = null;
            int j = index;
            while (j < items.length) {
                item = items[j];
                if (!item.isSeparator() && item.isEnabled() && item.isShowing()) break;
                ++j;
            }
            if (item != null && !item.isSeparator() && item.isEnabled() && item.isShowing() && item.hasSubMenu()) {
                currMenu = new MenuAdapter((Menu)item.getRealComponent());
                openMenus.add(currMenu);
            }
            ++n2;
        }
        int i = openMenus.size() - 1;
        while (i >= 0) {
            boolean successful2 = this.waitForMenuToClose((Menu)((IMenuComponent)openMenus.get(i)).getRealComponent());
            if (!successful2) {
                throw new StepExecutionException("Popup could not be closed", EventFactory.createActionError((String)"TestErrorEvent.PopupNotFound"));
            }
            --i;
        }
        if (menu.getRealComponent() instanceof ContextMenu && !(successful = this.closeContextMenu((ContextMenu)menu.getRealComponent()))) {
            throw new StepExecutionException("Popup could not be closed", EventFactory.createActionError((String)"TestErrorEvent.PopupNotFound"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean closeContextMenu(final ContextMenu m) {
        boolean successful;
        block8: {
            EventHandler<Event> shownHandler;
            block7: {
                final EventLock eventLock = new EventLock();
                shownHandler = new EventHandler<Event>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void handle(Event event) {
                        EventLock eventLock2 = eventLock;
                        synchronized (eventLock2) {
                            eventLock.notifyAll();
                        }
                    }
                };
                EventThreadQueuerJavaFXImpl.invokeAndWait("addCloseHandler", new Callable<Void>((EventHandler)shownHandler){
                    private final /* synthetic */ EventHandler val$shownHandler;
                    {
                        this.val$shownHandler = eventHandler;
                    }

                    @Override
                    public Void call() throws Exception {
                        m.addEventHandler(WindowEvent.WINDOW_HIDDEN, this.val$shownHandler);
                        return null;
                    }
                });
                successful = false;
                this.getRobot().keyType(null, 27);
                try {
                    try {
                        if (!m.isShowing()) break block7;
                        EventLock eventLock2 = eventLock;
                        synchronized (eventLock2) {
                            eventLock.wait(10000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        successful = EventThreadQueuerJavaFXImpl.invokeAndWait("closeMenu", new Callable<Boolean>(m, (EventHandler)shownHandler){
                            private final /* synthetic */ ContextMenu val$m;
                            private final /* synthetic */ EventHandler val$shownHandler;
                            {
                                this.val$m = contextMenu;
                                this.val$shownHandler = eventHandler;
                            }

                            @Override
                            public Boolean call() throws Exception {
                                this.val$m.removeEventHandler(WindowEvent.WINDOW_HIDDEN, this.val$shownHandler);
                                return !this.val$m.isShowing();
                            }
                        });
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    successful = EventThreadQueuerJavaFXImpl.invokeAndWait("closeMenu", new /* invalid duplicate definition of identical inner class */);
                    throw throwable;
                }
            }
            successful = EventThreadQueuerJavaFXImpl.invokeAndWait("closeMenu", new /* invalid duplicate definition of identical inner class */);
        }
        return successful;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForMenuToClose(final Menu m) {
        boolean successful;
        block8: {
            EventHandler<Event> shownHandler;
            block7: {
                final EventLock eventLock = new EventLock();
                shownHandler = new EventHandler<Event>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void handle(Event event) {
                        EventLock eventLock2 = eventLock;
                        synchronized (eventLock2) {
                            eventLock.notifyAll();
                        }
                    }
                };
                EventThreadQueuerJavaFXImpl.invokeAndWait("addCloseHandler", new Callable<Void>((EventHandler)shownHandler){
                    private final /* synthetic */ EventHandler val$shownHandler;
                    {
                        this.val$shownHandler = eventHandler;
                    }

                    @Override
                    public Void call() throws Exception {
                        m.addEventHandler(Menu.ON_HIDDEN, this.val$shownHandler);
                        return null;
                    }
                });
                successful = false;
                this.getRobot().keyType(null, 27);
                try {
                    try {
                        if (!m.isShowing()) break block7;
                        EventLock eventLock2 = eventLock;
                        synchronized (eventLock2) {
                            eventLock.wait(10000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        successful = EventThreadQueuerJavaFXImpl.invokeAndWait("closeMenu", new Callable<Boolean>(m, (EventHandler)shownHandler){
                            private final /* synthetic */ Menu val$m;
                            private final /* synthetic */ EventHandler val$shownHandler;
                            {
                                this.val$m = menu;
                                this.val$shownHandler = eventHandler;
                            }

                            @Override
                            public Boolean call() throws Exception {
                                this.val$m.removeEventHandler(Menu.ON_HIDDEN, this.val$shownHandler);
                                return !this.val$m.isShowing();
                            }
                        });
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    successful = EventThreadQueuerJavaFXImpl.invokeAndWait("closeMenu", new /* invalid duplicate definition of identical inner class */);
                    throw throwable;
                }
            }
            successful = EventThreadQueuerJavaFXImpl.invokeAndWait("closeMenu", new /* invalid duplicate definition of identical inner class */);
        }
        return successful;
    }

    public IComponent getComponent() {
        IComponent adapt = super.getComponent();
        if (adapt != null && adapt.getRealComponent() instanceof ContextMenu) {
            return adapt;
        }
        List<MenuBar> bars = ComponentHandler.getAssignableFrom(MenuBar.class);
        if (bars.size() > 1) {
            throw new StepExecutionException("Multiple MenuBars found", EventFactory.createActionError((String)"TestErrorEvent.UnsupportedOperationInToolkit"));
        }
        this.setComponent(bars.get(0));
        return super.getComponent();
    }
}

