/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.javafx.tester;

import java.awt.Point;
import java.util.List;
import java.util.concurrent.Callable;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableView;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.tree.AbstractTreeOperationContext;
import org.eclipse.jubula.rc.common.implclasses.tree.ExpandCollapseTreeNodeOperation;
import org.eclipse.jubula.rc.common.implclasses.tree.INodePath;
import org.eclipse.jubula.rc.common.implclasses.tree.PathBasedTraverser;
import org.eclipse.jubula.rc.common.implclasses.tree.SelectTreeNodeOperation;
import org.eclipse.jubula.rc.common.implclasses.tree.TreeNodeOperation;
import org.eclipse.jubula.rc.common.implclasses.tree.TreeNodeOperationConstraint;
import org.eclipse.jubula.rc.common.util.IndexConverter;
import org.eclipse.jubula.rc.common.util.Verifier;
import org.eclipse.jubula.rc.javafx.driver.EventThreadQueuerJavaFXImpl;
import org.eclipse.jubula.rc.javafx.tester.TreeViewTester;
import org.eclipse.jubula.rc.javafx.tester.adapter.TreeTableOperationContext;
import org.eclipse.jubula.rc.javafx.util.NodeBounds;
import org.eclipse.jubula.rc.javafx.util.NodeTraverseHelper;
import org.eclipse.jubula.tools.internal.objects.event.EventFactory;

public class TreeTableViewTester
extends TreeViewTester {
    @Override
    protected Object getNodeAtMousePosition() throws StepExecutionException {
        Point awtPoint = this.getRobot().getCurrentMousePosition();
        final Point2D point = new Point2D((double)awtPoint.x, (double)awtPoint.y);
        Object result = EventThreadQueuerJavaFXImpl.invokeAndWait("getNodeAtMousePosition", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ((TreeTableView)TreeTableViewTester.this.getRealComponent()).layout();
                List<TreeTableCell> tCells = new NodeTraverseHelper<TreeTableCell>().getInstancesOf((Parent)TreeTableViewTester.this.getRealComponent(), TreeTableCell.class);
                for (TreeTableCell cell : tCells) {
                    if (!NodeBounds.checkIfContains(point, (Node)cell)) continue;
                    return cell;
                }
                throw new StepExecutionException("No tree node found at mouse position: X: " + point.getX() + "Y: " + point.getY(), EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
            }
        });
        return result;
    }

    public void rcSelectByIndices(String pathType, int preAscend, String indexPath, int clickCount, int column, int button) throws StepExecutionException {
        int implCol = IndexConverter.toImplementationIndex((int)column);
        this.checkColumnIndex(implCol);
        this.selectByPath(pathType, preAscend, this.createIndexNodePath(this.splitIndexTreePath(indexPath)), ClickOptions.create().setClickCount(clickCount).setMouseButton(button), implCol);
    }

    public void rcSelect(String pathType, int preAscend, String treePath, String operator, int clickCount, int column, int button) throws StepExecutionException {
        int implCol = IndexConverter.toImplementationIndex((int)column);
        this.checkColumnIndex(implCol);
        this.selectByPath(pathType, preAscend, this.createStringNodePath(this.splitTextTreePath(treePath), operator), ClickOptions.create().setClickCount(clickCount).setMouseButton(button), implCol);
    }

    private void selectByPath(String pathType, int preAscend, INodePath objectPath, ClickOptions co, int column) {
        ExpandCollapseTreeNodeOperation expOp = new ExpandCollapseTreeNodeOperation(false);
        SelectTreeNodeOperation selectOp = new SelectTreeNodeOperation(co);
        INodePath subPath = objectPath.subPath(0, objectPath.getLength() - 1);
        this.traverseTreeByPath(subPath, pathType, preAscend, (TreeNodeOperation)expOp);
        this.traverseLastElementByPath(objectPath, pathType, preAscend, (TreeNodeOperation)selectOp, column);
    }

    public void rcVerifySelectedValue(String pattern, String operator, int column) throws StepExecutionException {
        int implCol = IndexConverter.toImplementationIndex((int)column);
        this.checkColumnIndex(implCol);
        TreeTableOperationContext context = new TreeTableOperationContext(this.getEventThreadQueuer(), this.getRobot(), (TreeTableView)this.getRealComponent());
        context.setColumn(implCol);
        String text = context.getRenderedTextOfColumn(context.getSelectedNode());
        Verifier.match((String)text, (String)pattern, (String)operator);
    }

    private void traverseLastElementByPath(INodePath treePath, String pathType, int preAscend, TreeNodeOperation operation, int column) throws StepExecutionException {
        Validate.notNull((Object)treePath);
        Validate.notNull((Object)operation);
        TreeTableOperationContext context = new TreeTableOperationContext(this.getEventThreadQueuer(), this.getRobot(), (TreeTableView)this.getRealComponent());
        context.setColumn(column);
        TreeItem startNode = (TreeItem)this.getStartNode(pathType, preAscend, context);
        PathBasedTraverser traverser = new PathBasedTraverser((AbstractTreeOperationContext)context, treePath, new TreeNodeOperationConstraint());
        traverser.traversePath(operation, (Object)startNode);
    }

    private void checkColumnIndex(int index) throws StepExecutionException {
        int numColumns = (Integer)this.getEventThreadQueuer().invokeAndWait("checkColumnIndex", new IRunnable(){

            public Object run() {
                return new Integer(((TreeTableView)TreeTableViewTester.this.getRealComponent()).getColumns().size());
            }
        });
        if ((index < 0 || index >= numColumns) && index != 0) {
            throw new StepExecutionException("Invalid column: " + IndexConverter.toUserIndex((int)index), EventFactory.createActionError((String)"TestErrorEvent.InvalidIndex"));
        }
    }
}

