/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.javafx.tester.adapter;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IEventThreadQueuer;
import org.eclipse.jubula.rc.common.driver.IRobot;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.tree.AbstractTreeOperationContext;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.common.util.SelectionUtil;
import org.eclipse.jubula.rc.javafx.driver.EventThreadQueuerJavaFXImpl;
import org.eclipse.jubula.rc.javafx.listener.ComponentHandler;
import org.eclipse.jubula.rc.javafx.util.NodeBounds;
import org.eclipse.jubula.rc.javafx.util.Rounding;

public class TreeOperationContext
extends AbstractTreeOperationContext {
    private static AutServerLogger log = new AutServerLogger(TreeOperationContext.class);

    public TreeOperationContext(IEventThreadQueuer queuer, IRobot robot, TreeView<?> tree) {
        super(queuer, robot, tree);
        Validate.notNull((Object)tree.getRoot());
    }

    protected String convertValueToText(final Object node, int row) throws StepExecutionException {
        String result = EventThreadQueuerJavaFXImpl.invokeAndWait("convertValueToText", new Callable<String>(){

            @Override
            public String call() throws Exception {
                Object val;
                TreeItem item = (TreeItem)node;
                if (item != null && (val = item.getValue()) != null) {
                    return val.toString();
                }
                return null;
            }
        });
        return result;
    }

    public Collection<String> getNodeTextList(Object node) {
        String rendText;
        ArrayList<String> res = new ArrayList<String>();
        int rowNotUsed = 0;
        String valText = this.convertValueToText(node, rowNotUsed);
        if (valText != null) {
            res.add(valText);
        }
        if ((rendText = this.getRenderedText(node)) != null) {
            res.add(rendText);
        }
        return res;
    }

    public String getRenderedText(final Object node) throws StepExecutionException {
        String result = EventThreadQueuerJavaFXImpl.invokeAndWait("getRenderedText", new Callable<String>(){

            @Override
            public String call() throws Exception {
                TreeOperationContext.this.scrollNodeToVisible(node);
                List<TreeCell> tCells = ComponentHandler.getAssignableFrom(TreeCell.class);
                for (TreeCell cell : tCells) {
                    TreeItem item = cell.getTreeItem();
                    if (item == null || !item.equals(node)) continue;
                    return cell.getText();
                }
                return null;
            }
        });
        return result;
    }

    public boolean isVisible(final Object node) {
        boolean result = EventThreadQueuerJavaFXImpl.invokeAndWait("isVisible", new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                TreeItem item = (TreeItem)node;
                TreeItem parent = item.getParent();
                if (parent != null) {
                    if (parent.isExpanded() && ((TreeView)TreeOperationContext.this.getTree()).isVisible()) {
                        return true;
                    }
                    return false;
                }
                return ((TreeView)TreeOperationContext.this.getTree()).isVisible();
            }
        });
        return result;
    }

    public Rectangle getVisibleRowBounds(final Rectangle rowBounds) {
        Rectangle result = EventThreadQueuerJavaFXImpl.invokeAndWait("getVisibleRowBounds", new Callable<Rectangle>(){

            @Override
            public Rectangle call() throws Exception {
                TreeView tree = (TreeView)TreeOperationContext.this.getTree();
                tree.layout();
                Rectangle visibleTreeBounds = new Rectangle(0, 0, Rounding.round(tree.getWidth()), Rounding.round(tree.getHeight()));
                return rowBounds.intersection(visibleTreeBounds);
            }
        });
        return result;
    }

    public boolean isExpanded(final Object node) {
        boolean result = EventThreadQueuerJavaFXImpl.invokeAndWait("isExpanded", new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                TreeItem item = (TreeItem)node;
                return item.isExpanded();
            }
        });
        return result;
    }

    public void scrollNodeToVisible(final Object node) {
        EventThreadQueuerJavaFXImpl.invokeAndWait("scrollNodeToVisible", new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                int index = ((TreeView)TreeOperationContext.this.getTree()).getRow((TreeItem)node);
                ((TreeView)TreeOperationContext.this.getTree()).scrollTo(index);
                ((TreeView)TreeOperationContext.this.getTree()).layout();
                return null;
            }
        });
    }

    public void clickNode(Object node, ClickOptions clickOps) {
        this.scrollNodeToVisible(node);
        Rectangle rowBounds = this.getNodeBounds(node);
        Rectangle visibleRowBounds = this.getVisibleRowBounds(rowBounds);
        this.getRobot().click(this.getTree(), (Object)visibleRowBounds, clickOps);
    }

    public void expandNode(final Object node) {
        this.scrollNodeToVisible(node);
        Object result = EventThreadQueuerJavaFXImpl.invokeAndWait("expandNode", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                List<TreeCell> tCells = ComponentHandler.getAssignableFrom(TreeCell.class);
                for (TreeCell cell : tCells) {
                    TreeItem item = cell.getTreeItem();
                    if (item == null || !item.equals(node) || item.isExpanded()) continue;
                    TreeView tree = (TreeView)TreeOperationContext.this.getTree();
                    tree.layout();
                    return cell.getDisclosureNode();
                }
                return null;
            }
        });
        if (result != null) {
            this.getRobot().click(result, null, ClickOptions.create().setClickCount(1).setMouseButton(1));
        }
        EventThreadQueuerJavaFXImpl.invokeAndWait("expandNodeCheckIfExpanded", new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TreeItem item = (TreeItem)node;
                if (!((TreeView)TreeOperationContext.this.getTree()).isDisabled() && !item.isExpanded()) {
                    log.warn((Object)("Expand node fallback used for: " + item.getValue()));
                    item.setExpanded(true);
                }
                return null;
            }
        });
    }

    public void collapseNode(final Object node) {
        this.scrollNodeToVisible(node);
        Object result = EventThreadQueuerJavaFXImpl.invokeAndWait("collapseNode", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                List<TreeCell> tCells = ComponentHandler.getAssignableFrom(TreeCell.class);
                for (TreeCell cell : tCells) {
                    TreeItem item = cell.getTreeItem();
                    if (item == null || !item.equals(node) || !item.isExpanded()) continue;
                    TreeView tree = (TreeView)TreeOperationContext.this.getTree();
                    tree.layout();
                    return cell.getDisclosureNode();
                }
                return null;
            }
        });
        if (result != null) {
            this.getRobot().click(result, null, ClickOptions.create().setClickCount(1).setMouseButton(1));
        }
        EventThreadQueuerJavaFXImpl.invokeAndWait("collapseNodeCheckIfCollapsed", new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TreeItem item = (TreeItem)node;
                if (!((TreeView)TreeOperationContext.this.getTree()).isDisabled() && item.isExpanded()) {
                    log.warn((Object)("Collapse node fallback used for: " + item.getValue()));
                    item.setExpanded(false);
                }
                return null;
            }
        });
    }

    public Object getSelectedNode() {
        Object result = EventThreadQueuerJavaFXImpl.invokeAndWait("getSelectedNode", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return ((TreeView)TreeOperationContext.this.getTree()).getSelectionModel().getSelectedItem();
            }
        });
        if (result != null) {
            SelectionUtil.validateSelection((Object[])new Object[]{result});
        } else {
            SelectionUtil.validateSelection((Object[])new Object[0]);
        }
        return result;
    }

    public Object[] getSelectedNodes() {
        Object[] result = EventThreadQueuerJavaFXImpl.invokeAndWait("getSelectedNode", new Callable<Object[]>(){

            @Override
            public Object[] call() throws Exception {
                return ((TreeView)TreeOperationContext.this.getTree()).getSelectionModel().getSelectedItems().toArray();
            }
        });
        SelectionUtil.validateSelection((Object[])result);
        return result;
    }

    public Object[] getRootNodes() {
        Object[] result = EventThreadQueuerJavaFXImpl.invokeAndWait("getRootNodes", new Callable<Object[]>(){

            @Override
            public Object[] call() throws Exception {
                TreeView tree = (TreeView)TreeOperationContext.this.getTree();
                if (tree.showRootProperty().getValue().booleanValue()) {
                    return new Object[]{tree.getRoot()};
                }
                return TreeOperationContext.this.getChildren(tree.getRoot());
            }
        });
        return result;
    }

    public Object getParent(final Object child) {
        Object result = EventThreadQueuerJavaFXImpl.invokeAndWait("getParent", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return ((TreeItem)child).getParent();
            }
        });
        return result;
    }

    public Object getChild(final Object parent, final int index) {
        Object result = EventThreadQueuerJavaFXImpl.invokeAndWait("getChild", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return ((TreeItem)parent).getChildren().get(index);
            }
        });
        return result;
    }

    public int getNumberOfChildren(final Object parent) {
        Integer result = EventThreadQueuerJavaFXImpl.invokeAndWait("getNumberOfChildren", new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return ((TreeItem)parent).getChildren().size();
            }
        });
        return result;
    }

    public boolean isLeaf(final Object node) {
        boolean result = EventThreadQueuerJavaFXImpl.invokeAndWait("isLeaf", new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                TreeItem item = (TreeItem)node;
                return item.isLeaf();
            }
        });
        return result;
    }

    public Object[] getChildren(final Object parent) {
        Object[] result = EventThreadQueuerJavaFXImpl.invokeAndWait("getSelectedNode", new Callable<Object[]>(){

            @Override
            public Object[] call() throws Exception {
                return ((TreeItem)parent).getChildren().toArray();
            }
        });
        return result;
    }

    public Rectangle getNodeBounds(final Object node) {
        Rectangle result = EventThreadQueuerJavaFXImpl.invokeAndWait("getNodeBounds", new Callable<Rectangle>(){

            @Override
            public Rectangle call() throws Exception {
                List<TreeCell> tCells = ComponentHandler.getAssignableFrom(TreeCell.class);
                for (TreeCell cell : tCells) {
                    TreeItem item = cell.getTreeItem();
                    TreeView tree = (TreeView)TreeOperationContext.this.getTree();
                    if (item == null || !item.equals(node)) continue;
                    tree.layout();
                    Rectangle b = NodeBounds.getAbsoluteBounds((Node)cell);
                    Rectangle treeB = NodeBounds.getAbsoluteBounds((Node)tree);
                    return new Rectangle(Math.abs(treeB.x - b.x), Math.abs(treeB.y - b.y), Rounding.round(b.getWidth()), Rounding.round(b.getHeight()));
                }
                return null;
            }
        });
        return result;
    }

    public int getIndexOfChild(final Object parent, final Object child) {
        Integer result = EventThreadQueuerJavaFXImpl.invokeAndWait("getIndexOfChild", new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                if (parent == null) {
                    Object[] rootNodes = TreeOperationContext.this.getRootNodes();
                    int i = 0;
                    while (i < rootNodes.length) {
                        if (ObjectUtils.equals((Object)rootNodes[i], (Object)child)) {
                            return i;
                        }
                        ++i;
                    }
                    return -1;
                }
                ObservableList children = ((TreeItem)parent).getChildren();
                if (children.contains(child)) {
                    return children.indexOf(child);
                }
                return -1;
            }
        });
        return result;
    }
}

