/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.javafx.util;

import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventType;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import org.eclipse.jubula.rc.common.driver.DragAndDropHelper;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;

public class JavaFXEventConverter {
    private static AutServerLogger log = new AutServerLogger(JavaFXEventConverter.class);

    private JavaFXEventConverter() {
    }

    public static EventType<? extends Event> awtToFX(long eventMask) {
        EventType fxEvent = null;
        if (128L == eventMask) {
            fxEvent = ActionEvent.ACTION;
        } else if (16L == eventMask) {
            fxEvent = MouseEvent.ANY;
        } else if (32L == eventMask) {
            fxEvent = DragAndDropHelper.getInstance().isDragMode() ? MouseEvent.MOUSE_DRAGGED : MouseEvent.MOUSE_MOVED;
        } else if (131072L == eventMask) {
            fxEvent = ScrollEvent.SCROLL;
        } else if (8L == eventMask) {
            fxEvent = KeyEvent.ANY;
        }
        if (fxEvent == null && log.isInfoEnabled()) {
            log.info((Object)("Could not find a JavaFX event for: " + eventMask));
        }
        return fxEvent;
    }
}

