/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.rcp.e3.gef.inspector;

import java.util.Map;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jubula.rc.rcp.e3.gef.factory.DefaultEditPartAdapterFactory;
import org.eclipse.jubula.rc.rcp.e3.gef.identifier.IEditPartIdentifier;
import org.eclipse.jubula.rc.rcp.e3.gef.util.FigureCanvasUtil;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;

public class FigureHighlighter
implements MouseMoveListener {
    private GraphicalViewer m_viewer;
    private Color m_highlightColor;
    private int m_highlightAlpha;
    private Rectangle m_currentBounds;
    private PaintListener m_paintListener;

    public FigureHighlighter(GraphicalViewer viewer) {
        this.m_viewer = viewer;
        this.m_highlightColor = viewer.getControl().getDisplay().getSystemColor(9);
        this.m_highlightAlpha = 100;
        this.m_currentBounds = null;
        this.m_paintListener = new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (FigureHighlighter.this.m_currentBounds != null) {
                    Color bgColor = e.gc.getBackground();
                    int alpha = e.gc.getAlpha();
                    e.gc.setAlpha(FigureHighlighter.this.m_highlightAlpha);
                    e.gc.setBackground(FigureHighlighter.this.m_highlightColor);
                    e.gc.fillRectangle(FigureHighlighter.this.m_currentBounds);
                    e.gc.setAlpha(alpha);
                    e.gc.setBackground(bgColor);
                }
            }
        };
        viewer.getControl().addPaintListener(this.m_paintListener);
    }

    public void mouseMove(MouseEvent e) {
        Rectangle bounds;
        Point cursorLocation = new Point(e.x, e.y);
        EditPart editPart = FigureCanvasUtil.findAtCurrentMousePosition(e.display, (EditPartViewer)this.m_viewer);
        if (editPart == this.m_viewer.getContents().getRoot() || editPart == null) {
            if (this.m_currentBounds != null) {
                this.m_currentBounds = null;
                this.m_viewer.getControl().redraw();
            }
            return;
        }
        Rectangle anchorBounds = this.getConnectionAnchorBounds(DefaultEditPartAdapterFactory.loadFigureIdentifier(editPart), cursorLocation);
        if (anchorBounds == null && editPart instanceof ConnectionEditPart) {
            ConnectionEditPart connEditPart = (ConnectionEditPart)editPart;
            EditPart srcEditPart = connEditPart.getSource();
            EditPart targetEditPart = connEditPart.getTarget();
            anchorBounds = this.getConnectionAnchorBounds(DefaultEditPartAdapterFactory.loadFigureIdentifier(srcEditPart), cursorLocation);
            if (anchorBounds == null) {
                anchorBounds = this.getConnectionAnchorBounds(DefaultEditPartAdapterFactory.loadFigureIdentifier(targetEditPart), cursorLocation);
            }
        }
        if ((bounds = anchorBounds) == null && editPart != this.m_viewer.getContents().getRoot() && !(editPart instanceof ConnectionEditPart) && editPart instanceof GraphicalEditPart) {
            IFigure figure = ((GraphicalEditPart)editPart).getFigure();
            org.eclipse.draw2d.geometry.Rectangle figureBounds = new org.eclipse.draw2d.geometry.Rectangle(figure.getBounds());
            figure.translateToAbsolute((Translatable)figureBounds);
            bounds = new Rectangle(figureBounds.x, figureBounds.y, figureBounds.width, figureBounds.height);
        }
        this.m_currentBounds = bounds;
        this.m_viewer.getControl().redraw();
    }

    private Rectangle getConnectionAnchorBounds(IEditPartIdentifier editPartIdentifier, Point cursorLocation) {
        Map<String, ConnectionAnchor> anchorMap;
        if (editPartIdentifier != null && (anchorMap = editPartIdentifier.getConnectionAnchors()) != null) {
            for (String key : anchorMap.keySet()) {
                ConnectionAnchor value = anchorMap.get(key);
                Point refPoint = value.getReferencePoint();
                Rectangle refBounds = new Rectangle(refPoint.x - 3, refPoint.y - 3, 7, 7);
                if (!refBounds.contains(cursorLocation.getSWTPoint())) continue;
                return refBounds;
            }
        }
        return null;
    }

    public void removeAddedListeners() {
        Control control = this.m_viewer.getControl();
        if (!control.isDisposed()) {
            control.removePaintListener(this.m_paintListener);
            control.redraw();
        }
    }
}

