/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.rcp.e3.gef.inspector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.jubula.communication.internal.message.InspectorComponentSelectedMessage;
import org.eclipse.jubula.communication.internal.message.Message;
import org.eclipse.jubula.rc.common.AUTServer;
import org.eclipse.jubula.rc.common.listener.IAutListenerAppender;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.rcp.e3.gef.factory.DefaultEditPartAdapterFactory;
import org.eclipse.jubula.rc.rcp.e3.gef.identifier.IEditPartIdentifier;
import org.eclipse.jubula.rc.rcp.e3.gef.inspector.FigureHighlighter;
import org.eclipse.jubula.rc.rcp.e3.gef.util.FigureCanvasUtil;
import org.eclipse.jubula.tools.internal.exception.CommunicationException;
import org.eclipse.jubula.tools.internal.objects.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class GefInspectorListenerAppender
implements IAutListenerAppender {
    private static final AutServerLogger LOG = new AutServerLogger(GefInspectorListenerAppender.class);
    private FigureHighlightAppender m_highlightAppender = new FigureHighlightAppender();
    private GefInspectorComponentSelectedListener m_componentSelectedListener = new GefInspectorComponentSelectedListener(this.m_highlightAppender);

    public void addAutListener() {
        final Display display = PlatformUI.getWorkbench().getDisplay();
        display.syncExec(new Runnable(){

            public void run() {
                display.addFilter(6, (Listener)GefInspectorListenerAppender.this.m_highlightAppender);
                display.addFilter(3, (Listener)GefInspectorListenerAppender.this.m_componentSelectedListener);
            }
        });
    }

    private static class FigureHighlightAppender
    implements Listener {
        private Map<FigureCanvas, FigureHighlighter> m_canvasToListener = new HashMap<FigureCanvas, FigureHighlighter>();

        private FigureHighlightAppender() {
        }

        public void handleEvent(Event event) {
            if (event.widget instanceof FigureCanvas) {
                FigureCanvas canvas = (FigureCanvas)event.widget;
                if (event.type == 6) {
                    this.handleMouseEnter(canvas);
                }
            }
        }

        public void removeAddedListeners() {
            for (Control control : this.m_canvasToListener.keySet()) {
                if (control.isDisposed()) continue;
                FigureHighlighter highlighter = this.m_canvasToListener.get(control);
                highlighter.removeAddedListeners();
                control.removeMouseMoveListener((MouseMoveListener)highlighter);
            }
            this.m_canvasToListener.clear();
        }

        private void handleMouseEnter(FigureCanvas canvas) {
            if (this.m_canvasToListener.containsKey(canvas)) {
                return;
            }
            GraphicalViewer viewer = FigureCanvasUtil.getViewer(canvas);
            if (viewer != null && viewer.getContents() instanceof GraphicalEditPart) {
                FigureHighlighter highlighter = new FigureHighlighter(viewer);
                this.m_canvasToListener.put(canvas, highlighter);
                canvas.addMouseMoveListener((MouseMoveListener)highlighter);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GefInspectorComponentSelectedListener
    implements Listener {
        private FigureHighlightAppender m_highlightAppender;

        public GefInspectorComponentSelectedListener(FigureHighlightAppender highlightAppender) {
            this.m_highlightAppender = highlightAppender;
        }

        private String getConnectionAnchorId(IEditPartIdentifier editPartIdentifier, Point cursorLocation) {
            Map<String, ConnectionAnchor> anchorMap;
            if (editPartIdentifier != null && (anchorMap = editPartIdentifier.getConnectionAnchors()) != null) {
                for (String key : anchorMap.keySet()) {
                    ConnectionAnchor value = anchorMap.get(key);
                    if (!(key instanceof String) || !(value instanceof ConnectionAnchor)) continue;
                    Point refPoint = value.getReferencePoint();
                    Rectangle refBounds = new Rectangle(refPoint.x - 3, refPoint.y - 3, 7, 7);
                    if (!refBounds.contains(cursorLocation)) continue;
                    return key;
                }
            }
            return null;
        }

        public void handleEvent(Event event) {
            FigureCanvas figureCanvas;
            Display display = event.display;
            display.removeFilter(3, (Listener)this);
            display.removeFilter(6, (Listener)this.m_highlightAppender);
            this.m_highlightAppender.removeAddedListeners();
            event.doit = false;
            event.type = 0;
            Widget selectedWidget = event.widget;
            IComponentIdentifier compId = null;
            if (!(selectedWidget instanceof FigureCanvas)) {
                this.sendIdInfo(compId);
                return;
            }
            FigureCanvas parent = figureCanvas = (FigureCanvas)selectedWidget;
            while (parent != null && !(parent.getData("TEST_GEF_VIEWER") instanceof GraphicalViewer)) {
                parent = parent.getParent();
            }
            if (parent == null) {
                this.sendIdInfo(compId);
                return;
            }
            Object gefData = parent.getData("TEST_GEF_VIEWER");
            if (gefData instanceof EditPartViewer) {
                EditPartViewer viewer = (EditPartViewer)gefData;
                Point cursorLocation = new Point(display.map(null, viewer.getControl(), display.getCursorLocation()));
                EditPart editPart = viewer.findObjectAt(cursorLocation);
                EditPart primaryEditPart = FigureCanvasUtil.getPrimaryEditPart(editPart, viewer.getRootEditPart());
                List<String> idStringList = Collections.EMPTY_LIST;
                if (primaryEditPart != null) {
                    idStringList = this.getPathToRoot(viewer.getRootEditPart(), cursorLocation, primaryEditPart);
                } else {
                    EditPart paletteEditPart;
                    PaletteViewer paletteViewer;
                    EditDomain editDomain = viewer.getEditDomain();
                    if (editDomain != null && (paletteViewer = editDomain.getPaletteViewer()) != null && (paletteEditPart = paletteViewer.findObjectAt(new Point(display.map(viewer.getControl(), paletteViewer.getControl(), cursorLocation.getSWTPoint())))) != null) {
                        idStringList = this.getToolPathToRoot(paletteViewer.getRootEditPart(), paletteEditPart);
                    }
                }
                compId = this.createCompId(idStringList);
            }
            this.sendIdInfo(compId);
        }

        private List<String> getPathToRoot(RootEditPart root, Point cursorLocation, EditPart editPart) {
            ArrayList<String> idStringList = new ArrayList<String>();
            EditPart currentEditPart = editPart;
            String connectionId = this.getConnectionAnchorId(DefaultEditPartAdapterFactory.loadFigureIdentifier(currentEditPart), cursorLocation);
            if (connectionId == null && currentEditPart instanceof ConnectionEditPart) {
                ConnectionEditPart connEditPart = (ConnectionEditPart)editPart;
                EditPart srcEditPart = connEditPart.getSource();
                EditPart targetEditPart = connEditPart.getTarget();
                connectionId = this.getConnectionAnchorId(DefaultEditPartAdapterFactory.loadFigureIdentifier(srcEditPart), cursorLocation);
                if (connectionId != null) {
                    currentEditPart = srcEditPart;
                } else {
                    connectionId = this.getConnectionAnchorId(DefaultEditPartAdapterFactory.loadFigureIdentifier(targetEditPart), cursorLocation);
                    if (connectionId != null) {
                        currentEditPart = targetEditPart;
                    }
                }
            }
            if (connectionId != null) {
                idStringList.add(connectionId);
            }
            while (currentEditPart != root.getContents() && currentEditPart != null) {
                IEditPartIdentifier identifier = DefaultEditPartAdapterFactory.loadFigureIdentifier(currentEditPart);
                if (identifier != null) {
                    idStringList.add(identifier.getIdentifier());
                }
                currentEditPart = currentEditPart.getParent();
            }
            return idStringList;
        }

        private List<String> getToolPathToRoot(RootEditPart root, EditPart editPart) {
            ArrayList<String> idStringList = new ArrayList<String>();
            EditPart currentEditPart = editPart;
            if (currentEditPart != null) {
                Object model = currentEditPart.getModel();
                while (model instanceof PaletteEntry && currentEditPart != root.getContents()) {
                    idStringList.add(((PaletteEntry)model).getLabel());
                    currentEditPart = currentEditPart.getParent();
                    model = currentEditPart.getModel();
                }
            }
            return idStringList;
        }

        private void sendIdInfo(IComponentIdentifier compId) {
            InspectorComponentSelectedMessage message = new InspectorComponentSelectedMessage();
            message.setComponentIdentifier(compId);
            try {
                AUTServer.getInstance().getCommunicator().send((Message)message);
            }
            catch (CommunicationException e) {
                LOG.error((Object)"Error occurred while trying to send message to Client.", (Throwable)e);
            }
        }

        private IComponentIdentifier createCompId(List<String> idStringList) {
            ComponentIdentifier compId = null;
            if (!idStringList.isEmpty()) {
                Collections.reverse(idStringList);
                compId = new ComponentIdentifier();
                compId.setHierarchyNames(idStringList);
            }
            return compId;
        }
    }
}

