/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.toolkit.api.gen.internal.genmodel;

import org.eclipse.jubula.toolkit.api.gen.internal.utils.NameLoader;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Component;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ToolkitDescriptor;

public class CommonGenInfo {
    private String m_className;
    private String m_classPackageName;
    private String m_classDirectoryPath;
    private String m_toolkitName;
    private String m_toolkitID;
    private Object m_specificInformation;

    public CommonGenInfo(Component component) {
        NameLoader nameLoader = NameLoader.getInstance();
        ToolkitDescriptor toolkitDesriptor = component.getToolkitDesriptor();
        this.m_toolkitName = nameLoader.getToolkitName(toolkitDesriptor);
        this.m_className = nameLoader.getClassName(component.getType());
        this.m_classPackageName = nameLoader.getClassPackageName(this.m_toolkitName);
        this.m_toolkitID = toolkitDesriptor.getToolkitID();
        this.m_classDirectoryPath = this.m_classPackageName.replace(".", "/");
        this.m_classPackageName = nameLoader.executeExceptions(this.m_classPackageName);
        this.m_classDirectoryPath = nameLoader.executeExceptions(this.m_classDirectoryPath);
        this.m_toolkitName = nameLoader.executeExceptions(this.m_toolkitName);
    }

    public CommonGenInfo(ToolkitDescriptor tkDescriptor, boolean genToolkitInfo) {
        NameLoader nameLoader = NameLoader.getInstance();
        this.m_toolkitName = nameLoader.getToolkitName(tkDescriptor);
        this.m_className = genToolkitInfo ? nameLoader.getToolkitComponentClassName(this.m_toolkitName) : nameLoader.getFactoryName(this.m_toolkitName);
        this.m_classPackageName = nameLoader.getToolkitPackageName(this.m_toolkitName, genToolkitInfo);
        this.m_toolkitID = tkDescriptor.getToolkitID();
        this.m_classDirectoryPath = this.m_classPackageName.replace(".", "/");
        this.m_classPackageName = nameLoader.executeExceptions(this.m_classPackageName);
        this.m_classDirectoryPath = nameLoader.executeExceptions(this.m_classDirectoryPath);
        this.m_toolkitName = nameLoader.executeExceptions(this.m_toolkitName);
    }

    public String getClassName() {
        return this.m_className;
    }

    public String getClassPackageName() {
        return this.m_classPackageName;
    }

    public String getClassDirectoryPath() {
        return this.m_classDirectoryPath;
    }

    public String getToolkitName() {
        return this.m_toolkitName;
    }

    public String getToolkitID() {
        return this.m_toolkitID;
    }

    public String getFqClassName() {
        return String.valueOf(this.getClassPackageName()) + "." + this.getClassName();
    }

    public Object getSpecificInformation() {
        return this.m_specificInformation;
    }

    public void setSpecificInformation(Object specificInformation) {
        this.m_specificInformation = specificInformation;
    }
}

