/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.toolkit.api.gen.internal.utils;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.tools.internal.utils.generator.ToolkitConfig;

public class ConfigLoader {
    private static final String TOOLKIT_NAMES = "api.gen.toolkit.names";
    private static final String RESOURCES_APIGEN_PROPERTIES = "resources/apigen.properties";
    private static final String XML_PATH = "api.gen.toolkit.xml.conf";
    private static final String RESOURCE_BUNDLE_PATH = "api.gen.toolkit.resourcebundle.path";
    private static final String RESOURCE_BUNDLE_FQN = "api.gen.toolkit.resourcebundle.fqn";
    private static final String BASEDIR = "api.gen.toolkit.name.scheme";
    private static final String OUTPUTDIR = "api.gen.toolkit.output";
    private static final String GENERATIONDIR = "api.gen.toolkit.generation.dir";
    private static final String CONVERTER_INFO_DIR = "api.gen.converter.info.dir";
    private static ConfigLoader instance = null;
    private ToolkitConfig m_toolkitConfig;
    private String m_generationDir;
    private String m_converterInfoDir;

    private ConfigLoader() {
        try {
            URL resourceURL = ConfigLoader.class.getClassLoader().getResource(RESOURCES_APIGEN_PROPERTIES);
            Properties p = new Properties();
            p.load(resourceURL.openStream());
            String toolkitIDs = p.getProperty(TOOLKIT_NAMES);
            ArrayList<String> toolkitIDList = new ArrayList<String>(Arrays.asList(StringUtils.stripAll((String[])StringUtils.split((String)toolkitIDs, (char)','))));
            this.m_toolkitConfig = new ToolkitConfig(p.getProperty(BASEDIR), p.getProperty(XML_PATH), p.getProperty(RESOURCE_BUNDLE_PATH), p.getProperty(RESOURCE_BUNDLE_FQN), p.getProperty(OUTPUTDIR), toolkitIDList);
            this.m_generationDir = p.getProperty(GENERATIONDIR);
            this.m_converterInfoDir = p.getProperty(CONVERTER_INFO_DIR);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static ConfigLoader getInstance() {
        if (instance == null) {
            instance = new ConfigLoader();
        }
        return instance;
    }

    public ToolkitConfig getToolkitConfig() {
        return this.m_toolkitConfig;
    }

    public String getGenerationDir() {
        return this.m_generationDir;
    }

    public String getConverterInfoDir() {
        return this.m_converterInfoDir;
    }
}

