/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete;

import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.toolkit.ToolkitInfo;


/**
 * Factory for creating components from the concrete toolkit.
 * @noextend This class is not intended to be extended by clients.
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.FactoryGenerator", 
           date =  "2015-01-19T14:47:55.913Z")
public final class ConcreteComponents {
    

    private ConcreteComponents() {
        super();
    }
    

    /** create a new representative for a ButtonComponent UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ButtonComponent createButtonComponent (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.concrete.internal.impl.ButtonComponent(componentIdentifier);
    }
    /** create a new representative for a ComboComponent UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ComboComponent createComboComponent (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.concrete.internal.impl.ComboComponent(componentIdentifier);
    }
    /** create a new representative for a ListComponent UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ListComponent createListComponent (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.concrete.internal.impl.ListComponent(componentIdentifier);
    }
    /** create a new representative for a TextComponent UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextComponent createTextComponent (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.concrete.internal.impl.TextComponent(componentIdentifier);
    }
    /** create a new representative for a TabComponent UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TabComponent createTabComponent (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.concrete.internal.impl.TabComponent(componentIdentifier);
    }
    /** create a new representative for a TableComponent UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TableComponent createTableComponent (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.concrete.internal.impl.TableComponent(componentIdentifier);
    }
    /** create a new representative for a TextInputComponent UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextInputComponent createTextInputComponent (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.concrete.internal.impl.TextInputComponent(componentIdentifier);
    }
    /** create a new representative for a TreeComponent UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TreeComponent createTreeComponent (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.concrete.internal.impl.TreeComponent(componentIdentifier);
    }
}