/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete.components;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;


/**
 * Interface representing the TableComponent component from the concrete toolkit. 
 * @noextend This interface is not intended to be extended by clients.
 * @noimplement This interface is not intended to be implemented by clients.
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ClassGenerator", 
           date =  "2015-01-19T14:47:55.891Z")
public interface TableComponent extends org.eclipse.jubula.toolkit.base.components.TextInputComponent {
    
    
        /**
         * 
         * @param text 
         *        the text to use
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP inputTextSpecifyCell(
            @NonNull String text,
            @NonNull String row,
            @NonNull Operator rowOperator,
            @NonNull String column,
            @NonNull Operator columnOperator
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param text 
         *        the text to use
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP replaceTextSpecifyCell(
            @NonNull String text,
            @NonNull String row,
            @NonNull Operator rowOperator,
            @NonNull String column,
            @NonNull Operator columnOperator
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param numberOfClicks 
         *        the amount of interactions
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param extendSelection 
         *        whether to extend the selection or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP selectCell(
            @NonNull String row,
            @NonNull Operator rowOperator,
            @NonNull String column,
            @NonNull Operator columnOperator,
            @NonNull Integer numberOfClicks,
            @NonNull Integer xPosition,
            @NonNull Unit xUnits,
            @NonNull Integer yPosition,
            @NonNull Unit yUnits,
            @NonNull BinaryChoice extendSelection,
            @NonNull InteractionMode mouseButton
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param direction 
         *        the direction
         * @param numberOfCells 
         *        the number of cells
         * @param numberOfClicks 
         *        the amount of interactions
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param extendSelection 
         *        whether to extend the selection or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP move(
            @NonNull Direction direction,
            @NonNull Integer numberOfCells,
            @NonNull Integer numberOfClicks,
            @NonNull Integer xPosition,
            @NonNull Unit xUnits,
            @NonNull Integer yPosition,
            @NonNull Unit yUnits,
            @NonNull BinaryChoice extendSelection
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param editable 
         *        whether the component is expected to be editable or not
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkEditabilitySpecifyCell(
            @NonNull Boolean editable,
            @NonNull String row,
            @NonNull Operator rowOperator,
            @NonNull String column,
            @NonNull Operator columnOperator
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param editable 
         *        whether the component is expected to be editable or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkEditabilityOfSelectedCell(
            @NonNull Boolean editable
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param editable 
         *        whether the component is expected to be editable or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkEditabilityOfCellMousePosition(
            @NonNull Boolean editable
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param text 
         *        the text to use
         * @param textOperator 
         *        the text operator
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkTextSpecifyCell(
            @NonNull String text,
            @NonNull Operator textOperator,
            @NonNull String row,
            @NonNull Operator rowOperator,
            @NonNull String column,
            @NonNull Operator columnOperator
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkTextMousePosition(
            @NonNull String text,
            @NonNull Operator operator
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param searchType 
         *        the search type
         * @param exists 
         *        whether existence is expected or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkExistenceOfValueInRow(
            @NonNull String row,
            @NonNull Operator rowOperator,
            @NonNull String value,
            @NonNull Operator valueOperator,
            @NonNull SearchType searchType,
            @NonNull Boolean exists
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param searchType 
         *        the search type
         * @param exists 
         *        whether existence is expected or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkExistenceOfValueInColumn(
            @NonNull String column,
            @NonNull Operator columnOperator,
            @NonNull String value,
            @NonNull Operator valueOperator,
            @NonNull SearchType searchType,
            @NonNull Boolean exists
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param numberOfClicks 
         *        the amount of interactions
         * @param extendSelection 
         *        whether to extend the selection or not
         * @param searchType 
         *        the search type
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP selectValueFromColumn(
            @NonNull String column,
            @NonNull Operator columnOperator,
            @NonNull String value,
            @NonNull Operator valueOperator,
            @NonNull Integer numberOfClicks,
            @NonNull BinaryChoice extendSelection,
            @NonNull SearchType searchType,
            @NonNull InteractionMode mouseButton
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param numberOfClicks 
         *        the amount of interactions
         * @param extendSelection 
         *        whether to extend the selection or not
         * @param searchType 
         *        the search type
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP selectValueFromRow(
            @NonNull String row,
            @NonNull Operator rowOperator,
            @NonNull String value,
            @NonNull Operator valueOperator,
            @NonNull Integer numberOfClicks,
            @NonNull BinaryChoice extendSelection,
            @NonNull SearchType searchType,
            @NonNull InteractionMode mouseButton
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param modifierKeys 
         *        the modifier keys
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP dragCell(
            @NonNull InteractionMode mouseButton,
            @NonNull Modifier[] modifierKeys,
            @NonNull String row,
            @NonNull Operator rowOperator,
            @NonNull String column,
            @NonNull Operator columnOperator,
            @NonNull Integer xPosition,
            @NonNull Unit xUnits,
            @NonNull Integer yPosition,
            @NonNull Unit yUnits
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param delayBeforeDropMilliseconds 
         *        the static delay before performing the drop (milliseconds)
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP dropOnCell(
            @NonNull String row,
            @NonNull Operator rowOperator,
            @NonNull String column,
            @NonNull Operator columnOperator,
            @NonNull Integer xPosition,
            @NonNull Unit xUnits,
            @NonNull Integer yPosition,
            @NonNull Unit yUnits,
            @NonNull Integer delayBeforeDropMilliseconds
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param modifierKeys 
         *        the modifier keys
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param searchType 
         *        the search type
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP dragCellFromColumn(
            @NonNull InteractionMode mouseButton,
            @NonNull Modifier[] modifierKeys,
            @NonNull String column,
            @NonNull Operator columnOperator,
            @NonNull String value,
            @NonNull Operator valueOperator,
            @NonNull SearchType searchType
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param searchType 
         *        the search type
         * @param delayBeforeDropMilliseconds 
         *        the static delay before performing the drop (milliseconds)
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP dropOnCellFromColumn(
            @NonNull String column,
            @NonNull Operator columnOperator,
            @NonNull String value,
            @NonNull Operator valueOperator,
            @NonNull SearchType searchType,
            @NonNull Integer delayBeforeDropMilliseconds
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param modifierKeys 
         *        the modifier keys
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param searchType 
         *        the search type
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP dragCellFromRow(
            @NonNull InteractionMode mouseButton,
            @NonNull Modifier[] modifierKeys,
            @NonNull String row,
            @NonNull Operator rowOperator,
            @NonNull String value,
            @NonNull Operator valueOperator,
            @NonNull SearchType searchType
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param searchType 
         *        the search type
         * @param delayBeforeDropMilliseconds 
         *        the static delay before performing the drop (milliseconds)
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP dropOnCellFromRow(
            @NonNull String row,
            @NonNull Operator rowOperator,
            @NonNull String value,
            @NonNull Operator valueOperator,
            @NonNull SearchType searchType,
            @NonNull Integer delayBeforeDropMilliseconds
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param checked 
         *        Checked
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkSelectionOfCheckboxInSelectedRow(
            @NonNull Boolean checked
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param checked 
         *        Checked
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkSelectionOfCheckboxAtMousePosition(
            @NonNull Boolean checked
        ) throws IllegalArgumentException;
        
        @NonNull public CAP toggleCheckboxInSelectedRow(
        ) ;
        
        @NonNull public CAP toggleCheckboxAtMousePosition(
        ) ;
        
} 