/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.html.components;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;


/**
 * Interface representing the Browser component from the html toolkit. 
 * @noextend This interface is not intended to be extended by clients.
 * @noimplement This interface is not intended to be implemented by clients.
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ClassGenerator", 
           date =  "2015-01-19T14:47:55.812Z")
public interface Browser {
    
    
        /**
         * 
         * @param uRL 
         *        the URL top open
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP openURL(
            @NonNull String uRL
        ) throws IllegalArgumentException;
        
        @NonNull public CAP goBack(
        ) ;
        
        @NonNull public CAP reloadPage(
        ) ;
        
        /**
         * 
         * @param identifier 
         *        the identifier to use
         * @param identifierType 
         *        the identifier type to use
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP selectWindowWithIdentifier(
            @NonNull String identifier,
            @NonNull String identifierType
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param windowTitle 
         *        the browser window title
         * @param operator 
         *        the operator used for comparison
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP selectWindowWithTitle(
            @NonNull String windowTitle,
            @NonNull Operator operator
        ) throws IllegalArgumentException;
        
} 