/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.swt;

import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.toolkit.ToolkitInfo;
import org.eclipse.jubula.toolkit.swt.internal.SwtToolkitInfo;

/**
 * Factory for creating components from the swt toolkit.
 * @noextend This class is not intended to be extended by clients.
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.FactoryGenerator", 
           date =  "2015-01-19T14:47:55.745Z")
public final class SwtComponents {
    
    @NonNull private final static ToolkitInfo m_toolkitInformation = new SwtToolkitInfo();

    private SwtComponents() {
        super();
    }
    
    @NonNull public static ToolkitInfo getToolkitInformation() {
        return m_toolkitInformation;
    }

    /** create a new representative for a {@link org.eclipse.swt.widgets.ToolItem} UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.swt.components.ToolItem createToolItem (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swt.internal.impl.ToolItem(componentIdentifier);
    }
    /** create a new representative for a {@link org.eclipse.swt.widgets.Label} UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextComponent createLabel (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swt.internal.impl.Label(componentIdentifier);
    }
    /** create a new representative for a {@link org.eclipse.swt.custom.CLabel} UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextComponent createCLabel (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swt.internal.impl.CLabel(componentIdentifier);
    }
    /** create a new representative for a {@link org.eclipse.swt.widgets.Text} UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextInputComponent createText (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swt.internal.impl.Text(componentIdentifier);
    }
    /** create a new representative for a {@link org.eclipse.swt.custom.StyledText} UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextInputComponent createStyledText (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swt.internal.impl.StyledText(componentIdentifier);
    }
    /** create a new representative for a {@link org.eclipse.swt.widgets.Button} UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ButtonComponent createButton (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swt.internal.impl.Button(componentIdentifier);
    }
    /** create a new representative for a {@link Application} component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.Application createApplication () {
        return new org.eclipse.jubula.toolkit.swt.internal.impl.Application();
    }
    /** create a new representative for a {@link Menu} component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.MenuBarComponent createMenu () {
        return new org.eclipse.jubula.toolkit.swt.internal.impl.Menu();
    }
    /** create a new representative for a {@link org.eclipse.swt.widgets.Combo} UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ComboComponent createCombo (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swt.internal.impl.Combo(componentIdentifier);
    }
    /** create a new representative for a {@link org.eclipse.swt.custom.CCombo} UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ComboComponent createCCombo (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swt.internal.impl.CCombo(componentIdentifier);
    }
    /** create a new representative for a {@link org.eclipse.swt.widgets.List} UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ListComponent createList (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swt.internal.impl.List(componentIdentifier);
    }
    /** create a new representative for a {@link org.eclipse.swt.widgets.TabFolder} UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TabComponent createTabFolder (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swt.internal.impl.TabFolder(componentIdentifier);
    }
    /** create a new representative for a {@link org.eclipse.swt.custom.CTabFolder} UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TabComponent createCTabFolder (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swt.internal.impl.CTabFolder(componentIdentifier);
    }
    /** create a new representative for a {@link org.eclipse.swt.widgets.Table} UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TableComponent createTable (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swt.internal.impl.Table(componentIdentifier);
    }
    /** create a new representative for a {@link org.eclipse.swt.widgets.Tree} UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.swt.components.Tree createTree (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swt.internal.impl.Tree(componentIdentifier);
    }
    /** create a new representative for a {@link org.eclipse.swt.widgets.Tree} UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.swt.components.TreeTable createTreeTable (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swt.internal.impl.TreeTable(componentIdentifier);
    }
    /** create a new representative for a {@link org.eclipse.swt.widgets.DateTime} UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.base.components.GraphicsComponent createDateTime (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swt.internal.impl.DateTime(componentIdentifier);
    }
    /** create a new representative for a {@link org.eclipse.swt.widgets.Scale} UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.base.components.GraphicsComponent createScale (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swt.internal.impl.Scale(componentIdentifier);
    }
    /** create a new representative for a {@link org.eclipse.swt.widgets.Slider} UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.base.components.GraphicsComponent createSlider (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swt.internal.impl.Slider(componentIdentifier);
    }
    /** create a new representative for a {@link org.eclipse.swt.widgets.Spinner} UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.base.components.GraphicsComponent createSpinner (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swt.internal.impl.Spinner(componentIdentifier);
    }
    /** create a new representative for a {@link org.eclipse.swt.widgets.Link} UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.base.components.GraphicsComponent createLink (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swt.internal.impl.Link(componentIdentifier);
    }
    /** create a new representative for a {@link org.eclipse.swt.widgets.ProgressBar} UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.base.components.GraphicsComponent createProgressBar (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swt.internal.impl.ProgressBar(componentIdentifier);
    }
    /** create a new representative for a {@link org.eclipse.swt.widgets.Canvas} UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.base.components.GraphicsComponent createCanvas (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swt.internal.impl.Canvas(componentIdentifier);
    }
    /** create a new representative for a ComboComponent UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ComboComponent createComboComponent (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swt.internal.impl.ComboComponent(componentIdentifier);
    }
    /** create a new representative for a Item UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ButtonComponent createItem (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swt.internal.impl.Item(componentIdentifier);
    }
    /** create a new representative for a TextComponent UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextComponent createTextComponent (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swt.internal.impl.TextComponent(componentIdentifier);
    }
    /** create a new representative for a TabComponent UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TabComponent createTabComponent (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swt.internal.impl.TabComponent(componentIdentifier);
    }
    /** create a new representative for a TextInputComponent UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextInputComponent createTextInputComponent (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swt.internal.impl.TextInputComponent(componentIdentifier);
    }
    /** create a new representative for a ButtonComponent UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ButtonComponent createButtonComponent (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.swt.internal.impl.ButtonComponent(componentIdentifier);
    }
}