/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.tools.internal.utils.generator;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.jubula.tools.internal.exception.ConfigXmlException;
import org.eclipse.jubula.tools.internal.utils.generator.AbstractComponentBuilder;
import org.eclipse.jubula.tools.internal.utils.generator.ActionInfo;
import org.eclipse.jubula.tools.internal.utils.generator.ComponentInfo;
import org.eclipse.jubula.tools.internal.utils.generator.IProcessor;
import org.eclipse.jubula.tools.internal.utils.generator.ToolkitConfig;
import org.eclipse.jubula.tools.internal.utils.generator.ToolkitInfo;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Action;
import org.eclipse.jubula.tools.internal.xml.businessmodell.CompSystem;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Component;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ConcreteComponent;
import org.eclipse.jubula.tools.internal.xml.businessmodell.InvalidAction;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ToolkitDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompSystemProcessor
implements IProcessor {
    private CompSystem m_compSystem;

    public CompSystemProcessor(ToolkitConfig config) throws ConfigXmlException {
        AbstractComponentBuilder builder = new AbstractComponentBuilder(config);
        this.m_compSystem = builder.getCompSystem();
    }

    public CompSystemProcessor(CompSystem compSystem) {
        this.m_compSystem = compSystem;
    }

    public List<ToolkitInfo> getToolkitInfos() {
        ArrayList<ToolkitInfo> infos = new ArrayList<ToolkitInfo>();
        List<ToolkitDescriptor> descriptors = this.m_compSystem.getAllToolkitDescriptors();
        for (ToolkitDescriptor descr : descriptors) {
            ToolkitInfo info = CompSystemProcessor.getToolkitInfo(descr);
            infos.add(info);
        }
        return infos;
    }

    public static ToolkitInfo getToolkitInfo(ToolkitDescriptor descr) {
        ToolkitInfo info = new ToolkitInfo(descr.getName(), descr.getToolkitID());
        return info;
    }

    public List<ComponentInfo> getCompInfos(boolean showOnlyVisible) {
        ArrayList<ComponentInfo> infos = new ArrayList<ComponentInfo>();
        for (Component component : this.m_compSystem.getComponents()) {
            if (showOnlyVisible && !component.isVisible()) continue;
            ToolkitInfo tkInfo = CompSystemProcessor.getToolkitInfo(component.getToolkitDesriptor());
            infos.add(new ComponentInfo(component, tkInfo));
        }
        return infos;
    }

    public List<ComponentInfo> getCompInfos(String toolkitId, String toolkitName, boolean showOnlyVisible) {
        ArrayList<ComponentInfo> infos = new ArrayList<ComponentInfo>();
        ToolkitInfo tkInfo = new ToolkitInfo(toolkitName, toolkitId);
        for (Component component : this.m_compSystem.getComponents(toolkitId, false)) {
            if (showOnlyVisible && !component.isVisible()) continue;
            infos.add(new ComponentInfo(component, tkInfo));
        }
        return infos;
    }

    private void getHierarchyCompInfosImpl(List<ComponentInfo> types, ComponentInfo componentInfo, int level) {
        Component component = componentInfo.getComponent();
        int newLevel = level;
        if (component.isVisible()) {
            types.add(componentInfo);
            ++newLevel;
        }
        for (Component realized : component.getRealized()) {
            ToolkitInfo tkRealized = CompSystemProcessor.getToolkitInfo(realized.getToolkitDesriptor());
            ComponentInfo realizedInfo = new ComponentInfo(realized, newLevel, tkRealized);
            this.getHierarchyCompInfosImpl(types, realizedInfo, newLevel);
        }
    }

    public List<ComponentInfo> getHierarchyCompInfos(ComponentInfo componentInfo) {
        ArrayList<ComponentInfo> types = new ArrayList<ComponentInfo>();
        this.getHierarchyCompInfosImpl(types, componentInfo, 0);
        return types;
    }

    public ComponentInfo getDefiningComp(ComponentInfo componentInfo, Action action) {
        ComponentInfo result = null;
        List<ComponentInfo> types = this.getHierarchyCompInfos(componentInfo);
        int i = 0;
        while (i < types.size()) {
            try {
                ComponentInfo info = types.get(i);
                if (!(info.getComponent().findAction(action.getName()) instanceof InvalidAction)) {
                    result = info;
                }
            }
            catch (ConfigXmlException configXmlException) {}
            ++i;
        }
        return result;
    }

    public List<ComponentInfo> getUsingComps(ComponentInfo compInfo) {
        Component comp = compInfo.getComponent();
        Set<ConcreteComponent> realizerSet = comp.getRealizers();
        realizerSet.remove(comp);
        ArrayList<ComponentInfo> realizerList = new ArrayList<ComponentInfo>();
        for (Component component : realizerSet) {
            if (!component.isVisible()) continue;
            ToolkitInfo tkNext = CompSystemProcessor.getToolkitInfo(component.getToolkitDesriptor());
            realizerList.add(new ComponentInfo(component, tkNext));
        }
        return realizerList;
    }

    public List<ActionInfo> getActions(ComponentInfo componentInfo, boolean newActions) {
        return this.getActions(componentInfo, newActions, false);
    }

    public List<ActionInfo> getActions(ComponentInfo componentInfo, boolean newActions, boolean deprecated) {
        ArrayList<ActionInfo> actions = new ArrayList<ActionInfo>();
        for (Action action : componentInfo.getComponent().getActions()) {
            boolean inherited;
            if ((!deprecated || !action.isDeprecated()) && (deprecated || action.isDeprecated())) continue;
            ComponentInfo defining = this.getDefiningComp(componentInfo, action);
            boolean bl = inherited = defining.getComponent() != componentInfo.getComponent();
            if ((!newActions || inherited) && (newActions || !inherited)) continue;
            actions.add(new ActionInfo(action, defining));
        }
        return actions;
    }

    public List<ActionInfo> getDeprecatedActions() {
        ArrayList<ActionInfo> deprecated = new ArrayList<ActionInfo>();
        for (Component comp : this.m_compSystem.getComponents()) {
            ComponentInfo ci = new ComponentInfo(comp, CompSystemProcessor.getToolkitInfo(comp.getToolkitDesriptor()));
            List<ActionInfo> actions = this.getActions(ci, true, true);
            for (ActionInfo ai : actions) {
                deprecated.add(ai);
            }
        }
        return deprecated;
    }

    public CompSystem getCompSystem() {
        return this.m_compSystem;
    }
}

