/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.app.core;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jubula.app.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.CommandHelper;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.handlers.IActionCommandMappingService;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IServiceLocator;

public class JubulaActionBarAdvisor
extends ActionBarAdvisor {
    private IWorkbenchWindow m_window;
    private ActionFactory.IWorkbenchAction m_quitAction;
    private ActionFactory.IWorkbenchAction m_prefAction;
    private ActionFactory.IWorkbenchAction m_helpCont;
    private ActionFactory.IWorkbenchAction m_intro;
    private ActionFactory.IWorkbenchAction m_fileSave;
    private ActionFactory.IWorkbenchAction m_fileSaveAll;
    private ActionFactory.IWorkbenchAction m_redo;
    private ActionFactory.IWorkbenchAction m_undo;
    private ActionFactory.IWorkbenchAction m_openWorkspaceAction;

    public JubulaActionBarAdvisor(IActionBarConfigurer configurer, IWorkbenchWindowConfigurer windowConfigurer) {
        super(configurer);
        this.m_window = configurer.getWindowConfigurer().getWindow();
    }

    public void fillActionBars(int flags) {
        if ((flags & 1) != 0) {
            return;
        }
        this.fillActionBars(this.getActionBarConfigurer(), flags);
    }

    public void fillActionBars(IActionBarConfigurer configurer, int flags) {
        if ((flags & 1) == 0) {
            this.makeActions(configurer);
        }
        if ((flags & 2) != 0) {
            this.fillMenuBar(configurer.getMenuManager());
        }
        if ((flags & 4) != 0) {
            this.fillCoolBar(configurer.getCoolBarManager());
        }
    }

    private void makeActions(IActionBarConfigurer configurer) {
        this.m_intro = ActionFactory.INTRO.create(this.m_window);
        this.register((IAction)this.m_intro);
        this.m_helpCont = ActionFactory.HELP_CONTENTS.create(this.m_window);
        this.register((IAction)this.m_helpCont);
        this.m_quitAction = ActionFactory.QUIT.create(this.m_window);
        this.register((IAction)this.m_quitAction);
        this.m_prefAction = ActionFactory.PREFERENCES.create(this.m_window);
        this.register((IAction)this.m_prefAction);
        this.m_fileSaveAll = ActionFactory.SAVE_ALL.create(this.m_window);
        this.register((IAction)this.m_fileSaveAll);
        this.m_fileSave = ActionFactory.SAVE.create(this.m_window);
        this.register((IAction)this.m_fileSave);
        this.m_openWorkspaceAction = IDEActionFactory.OPEN_WORKSPACE.create(this.m_window);
        this.register((IAction)this.m_openWorkspaceAction);
        this.m_redo = ActionFactory.REDO.create(this.m_window);
        this.register((IAction)this.m_redo);
        this.m_undo = ActionFactory.UNDO.create(this.m_window);
        this.register((IAction)this.m_undo);
    }

    public void fillMenuBar(IMenuManager menuBar) {
        menuBar.add((IContributionItem)this.createFileMenu());
        menuBar.add((IContributionItem)this.createEditMenu());
        menuBar.add((IContributionItem)this.createSearchMenu());
        menuBar.add((IContributionItem)this.createRunMenu());
        menuBar.add((IContributionItem)this.createWindowMenu());
        menuBar.add((IContributionItem)this.createHelpMenu());
    }

    private IMenuManager createEditMenu() {
        MenuManager editMenu = new MenuManager(Messages.ActionBuilderEdit, "edit");
        editMenu.add((IAction)this.m_redo);
        editMenu.add((IAction)this.m_undo);
        editMenu.add((IContributionItem)new Separator());
        editMenu.add(this.getCutItem());
        editMenu.add(this.getPasteItem());
        editMenu.add((IContributionItem)new Separator());
        editMenu.add((IContributionItem)new GroupMarker("JubulaEditSeparator1"));
        editMenu.add((IContributionItem)new Separator());
        editMenu.add((IContributionItem)new GroupMarker("JubulaEditSeparator2"));
        editMenu.add((IContributionItem)new Separator());
        editMenu.add((IContributionItem)new GroupMarker("JubulaEditSeparator3"));
        return editMenu;
    }

    private IMenuManager createSearchMenu() {
        MenuManager searchMenu = new MenuManager(Messages.ActionBuilderSearch, "org.eclipse.search.menu");
        return searchMenu;
    }

    private IMenuManager createRunMenu() {
        MenuManager runMenu = new MenuManager(Messages.ActionBuilderRun, "org.eclipse.ui.run");
        return runMenu;
    }

    private IMenuManager createFileMenu() {
        MenuManager fileMenu = new MenuManager(Messages.ActionBuilderMyFileEntry, "file");
        fileMenu.add((IAction)this.m_fileSave);
        fileMenu.add((IAction)this.m_fileSaveAll);
        fileMenu.add((IContributionItem)new Separator());
        CommandHelper.createContributionPushItem((IMenuManager)fileMenu, (String)"org.eclipse.ui.edit.rename");
        fileMenu.add(this.getRefreshItem());
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add((IAction)this.m_openWorkspaceAction);
        CommandHelper.createContributionPushItem((IMenuManager)fileMenu, (String)"org.eclipse.ui.file.restartWorkbench");
        fileMenu.add((IContributionItem)new Separator());
        CommandHelper.createContributionPushItem((IMenuManager)fileMenu, (String)ActionFactory.IMPORT.getCommandId());
        CommandHelper.createContributionPushItem((IMenuManager)fileMenu, (String)ActionFactory.EXPORT.getCommandId());
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add((IAction)this.m_quitAction);
        return fileMenu;
    }

    private IMenuManager createWindowMenu() {
        MenuManager windowMenu = new MenuManager(Messages.ActionBuilderWindowEntry, "window");
        windowMenu.add((IContributionItem)this.createOpenPersp());
        windowMenu.add((IContributionItem)this.createShowView());
        windowMenu.add((IContributionItem)new Separator());
        windowMenu.add(this.getResetPerspectiveItem());
        windowMenu.add((IContributionItem)new Separator());
        windowMenu.add((IAction)this.m_prefAction);
        return windowMenu;
    }

    private IMenuManager createShowView() {
        MenuManager showView = new MenuManager(Messages.ActionBuildershowView);
        showView.add(ContributionItemFactory.VIEWS_SHORTLIST.create(this.m_window));
        return showView;
    }

    private IMenuManager createOpenPersp() {
        MenuManager openPersp = new MenuManager(Messages.ActionBuilderopenPerspective);
        openPersp.add(ContributionItemFactory.PERSPECTIVES_SHORTLIST.create(this.m_window));
        return openPersp;
    }

    private IMenuManager createHelpMenu() {
        MenuManager helpMenu = new MenuManager(Messages.ActionBuilderMyHelpEntry, "help");
        helpMenu.add((IAction)this.m_intro);
        helpMenu.add((IAction)this.m_helpCont);
        helpMenu.add((IContributionItem)new Separator("helpEnd"));
        helpMenu.add((IContributionItem)new Separator());
        helpMenu.add((IContributionItem)new Separator("additions"));
        helpMenu.add((IContributionItem)new Separator());
        CommandHelper.createContributionPushItem((IMenuManager)helpMenu, (String)"org.eclipse.ui.help.aboutAction");
        return helpMenu;
    }

    public void fillCoolBar(ICoolBarManager coolBar) {
        ToolBarManager toolBar = new ToolBarManager(0x820000);
        toolBar.add((IContributionItem)new ActionContributionItem((IAction)this.m_fileSave));
        coolBar.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)toolBar, "main"));
        coolBar.add((IContributionItem)new Separator("additions"));
    }

    public void dispose() {
        if (this.m_fileSave != null) {
            this.m_fileSave.dispose();
        }
        if (this.m_helpCont != null) {
            this.m_helpCont.dispose();
        }
        if (this.m_prefAction != null) {
            this.m_prefAction.dispose();
        }
        if (this.m_quitAction != null) {
            this.m_quitAction.dispose();
        }
        if (this.m_openWorkspaceAction != null) {
            this.m_openWorkspaceAction.dispose();
        }
    }

    private IContributionItem getResetPerspectiveItem() {
        return this.getItem(ActionFactory.RESET_PERSPECTIVE.getId(), ActionFactory.RESET_PERSPECTIVE.getCommandId(), null, null, WorkbenchMessages.ResetPerspective_text, WorkbenchMessages.ResetPerspective_toolTip, "org.eclipse.ui.reset_perspective_action_context");
    }

    private IContributionItem getRefreshItem() {
        return this.getItem(ActionFactory.REFRESH.getId(), ActionFactory.REFRESH.getCommandId(), null, null, WorkbenchMessages.Workbench_refresh, WorkbenchMessages.Workbench_refreshToolTip, null);
    }

    private IContributionItem getPasteItem() {
        return this.getItem(ActionFactory.PASTE.getId(), ActionFactory.PASTE.getCommandId(), "IMG_TOOL_PASTE", "IMG_TOOL_PASTE_DISABLED", WorkbenchMessages.Workbench_paste, WorkbenchMessages.Workbench_pasteToolTip, null);
    }

    private IContributionItem getCutItem() {
        return this.getItem(ActionFactory.CUT.getId(), ActionFactory.CUT.getCommandId(), "IMG_TOOL_CUT", "IMG_TOOL_CUT_DISABLED", WorkbenchMessages.Workbench_cut, WorkbenchMessages.Workbench_cutToolTip, null);
    }

    private IContributionItem getItem(String actionId, String commandId, String image, String disabledImage, String label, String tooltip, String helpContextId) {
        IWorkbenchWindow window = this.m_window;
        ISharedImages sharedImages = window.getWorkbench().getSharedImages();
        IActionCommandMappingService acms = (IActionCommandMappingService)window.getService(IActionCommandMappingService.class);
        acms.map(actionId, commandId);
        CommandContributionItemParameter commandParm = new CommandContributionItemParameter((IServiceLocator)window, actionId, commandId, null, sharedImages.getImageDescriptor(image), sharedImages.getImageDescriptor(disabledImage), null, label, null, tooltip, 8, null, false);
        return new CommandContributionItem(commandParm);
    }
}

