/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.api.converter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.client.api.converter.NodeInfo;
import org.eclipse.jubula.client.api.converter.annotations.NodeType;
import org.eclipse.jubula.client.api.converter.exceptions.InvalidNodeNameException;
import org.eclipse.jubula.client.api.converter.utils.CompNameLoader;
import org.eclipse.jubula.client.api.converter.utils.ParamUtils;
import org.eclipse.jubula.client.api.converter.utils.Utils;
import org.eclipse.jubula.client.core.businessprocess.CompNamesBP;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesBP;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.ICompNamesPairPO;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IRefTestSuitePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestJobPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.core.model.ReentryProperty;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.toolkit.api.gen.internal.utils.NameLoader;
import org.eclipse.jubula.toolkit.common.businessprocess.ToolkitSupportBP;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.internal.exception.InvalidDataException;
import org.eclipse.jubula.tools.internal.xml.businessmodell.CompSystem;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Component;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ConcreteComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeGenerator {
    protected static String nl;
    public final String NL = nl == null ? System.getProperties().getProperty("line.separator") : nl;
    protected final String TEXT_1 = "package ";
    protected final String TEXT_2 = ";" + this.NL + this.NL + "import org.eclipse.jubula.client.AUT;" + this.NL + "import org.eclipse.jubula.client.api.converter.annotations.SrcNode;" + this.NL + "import org.eclipse.jubula.client.api.converter.annotations.NodeType;" + this.NL + "import org.eclipse.jubula.client.exceptions.ActionException;" + this.NL + "import org.eclipse.jubula.client.exceptions.CheckFailedException;" + this.NL + "import org.eclipse.jubula.client.exceptions.ComponentNotFoundException;" + this.NL + "import org.eclipse.jubula.client.exceptions.ConfigurationException;" + this.NL + "import org.eclipse.jubula.qa.api.converter.target.rcp.RuntimeContext;" + this.NL + "import org.eclipse.jubula.qa.api.converter.target.rcp.VariableStore;" + this.NL + "import org.eclipse.jubula.toolkit.enums.ValueSets.*;" + this.NL + "import org.eclipse.jubula.tools.ComponentIdentifier;" + this.NL + "import org.slf4j.Logger;" + this.NL + "import org.slf4j.LoggerFactory;" + this.NL + this.NL + "import ";
    protected final String TEXT_3 = ".CTDS;" + this.NL;
    protected final String TEXT_4 = String.valueOf(this.NL) + "import ";
    protected final String TEXT_5 = ";";
    protected final String TEXT_6 = String.valueOf(this.NL) + this.NL + "@SrcNode(UUID = \"";
    protected final String TEXT_7 = "\"," + this.NL + "         type = NodeType.";
    protected final String TEXT_8 = ", taskId = \"";
    protected final String TEXT_9 = "\"";
    protected final String TEXT_10 = ")" + this.NL + "public class ";
    protected final String TEXT_11 = " {" + this.NL + this.NL + "    /** the logger */" + this.NL + "    private static Logger log = LoggerFactory.getLogger(";
    protected final String TEXT_12 = ".class);" + this.NL + "    ";
    protected final String TEXT_13 = String.valueOf(this.NL) + "    private RuntimeContext rtc;";
    protected final String TEXT_14 = String.valueOf(this.NL) + "    private ComponentIdentifier ";
    protected final String TEXT_15 = ";" + this.NL + "    ";
    protected final String TEXT_16 = String.valueOf(this.NL) + "    " + this.NL + "    public ";
    protected final String TEXT_17 = " (RuntimeContext _rtc";
    protected final String TEXT_18 = ",";
    protected final String TEXT_19 = String.valueOf(this.NL) + "        " + this.NL + "        ComponentIdentifier _";
    protected final String TEXT_20 = ",";
    protected final String TEXT_21 = String.valueOf(this.NL) + "    ) {" + this.NL + "        rtc = _rtc;";
    protected final String TEXT_22 = String.valueOf(this.NL) + "        ";
    protected final String TEXT_23 = String.valueOf(this.NL) + "        ";
    protected final String TEXT_24 = " = _";
    protected final String TEXT_25 = ";";
    protected final String TEXT_26 = String.valueOf(this.NL) + "    }";
    protected final String TEXT_27 = String.valueOf(this.NL) + "    private RuntimeContext rtc;" + this.NL + "    " + this.NL + "    public ";
    protected final String TEXT_28 = " (AUT _aut) {" + this.NL + "        rtc = new RuntimeContext(_aut, ";
    protected final String TEXT_29 = ", ";
    protected final String TEXT_30 = ", ";
    protected final String TEXT_31 = ", ";
    protected final String TEXT_32 = ");" + this.NL + "    }";
    protected final String TEXT_33 = String.valueOf(this.NL) + "    public ";
    protected final String TEXT_34 = " () {" + this.NL + "        super();" + this.NL + "    }";
    protected final String TEXT_35 = String.valueOf(this.NL) + "    ";
    protected final String TEXT_36 = "/** ";
    protected final String TEXT_37 = " */";
    protected final String TEXT_38 = String.valueOf(this.NL) + "    public void execute(";
    protected final String TEXT_39 = String.valueOf(this.NL) + "        ";
    protected final String TEXT_40 = " ";
    protected final String TEXT_41 = ",";
    protected final String TEXT_42 = String.valueOf(this.NL) + "    ) {";
    protected final String TEXT_43 = String.valueOf(this.NL) + "        AUT aut = rtc.getAUT();";
    protected final String TEXT_44 = String.valueOf(this.NL) + "        ";
    protected final String TEXT_45 = String.valueOf(this.NL) + "        " + this.NL + "        rtc.beginIgnoreCheckFailed();";
    protected final String TEXT_46 = String.valueOf(this.NL) + "        " + this.NL + "        rtc.doNotIgnoreCheckFailed();";
    protected final String TEXT_47 = String.valueOf(this.NL) + "        " + this.NL + "        rtc.beginIgnoreActionError();";
    protected final String TEXT_48 = String.valueOf(this.NL) + "        " + this.NL + "        rtc.doNotIgnoreActionError();";
    protected final String TEXT_49 = String.valueOf(this.NL) + "        " + this.NL + "        rtc.beginIgnoreCompNotFound();";
    protected final String TEXT_50 = String.valueOf(this.NL) + "        " + this.NL + "        rtc.doNotIgnoreCompNotFound();";
    protected final String TEXT_51 = String.valueOf(this.NL) + "        " + this.NL + "        rtc.beginIgnoreConfigurationError();";
    protected final String TEXT_52 = String.valueOf(this.NL) + "        " + this.NL + "        rtc.doNotIgnoreConfigurationError();";
    protected final String TEXT_53 = String.valueOf(this.NL) + "        ";
    protected final String TEXT_54 = String.valueOf(this.NL) + "        try {";
    protected final String TEXT_55 = String.valueOf(this.NL) + "        ";
    protected final String TEXT_56 = String.valueOf(this.NL) + "        ";
    protected final String TEXT_57 = "//";
    protected final String TEXT_58 = "// Comment: ";
    protected final String TEXT_59 = String.valueOf(this.NL) + "        ";
    protected final String TEXT_60 = String.valueOf(this.NL) + "        ";
    protected final String TEXT_61 = "// Hint: this line is commented out because its correspondent node in the ITE was inactive" + this.NL + "        ";
    protected final String TEXT_62 = "//";
    protected final String TEXT_63 = "aut.execute(" + this.NL + "            ";
    protected final String TEXT_64 = "//";
    protected final String TEXT_65 = ".create";
    protected final String TEXT_66 = "(";
    protected final String TEXT_67 = ")" + this.NL + "                ";
    protected final String TEXT_68 = "//";
    protected final String TEXT_69 = ".";
    protected final String TEXT_70 = "(";
    protected final String TEXT_71 = String.valueOf(this.NL) + "                    ";
    protected final String TEXT_72 = "//";
    protected final String TEXT_73 = ".";
    protected final String TEXT_74 = "(";
    protected final String TEXT_75 = ")";
    protected final String TEXT_76 = String.valueOf(this.NL) + "                    ";
    protected final String TEXT_77 = "//";
    protected final String TEXT_78 = ",";
    protected final String TEXT_79 = "//";
    protected final String TEXT_80 = ")," + this.NL + "            ";
    protected final String TEXT_81 = "//";
    protected final String TEXT_82 = "null);" + this.NL + "            ";
    protected final String TEXT_83 = String.valueOf(this.NL) + "        " + this.NL + "        // TODO: Usage of unsupported client / ITE-side action ";
    protected final String TEXT_84 = "." + this.NL;
    protected final String TEXT_85 = String.valueOf(this.NL) + "        ";
    protected final String TEXT_86 = "// Hint: this line is commented out because its correspondent node in the ITE was inactive" + this.NL + "        ";
    protected final String TEXT_87 = "//";
    protected final String TEXT_88 = "// ";
    protected final String TEXT_89 = String.valueOf(this.NL) + "        ";
    protected final String TEXT_90 = "//";
    protected final String TEXT_91 = "new ";
    protected final String TEXT_92 = "(" + this.NL + "                ";
    protected final String TEXT_93 = "//";
    protected final String TEXT_94 = "rtc";
    protected final String TEXT_95 = ",";
    protected final String TEXT_96 = String.valueOf(this.NL) + "                ";
    protected final String TEXT_97 = "//";
    protected final String TEXT_98 = ",";
    protected final String TEXT_99 = String.valueOf(this.NL) + "            ";
    protected final String TEXT_100 = "//";
    protected final String TEXT_101 = ").execute(";
    protected final String TEXT_102 = String.valueOf(this.NL) + "                ";
    protected final String TEXT_103 = "//";
    protected final String TEXT_104 = String.valueOf(this.NL) + "                ";
    protected final String TEXT_105 = "//";
    protected final String TEXT_106 = ",";
    protected final String TEXT_107 = String.valueOf(this.NL) + "            ";
    protected final String TEXT_108 = "//";
    protected final String TEXT_109 = ");";
    protected final String TEXT_110 = String.valueOf(this.NL) + "        ";
    protected final String TEXT_111 = "// Hint: this line is commented out because its correspondent node in the ITE was inactive" + this.NL + "        ";
    protected final String TEXT_112 = "//";
    protected final String TEXT_113 = "for (CTDS.";
    protected final String TEXT_114 = " row : CTDS.";
    protected final String TEXT_115 = ".data) {" + this.NL + "            ";
    protected final String TEXT_116 = "//";
    protected final String TEXT_117 = "// ";
    protected final String TEXT_118 = String.valueOf(this.NL) + "            ";
    protected final String TEXT_119 = "//";
    protected final String TEXT_120 = "new ";
    protected final String TEXT_121 = "(" + this.NL + "                ";
    protected final String TEXT_122 = "//";
    protected final String TEXT_123 = "rtc";
    protected final String TEXT_124 = ",";
    protected final String TEXT_125 = String.valueOf(this.NL) + "                ";
    protected final String TEXT_126 = "//";
    protected final String TEXT_127 = "null";
    protected final String TEXT_128 = ",";
    protected final String TEXT_129 = String.valueOf(this.NL) + "            ";
    protected final String TEXT_130 = "//";
    protected final String TEXT_131 = ").execute(" + this.NL + "                ";
    protected final String TEXT_132 = "//";
    protected final String TEXT_133 = "row.";
    protected final String TEXT_134 = ",";
    protected final String TEXT_135 = String.valueOf(this.NL) + "                ";
    protected final String TEXT_136 = "//";
    protected final String TEXT_137 = ");" + this.NL + "        ";
    protected final String TEXT_138 = "//";
    protected final String TEXT_139 = "}";
    protected final String TEXT_140 = String.valueOf(this.NL) + "        ";
    protected final String TEXT_141 = String.valueOf(this.NL) + "        ";
    protected final String TEXT_142 = "// Hint: this line is commented out because its correspondent node in the ITE was inactive" + this.NL + "        ";
    protected final String TEXT_143 = "// ";
    protected final String TEXT_144 = "AUT ";
    protected final String TEXT_145 = " = null; // TODO: Define AUT manually" + this.NL + "        ";
    protected final String TEXT_146 = "// ";
    protected final String TEXT_147 = ".connect();" + this.NL + "        ";
    protected final String TEXT_148 = "//";
    protected final String TEXT_149 = "// ";
    protected final String TEXT_150 = String.valueOf(this.NL) + "        ";
    protected final String TEXT_151 = "// ";
    protected final String TEXT_152 = "new ";
    protected final String TEXT_153 = "(";
    protected final String TEXT_154 = ").execute();" + this.NL + "        ";
    protected final String TEXT_155 = "// ";
    protected final String TEXT_156 = ".disconnect();" + this.NL + "        ";
    protected final String TEXT_157 = String.valueOf(this.NL) + "        ";
    protected final String TEXT_158 = String.valueOf(this.NL) + "        " + this.NL + "        }";
    protected final String TEXT_159 = String.valueOf(this.NL) + "        ";
    protected final String TEXT_160 = String.valueOf(this.NL) + "        " + this.NL + "        catch (";
    protected final String TEXT_161 = " e) {" + this.NL + "            log.debug(\"Exception during test execution\", e);" + this.NL + "            // TODO: Commented out event handler. (Commenting in does not necessarily lead to same test execution as in ITE)";
    protected final String TEXT_162 = String.valueOf(this.NL) + "            //new ";
    protected final String TEXT_163 = "(rtc";
    protected final String TEXT_164 = ",";
    protected final String TEXT_165 = String.valueOf(this.NL) + "                    //";
    protected final String TEXT_166 = ",";
    protected final String TEXT_167 = String.valueOf(this.NL) + "                //).execute(";
    protected final String TEXT_168 = String.valueOf(this.NL) + "                        //";
    protected final String TEXT_169 = String.valueOf(this.NL) + "                        ";
    protected final String TEXT_170 = "//,";
    protected final String TEXT_171 = String.valueOf(this.NL) + "                        //);";
    protected final String TEXT_172 = String.valueOf(this.NL) + "        }";
    protected final String TEXT_173 = String.valueOf(this.NL) + "        // TODO: This test case used Event Handler which you have to replace manually:" + this.NL + "        //       Event Type: ";
    protected final String TEXT_174 = String.valueOf(this.NL) + "        //       Re-Entry Property: ";
    protected final String TEXT_175 = String.valueOf(this.NL) + "        //       Used Test Case: ";
    protected final String TEXT_176 = String.valueOf(this.NL) + "        //            new ";
    protected final String TEXT_177 = "(rtc).execute(";
    protected final String TEXT_178 = String.valueOf(this.NL) + "        //                ";
    protected final String TEXT_179 = ",";
    protected final String TEXT_180 = String.valueOf(this.NL) + "        //            );";
    protected final String TEXT_181 = String.valueOf(this.NL) + "        ";
    protected final String TEXT_182 = String.valueOf(this.NL) + "        finally {" + this.NL + "          rtc.endLocalEventHandling(";
    protected final String TEXT_183 = ", ";
    protected final String TEXT_184 = ", ";
    protected final String TEXT_185 = ", ";
    protected final String TEXT_186 = ");" + this.NL + "        }";
    protected final String TEXT_187 = String.valueOf(this.NL) + "    }" + this.NL + "}";

    public static synchronized NodeGenerator create(String lineSeparator) {
        nl = lineSeparator;
        NodeGenerator result = new NodeGenerator();
        nl = null;
        return result;
    }

    public String generate(Object argument) {
        ListIterator childParamIterator;
        ISpecTestCasePO tc;
        StringBuffer stringBuffer = new StringBuffer();
        Logger log = LoggerFactory.getLogger(NodeGenerator.class);
        Map<String, NodeInfo> uuidToNodeInfoMap = NodeInfo.getUuidToNodeInfoMap();
        NodeInfo info = (NodeInfo)argument;
        String className = info.getClassName();
        INodePO node = info.getNode();
        String uuid = node.getGuid();
        String comment = node.getComment();
        boolean hasComment = StringUtils.isNotBlank((String)comment);
        String taskId = node.getTaskId();
        boolean hasTaskId = StringUtils.isNotBlank((String)taskId);
        Locale locale = info.getLanguage();
        Iterator childIterator = node.getNodeListIterator();
        info.getPackageBasePath();
        NameLoader nameLoader = NameLoader.getInstance();
        ComponentNamesBP componentNamesBP = ComponentNamesBP.getInstance();
        CompNamesBP compNamesBP = new CompNamesBP();
        ArrayList<String> compIdentifierNames = new ArrayList<String>();
        boolean definesLocalCheckFailedHandling = false;
        boolean definesLocalActionErrorHandling = false;
        boolean definesLocalCompNotFoundHandling = false;
        boolean definesLocalConfigurationErrorHandling = false;
        boolean definesLocalEventHandling = false;
        info.getFqName();
        String packageName = info.getPackageName();
        String ctdsPath = Utils.getProjectPath(info.getPackageBasePath(), info.getProjectName());
        NodeType nodeType = NodeType.UNKNOWN;
        if (node instanceof ISpecTestCasePO) {
            nodeType = NodeType.TEST_CASE;
        } else if (node instanceof ITestJobPO) {
            nodeType = NodeType.TEST_JOB;
        } else if (node instanceof ITestSuitePO) {
            nodeType = NodeType.TEST_SUITE;
        }
        stringBuffer.append("package ");
        stringBuffer.append(packageName);
        stringBuffer.append(this.TEXT_2);
        stringBuffer.append(ctdsPath);
        stringBuffer.append(this.TEXT_3);
        childIterator = node.getNodeListIterator();
        ArrayList<NodeInfo> classesToImport = new ArrayList<NodeInfo>();
        ArrayList<NodeInfo> duplicateClasses = new ArrayList<NodeInfo>();
        while (childIterator.hasNext()) {
            INodePO child = (INodePO)childIterator.next();
            NodeInfo childInfo = null;
            if (child instanceof ICapPO) continue;
            if (child instanceof IExecTestCasePO) {
                IExecTestCasePO exec = (IExecTestCasePO)child;
                ISpecTestCasePO spec = exec.getSpecTestCase();
                childInfo = uuidToNodeInfoMap.get(spec.getGuid());
            } else if (child instanceof IRefTestSuitePO) {
                IRefTestSuitePO ref = (IRefTestSuitePO)child;
                ITestSuitePO testSuite = ref.getTestSuite();
                childInfo = uuidToNodeInfoMap.get(testSuite.getGuid());
            }
            Utils.classifyImport(className, classesToImport, duplicateClasses, childInfo);
        }
        if (node instanceof ISpecTestCasePO) {
            tc = (ISpecTestCasePO)node;
            for (IEventExecTestCasePO eventTC : tc.getAllEventEventExecTC()) {
                eventTC.getEventType();
                ReentryProperty reentryProp = eventTC.getReentryProp();
                if (!reentryProp.equals((Object)ReentryProperty.RETURN)) continue;
                NodeInfo childInfo = uuidToNodeInfoMap.get(eventTC.getSpecTestCase().getGuid());
                Utils.classifyImport(className, classesToImport, duplicateClasses, childInfo);
            }
        }
        for (NodeInfo nodeInfo : classesToImport) {
            String fqChildName = nodeInfo.getFqName();
            stringBuffer.append(this.TEXT_4);
            stringBuffer.append(fqChildName);
            stringBuffer.append(";");
        }
        stringBuffer.append(this.TEXT_6);
        stringBuffer.append(uuid);
        stringBuffer.append(this.TEXT_7);
        stringBuffer.append(nodeType);
        if (hasTaskId) {
            stringBuffer.append(", taskId = \"");
            stringBuffer.append(taskId);
            stringBuffer.append("\"");
        }
        stringBuffer.append(this.TEXT_10);
        stringBuffer.append(className);
        stringBuffer.append(this.TEXT_11);
        stringBuffer.append(className);
        stringBuffer.append(this.TEXT_12);
        if (node instanceof ISpecTestCasePO) {
            String compIdentifierName2;
            stringBuffer.append(this.TEXT_13);
            IExecTestCasePO fakeExec = NodeMaker.createExecTestCasePO((ISpecTestCasePO)((ISpecTestCasePO)node));
            List compNamePairs = compNamesBP.getAllCompNamesPairs(fakeExec);
            for (ICompNamesPairPO pair : compNamePairs) {
                compIdentifierName2 = "";
                compIdentifierName2 = componentNamesBP.getName(pair.getSecondName());
                if (StringUtils.isBlank((String)compIdentifierName2) || compIdentifierNames.contains(compIdentifierName2)) continue;
                compIdentifierNames.add(compIdentifierName2);
                stringBuffer.append(this.TEXT_14);
                stringBuffer.append(compIdentifierName2);
                stringBuffer.append(this.TEXT_15);
            }
            Iterator compIdentifierIterator = compIdentifierNames.iterator();
            stringBuffer.append(this.TEXT_16);
            stringBuffer.append(className);
            stringBuffer.append(" (RuntimeContext _rtc");
            if (compIdentifierIterator.hasNext()) {
                stringBuffer.append(",");
            }
            while (compIdentifierIterator.hasNext()) {
                compIdentifierName2 = (String)compIdentifierIterator.next();
                stringBuffer.append(this.TEXT_19);
                stringBuffer.append(compIdentifierName2);
                if (!compIdentifierIterator.hasNext()) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append(this.TEXT_21);
            for (String compIdentifierName2 : compIdentifierNames) {
                stringBuffer.append(this.TEXT_22);
                stringBuffer.append(this.TEXT_23);
                stringBuffer.append(compIdentifierName2);
                stringBuffer.append(" = _");
                stringBuffer.append(compIdentifierName2);
                stringBuffer.append(";");
            }
            stringBuffer.append(this.TEXT_26);
        } else if (node instanceof ITestSuitePO) {
            ITestSuitePO ts = (ITestSuitePO)node;
            Map defaultEventHandlers = ts.getDefaultEventHandler();
            boolean suppressCheckFailedDefault = false;
            boolean suppressActionErrorDefault = false;
            boolean suppressCompNotFoundDefault = false;
            boolean suppressConfigurationErrorDefault = false;
            for (String handler : defaultEventHandlers.keySet()) {
                try {
                    if (handler.equals("TestErrorEvent.VerifyFailed") && ReentryProperty.getProperty((Integer)((Integer)defaultEventHandlers.get(handler))) == ReentryProperty.CONTINUE) {
                        suppressCheckFailedDefault = true;
                        continue;
                    }
                    if (handler.equals("TestErrorEvent.Action") && ReentryProperty.getProperty((Integer)((Integer)defaultEventHandlers.get(handler))) == ReentryProperty.CONTINUE) {
                        suppressActionErrorDefault = true;
                        continue;
                    }
                    if (handler.equals("TestErrorEvent.CompNotFound") && ReentryProperty.getProperty((Integer)((Integer)defaultEventHandlers.get(handler))) == ReentryProperty.CONTINUE) {
                        suppressCompNotFoundDefault = true;
                        continue;
                    }
                    if (!handler.equals("TestErrorEvent.Config") || ReentryProperty.getProperty((Integer)((Integer)defaultEventHandlers.get(handler))) != ReentryProperty.CONTINUE) continue;
                    suppressConfigurationErrorDefault = true;
                }
                catch (InvalidDataException invalidDataException) {
                    Plugin.getDefault().writeErrorLineToConsole("Error while creating default event handler.", true);
                }
            }
            stringBuffer.append(this.TEXT_27);
            stringBuffer.append(className);
            stringBuffer.append(this.TEXT_28);
            stringBuffer.append(suppressCheckFailedDefault);
            stringBuffer.append(", ");
            stringBuffer.append(suppressActionErrorDefault);
            stringBuffer.append(", ");
            stringBuffer.append(suppressCompNotFoundDefault);
            stringBuffer.append(", ");
            stringBuffer.append(suppressConfigurationErrorDefault);
            stringBuffer.append(this.TEXT_32);
        } else {
            stringBuffer.append(this.TEXT_33);
            stringBuffer.append(className);
            stringBuffer.append(this.TEXT_34);
        }
        stringBuffer.append(this.TEXT_35);
        if (hasComment) {
            stringBuffer.append("/** ");
            stringBuffer.append(comment);
            stringBuffer.append(" */");
        }
        stringBuffer.append(this.TEXT_38);
        if (node instanceof ISpecTestCasePO) {
            tc = (ISpecTestCasePO)node;
            ListIterator paramIterator = tc.getParameterListIter();
            while (paramIterator.hasNext()) {
                IParamDescriptionPO param = (IParamDescriptionPO)paramIterator.next();
                String paramType = nameLoader.findTypeForParameter(param.getType(), "");
                paramType = NameLoader.beautifyParamType((String)paramType);
                String paramName = param.getName();
                stringBuffer.append(this.TEXT_39);
                stringBuffer.append(paramType);
                stringBuffer.append(" ");
                stringBuffer.append(paramName);
                if (!paramIterator.hasNext()) continue;
                stringBuffer.append(",");
            }
        }
        stringBuffer.append(this.TEXT_42);
        if (node instanceof ISpecTestCasePO) {
            stringBuffer.append(this.TEXT_43);
        }
        stringBuffer.append(this.TEXT_44);
        if (node instanceof ISpecTestCasePO) {
            tc = (ISpecTestCasePO)node;
            for (IEventExecTestCasePO eventTC : tc.getAllEventEventExecTC()) {
                String eventType = eventTC.getEventType();
                String reentryProp = eventTC.getReentryProp().toString();
                if (eventType.equals("TestErrorEvent.VerifyFailed")) {
                    if (reentryProp.equals(ReentryProperty.CONTINUE.toString())) {
                        stringBuffer.append(this.TEXT_45);
                    } else {
                        stringBuffer.append(this.TEXT_46);
                    }
                    definesLocalCheckFailedHandling = true;
                    continue;
                }
                if (eventType.equals("TestErrorEvent.Action")) {
                    if (reentryProp.equals(ReentryProperty.CONTINUE.toString())) {
                        stringBuffer.append(this.TEXT_47);
                    } else {
                        stringBuffer.append(this.TEXT_48);
                    }
                    definesLocalActionErrorHandling = true;
                    continue;
                }
                if (eventType.equals("TestErrorEvent.CompNotFound")) {
                    if (reentryProp.equals(ReentryProperty.CONTINUE.toString())) {
                        stringBuffer.append(this.TEXT_49);
                    } else {
                        stringBuffer.append(this.TEXT_50);
                    }
                    definesLocalCompNotFoundHandling = true;
                    continue;
                }
                if (!eventType.equals("TestErrorEvent.Config")) continue;
                if (reentryProp.equals(ReentryProperty.CONTINUE.toString())) {
                    stringBuffer.append(this.TEXT_51);
                } else {
                    stringBuffer.append(this.TEXT_52);
                }
                definesLocalConfigurationErrorHandling = true;
            }
        }
        definesLocalEventHandling = definesLocalCheckFailedHandling | definesLocalActionErrorHandling | definesLocalCompNotFoundHandling | definesLocalConfigurationErrorHandling;
        stringBuffer.append(this.TEXT_53);
        if (definesLocalEventHandling) {
            stringBuffer.append(this.TEXT_54);
        }
        stringBuffer.append(this.TEXT_55);
        ArrayList<String> autList = new ArrayList<String>();
        stringBuffer.append(this.TEXT_56);
        childIterator = node.getNodeListIterator();
        while (childIterator.hasNext()) {
            IParamDescriptionPO param;
            INodePO child = (INodePO)childIterator.next();
            boolean isActive = child.isActive();
            comment = child.getComment();
            hasComment = StringUtils.isNotBlank((String)comment);
            if (hasComment) {
                if (!isActive) {
                    stringBuffer.append("//");
                }
                stringBuffer.append("// Comment: ");
                stringBuffer.append(comment);
                stringBuffer.append(this.TEXT_59);
            }
            if (child instanceof ICapPO) {
                String componentNameToCreate;
                String factoryName;
                ICapPO cap = (ICapPO)child;
                String componentFromCap = cap.getComponentType();
                CompNameLoader loader = new CompNameLoader(componentFromCap);
                String actionName = loader.get(cap.getActionName());
                boolean hasDefaultMapping = loader.get("hasDefaultMapping").equals("true");
                ConcreteComponent cc = null;
                CompSystem compSystem = ComponentBuilder.getInstance().getCompSystem();
                Component c = compSystem.getComponentForType(componentFromCap);
                if (c instanceof ConcreteComponent) {
                    cc = (ConcreteComponent)c;
                }
                String compIdentifierName = "";
                if (hasDefaultMapping) {
                    String toolkitID = info.getDefaultToolkit();
                    factoryName = Utils.getFactoryName(toolkitID);
                    ConcreteComponent componentToCreate = ToolkitSupportBP.getMostAbstractRealizingComponentInToolkit((String)toolkitID, (ConcreteComponent)cc);
                    CompNameLoader newLoader = new CompNameLoader(componentToCreate.getType());
                    componentNameToCreate = newLoader.get("componentTypeName");
                } else {
                    factoryName = loader.get("factoryName");
                    componentNameToCreate = loader.get("componentTypeName");
                    compIdentifierName = componentNamesBP.getName(cap.getComponentName());
                }
                if (actionName != null) {
                    stringBuffer.append(this.TEXT_60);
                    if (!isActive) {
                        stringBuffer.append(this.TEXT_61);
                    }
                    if (!isActive) {
                        stringBuffer.append("//");
                    }
                    stringBuffer.append(this.TEXT_63);
                    if (!isActive) {
                        stringBuffer.append("//");
                    }
                    stringBuffer.append(factoryName);
                    stringBuffer.append(".create");
                    stringBuffer.append(componentNameToCreate);
                    stringBuffer.append("(");
                    if (!hasDefaultMapping && StringUtils.isNotBlank((String)compIdentifierName)) {
                        stringBuffer.append(compIdentifierName);
                    }
                    stringBuffer.append(this.TEXT_67);
                    if (!isActive) {
                        stringBuffer.append("//");
                    }
                    stringBuffer.append(".");
                    stringBuffer.append(actionName);
                    stringBuffer.append("(");
                    ListIterator childParamIterator2 = cap.getParameterListIter();
                    while (childParamIterator2.hasNext()) {
                        param = (IParamDescriptionPO)childParamIterator2.next();
                        String paramType = param.getUniqueId();
                        String enumType = nameLoader.getEnumForParam(paramType);
                        String paramValue = ParamUtils.getValueForParam((IParameterInterfacePO)cap, param, 0, locale);
                        Boolean isEnum = enumType != null;
                        if (isEnum.booleanValue()) {
                            enumType = NameLoader.beautifyParamType((String)enumType);
                        }
                        String enumLookupMethodName = isEnum != false && (enumType.equals("Operator") || enumType.equals("AUTActivationMethod") || enumType.equals("Modifier")) ? "literalAsEnum" : "valueOf";
                        stringBuffer.append(this.TEXT_71);
                        if (!isActive) {
                            stringBuffer.append("//");
                        }
                        if (isEnum.booleanValue()) {
                            stringBuffer.append(enumType);
                            stringBuffer.append(".");
                            stringBuffer.append(enumLookupMethodName);
                            stringBuffer.append("(");
                        }
                        stringBuffer.append(paramValue);
                        if (isEnum.booleanValue()) {
                            stringBuffer.append(")");
                        }
                        stringBuffer.append(this.TEXT_76);
                        if (!childParamIterator2.hasNext()) continue;
                        if (!isActive) {
                            stringBuffer.append("//");
                        }
                        stringBuffer.append(",");
                    }
                    if (!isActive) {
                        stringBuffer.append("//");
                    }
                    stringBuffer.append(this.TEXT_80);
                    if (!isActive) {
                        stringBuffer.append("//");
                    }
                    stringBuffer.append(this.TEXT_82);
                    continue;
                }
                stringBuffer.append(this.TEXT_83);
                stringBuffer.append(cap.getActionName());
                stringBuffer.append(this.TEXT_84);
                continue;
            }
            if (child instanceof IExecTestCasePO) {
                IExecTestCasePO exec = (IExecTestCasePO)child;
                ISpecTestCasePO spec = exec.getSpecTestCase();
                String referenceName = exec.getRealName();
                boolean hasReferenceName = StringUtils.isNotBlank((String)referenceName);
                String testCaseName = "";
                NodeInfo specInfo = uuidToNodeInfoMap.get(spec.getGuid());
                testCaseName = classesToImport.contains(specInfo) ? specInfo.getClassName() : specInfo.getFqName();
                List<String> childCompIdentifierNames = Utils.determineCompIdentifierList(componentNamesBP, compNamesBP, exec);
                Iterator<String> childCompIdentifierNamesIterator = childCompIdentifierNames.iterator();
                IParameterInterfacePO dataCube = exec.getReferencedDataCube();
                if (dataCube == null) {
                    int rowCount = exec.getDataManager().getDataSetCount();
                    int row = 0;
                    do {
                        childCompIdentifierNamesIterator = childCompIdentifierNames.iterator();
                        stringBuffer.append(this.TEXT_85);
                        if (!isActive) {
                            stringBuffer.append(this.TEXT_86);
                        }
                        if (hasReferenceName) {
                            if (!isActive) {
                                stringBuffer.append("//");
                            }
                            stringBuffer.append("// ");
                            stringBuffer.append(referenceName);
                            stringBuffer.append(this.TEXT_89);
                        }
                        if (!isActive) {
                            stringBuffer.append("//");
                        }
                        stringBuffer.append("new ");
                        stringBuffer.append(testCaseName);
                        stringBuffer.append(this.TEXT_92);
                        if (!isActive) {
                            stringBuffer.append("//");
                        }
                        stringBuffer.append("rtc");
                        if (childCompIdentifierNamesIterator.hasNext()) {
                            stringBuffer.append(",");
                        }
                        while (childCompIdentifierNamesIterator.hasNext()) {
                            String childCompIdentifierName = childCompIdentifierNamesIterator.next();
                            stringBuffer.append(this.TEXT_96);
                            if (!isActive) {
                                stringBuffer.append("//");
                            }
                            stringBuffer.append(childCompIdentifierName);
                            if (!childCompIdentifierNamesIterator.hasNext()) continue;
                            stringBuffer.append(",");
                        }
                        stringBuffer.append(this.TEXT_99);
                        if (!isActive) {
                            stringBuffer.append("//");
                        }
                        stringBuffer.append(").execute(");
                        childParamIterator = exec.getParameterListIter();
                        while (childParamIterator.hasNext()) {
                            param = (IParamDescriptionPO)childParamIterator.next();
                            String paramValue = ParamUtils.getValueForParam((IParameterInterfacePO)exec, param, row, locale);
                            stringBuffer.append(this.TEXT_102);
                            if (!isActive) {
                                stringBuffer.append("//");
                            }
                            stringBuffer.append(paramValue);
                            if (!childParamIterator.hasNext()) continue;
                            stringBuffer.append(this.TEXT_104);
                            if (!isActive) {
                                stringBuffer.append("//");
                            }
                            stringBuffer.append(",");
                        }
                        ++row;
                        stringBuffer.append(this.TEXT_107);
                        if (!isActive) {
                            stringBuffer.append("//");
                        }
                        stringBuffer.append(");");
                    } while (row < rowCount);
                } else {
                    String dataCubeName = null;
                    try {
                        dataCubeName = Utils.determineClassName((IPersistentObject)dataCube);
                    }
                    catch (InvalidNodeNameException e) {
                        log.error("Invalid Data Set Name", (Throwable)e);
                    }
                    stringBuffer.append(this.TEXT_110);
                    if (!isActive) {
                        stringBuffer.append(this.TEXT_111);
                    }
                    if (!isActive) {
                        stringBuffer.append("//");
                    }
                    stringBuffer.append("for (CTDS.");
                    stringBuffer.append(dataCubeName);
                    stringBuffer.append(" row : CTDS.");
                    stringBuffer.append(dataCubeName);
                    stringBuffer.append(this.TEXT_115);
                    if (hasReferenceName) {
                        if (!isActive) {
                            stringBuffer.append("//");
                        }
                        stringBuffer.append("// ");
                        stringBuffer.append(referenceName);
                        stringBuffer.append(this.TEXT_118);
                    }
                    if (!isActive) {
                        stringBuffer.append("//");
                    }
                    stringBuffer.append("new ");
                    stringBuffer.append(testCaseName);
                    stringBuffer.append(this.TEXT_121);
                    if (!isActive) {
                        stringBuffer.append("//");
                    }
                    stringBuffer.append("rtc");
                    if (childCompIdentifierNamesIterator.hasNext()) {
                        stringBuffer.append(",");
                    }
                    while (childCompIdentifierNamesIterator.hasNext()) {
                        childCompIdentifierNamesIterator.next();
                        stringBuffer.append(this.TEXT_125);
                        if (!isActive) {
                            stringBuffer.append("//");
                        }
                        stringBuffer.append("null");
                        if (!childCompIdentifierNamesIterator.hasNext()) continue;
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(this.TEXT_129);
                    if (!isActive) {
                        stringBuffer.append("//");
                    }
                    stringBuffer.append(this.TEXT_131);
                    childParamIterator = exec.getParameterListIter();
                    while (childParamIterator.hasNext()) {
                        IParamDescriptionPO param2 = (IParamDescriptionPO)childParamIterator.next();
                        if (!isActive) {
                            stringBuffer.append("//");
                        }
                        stringBuffer.append("row.");
                        stringBuffer.append(param2.getName());
                        if (childParamIterator.hasNext()) {
                            stringBuffer.append(",");
                        }
                        stringBuffer.append(this.TEXT_135);
                    }
                    if (!isActive) {
                        stringBuffer.append("//");
                    }
                    stringBuffer.append(this.TEXT_137);
                    if (!isActive) {
                        stringBuffer.append("//");
                    }
                    stringBuffer.append("}");
                }
                stringBuffer.append(this.TEXT_140);
                continue;
            }
            if (!(child instanceof IRefTestSuitePO)) continue;
            IRefTestSuitePO ref = (IRefTestSuitePO)child;
            ITestSuitePO testSuite = ref.getTestSuite();
            String referenceName = ref.getName();
            boolean hasReferenceName = StringUtils.isNotBlank((String)referenceName) && !referenceName.equals(testSuite.getName());
            NodeInfo testSuiteInfo = uuidToNodeInfoMap.get(testSuite.getGuid());
            String testSuiteName = classesToImport.contains(testSuiteInfo) ? testSuiteInfo.getClassName() : testSuiteInfo.getFqName();
            String autName = StringUtils.deleteWhitespace((String)testSuite.getAut().getName());
            Boolean newAUT = false;
            if (!autList.contains(autName) && isActive) {
                newAUT = true;
                autList.add(autName);
            }
            stringBuffer.append(this.TEXT_141);
            if (!isActive) {
                stringBuffer.append(this.TEXT_142);
            }
            if (newAUT.booleanValue()) {
                if (!isActive) {
                    stringBuffer.append("// ");
                }
                stringBuffer.append("AUT ");
                stringBuffer.append(autName);
                stringBuffer.append(this.TEXT_145);
            }
            if (!isActive) {
                stringBuffer.append("// ");
            }
            stringBuffer.append(autName);
            stringBuffer.append(this.TEXT_147);
            if (hasReferenceName) {
                if (!isActive) {
                    stringBuffer.append("//");
                }
                stringBuffer.append("// ");
                stringBuffer.append(referenceName);
                stringBuffer.append(this.TEXT_150);
            }
            if (!isActive) {
                stringBuffer.append("// ");
            }
            stringBuffer.append("new ");
            stringBuffer.append(testSuiteName);
            stringBuffer.append("(");
            stringBuffer.append(autName);
            stringBuffer.append(this.TEXT_154);
            if (!isActive) {
                stringBuffer.append("// ");
            }
            stringBuffer.append(autName);
            stringBuffer.append(this.TEXT_156);
        }
        stringBuffer.append(this.TEXT_157);
        if (definesLocalEventHandling) {
            stringBuffer.append(this.TEXT_158);
        }
        if (node instanceof ISpecTestCasePO) {
            stringBuffer.append(this.TEXT_159);
            ISpecTestCasePO tc2 = (ISpecTestCasePO)node;
            HashMap<String, String> reentryPropertyToException = new HashMap<String, String>();
            reentryPropertyToException.put("TestErrorEvent.VerifyFailed", "CheckFailedException");
            reentryPropertyToException.put("TestErrorEvent.Action", "ActionException");
            reentryPropertyToException.put("TestErrorEvent.CompNotFound", "ComponentNotFoundException");
            reentryPropertyToException.put("TestErrorEvent.Config", "ConfigurationException");
            for (IEventExecTestCasePO eventTC : tc2.getAllEventEventExecTC()) {
                String eventType = eventTC.getEventType();
                String reentryProp = eventTC.getReentryProp().toString();
                String referenceName = eventTC.getRealName();
                boolean hasReferenceName = StringUtils.isNotBlank((String)referenceName);
                NodeInfo ehInfo = uuidToNodeInfoMap.get(eventTC.getSpecTestCase().getGuid());
                String eventHandlerName = classesToImport.contains(ehInfo) ? ehInfo.getClassName() : ehInfo.getFqName();
                eventTC.getReferencedDataCube();
                if (eventTC.getReentryProp().equals((Object)ReentryProperty.RETURN)) {
                    List<String> childCompIdentifierNames = Utils.determineCompIdentifierList(componentNamesBP, compNamesBP, (IExecTestCasePO)eventTC);
                    Iterator<String> childCompIdentifierNamesIterator = childCompIdentifierNames.iterator();
                    stringBuffer.append(this.TEXT_160);
                    stringBuffer.append((String)reentryPropertyToException.get(eventType));
                    stringBuffer.append(this.TEXT_161);
                    int rowCount = eventTC.getDataManager().getDataSetCount();
                    int row = 0;
                    do {
                        stringBuffer.append(this.TEXT_162);
                        stringBuffer.append(eventHandlerName);
                        stringBuffer.append("(rtc");
                        if (childCompIdentifierNamesIterator.hasNext()) {
                            stringBuffer.append(",");
                        }
                        while (childCompIdentifierNamesIterator.hasNext()) {
                            String childCompIdentifierName = childCompIdentifierNamesIterator.next();
                            stringBuffer.append(this.TEXT_165);
                            stringBuffer.append(childCompIdentifierName);
                            if (!childCompIdentifierNamesIterator.hasNext()) continue;
                            stringBuffer.append(",");
                        }
                        stringBuffer.append(this.TEXT_167);
                        childParamIterator = eventTC.getParameterListIter();
                        while (childParamIterator.hasNext()) {
                            IParamDescriptionPO param = (IParamDescriptionPO)childParamIterator.next();
                            String paramValue = ParamUtils.getValueForParam((IParameterInterfacePO)eventTC, param, row, locale);
                            stringBuffer.append(this.TEXT_168);
                            stringBuffer.append(paramValue);
                            stringBuffer.append(this.TEXT_169);
                            if (!childParamIterator.hasNext()) continue;
                            stringBuffer.append("//,");
                        }
                        stringBuffer.append(this.TEXT_171);
                    } while (++row < rowCount);
                    stringBuffer.append(this.TEXT_172);
                    continue;
                }
                if (eventTC.getReentryProp().equals((Object)ReentryProperty.CONTINUE)) continue;
                stringBuffer.append(this.TEXT_173);
                stringBuffer.append(eventType);
                stringBuffer.append(this.TEXT_174);
                stringBuffer.append(reentryProp);
                stringBuffer.append(this.TEXT_175);
                if (hasReferenceName) {
                    stringBuffer.append(referenceName);
                }
                int rowCount = eventTC.getDataManager().getDataSetCount();
                int row = 0;
                do {
                    stringBuffer.append(this.TEXT_176);
                    stringBuffer.append(eventHandlerName);
                    stringBuffer.append("(rtc).execute(");
                    childParamIterator = eventTC.getParameterListIter();
                    while (childParamIterator.hasNext()) {
                        IParamDescriptionPO param = (IParamDescriptionPO)childParamIterator.next();
                        String paramValue = ParamUtils.getValueForParam((IParameterInterfacePO)eventTC, param, row, locale);
                        stringBuffer.append(this.TEXT_178);
                        stringBuffer.append(paramValue);
                        if (!childParamIterator.hasNext()) continue;
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(this.TEXT_180);
                } while (++row < rowCount);
            }
        }
        stringBuffer.append(this.TEXT_181);
        if (definesLocalEventHandling) {
            stringBuffer.append(this.TEXT_182);
            stringBuffer.append(definesLocalCheckFailedHandling);
            stringBuffer.append(", ");
            stringBuffer.append(definesLocalActionErrorHandling);
            stringBuffer.append(", ");
            stringBuffer.append(definesLocalCompNotFoundHandling);
            stringBuffer.append(", ");
            stringBuffer.append(definesLocalConfigurationErrorHandling);
            stringBuffer.append(this.TEXT_186);
        }
        stringBuffer.append(this.TEXT_187);
        return stringBuffer.toString();
    }
}

