/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.controllers.dnd;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.ui.rcp.controllers.MultipleTCBTracker;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.TCEditorDndSupport;
import org.eclipse.jubula.client.ui.rcp.editors.AbstractTestCaseEditor;
import org.eclipse.jubula.client.ui.rcp.views.TestCaseBrowser;

public class TSEditorDndSupport {
    private TSEditorDndSupport() {
    }

    public static boolean performDrop(AbstractTestCaseEditor targetEditor, IStructuredSelection toDrop, INodePO dropTarget, int dropPosition) {
        return TCEditorDndSupport.performDrop(targetEditor, toDrop, dropTarget, dropPosition);
    }

    public static boolean validateDrop(Viewer sourceViewer, Viewer targetViewer, IStructuredSelection selection, Object target, boolean allowFromBrowser) {
        if (selection == null || target == null) {
            return false;
        }
        if (sourceViewer != null && !sourceViewer.equals(targetViewer)) {
            boolean foundOne = false;
            for (TestCaseBrowser tcb : MultipleTCBTracker.getInstance().getOpenTCBs()) {
                if (!sourceViewer.equals(tcb.getTreeViewer())) continue;
                foundOne = true;
            }
            if (!allowFromBrowser || !foundOne) {
                return false;
            }
        }
        for (Object transferObj : selection) {
            if (!(transferObj instanceof INodePO)) {
                return false;
            }
            INodePO transferGUI = (INodePO)transferObj;
            if (transferGUI instanceof IExecTestCasePO && sourceViewer == targetViewer || transferGUI instanceof ISpecTestCasePO) continue;
            return false;
        }
        return true;
    }
}

