/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.events;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jubula.client.ui.rcp.editors.IJBEditor;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuiEventDispatcher {
    private static final Logger LOG = LoggerFactory.getLogger(GuiEventDispatcher.class);
    private static GuiEventDispatcher instance = null;
    private Set<IEditorDirtyStateListener> m_editorDirtyStateListeners = new HashSet<IEditorDirtyStateListener>();
    private Set<IEditorDirtyStateListener> m_editorDirtyStateListenersPost = new HashSet<IEditorDirtyStateListener>();

    private GuiEventDispatcher() {
    }

    public static synchronized GuiEventDispatcher getInstance() {
        if (instance == null) {
            instance = new GuiEventDispatcher();
        }
        return instance;
    }

    public void addEditorDirtyStateListener(IEditorDirtyStateListener l, boolean guiMode) {
        if (guiMode) {
            this.m_editorDirtyStateListenersPost.add(l);
        } else {
            this.m_editorDirtyStateListeners.add(l);
        }
    }

    public void removeEditorDirtyStateListener(IEditorDirtyStateListener l) {
        this.m_editorDirtyStateListeners.remove(l);
        this.m_editorDirtyStateListenersPost.remove(l);
    }

    public void fireEditorDirtyStateListener(IJBEditor editor, boolean isDirty) {
        HashSet<IEditorDirtyStateListener> stableListeners = new HashSet<IEditorDirtyStateListener>(this.m_editorDirtyStateListeners);
        for (IEditorDirtyStateListener l : stableListeners) {
            try {
                l.handleEditorDirtyStateChanged(editor, isDirty);
            }
            catch (Throwable t) {
                LOG.error(Messages.UnhandledExceptionCallingListeners, t);
            }
        }
        HashSet<IEditorDirtyStateListener> stableListenersPost = new HashSet<IEditorDirtyStateListener>(this.m_editorDirtyStateListenersPost);
        for (IEditorDirtyStateListener l : stableListenersPost) {
            try {
                l.handleEditorDirtyStateChanged(editor, isDirty);
            }
            catch (Throwable t) {
                LOG.error(Messages.UnhandledExceptionCallingListeners, t);
            }
        }
    }

    public static interface IEditorDirtyStateListener {
        public void handleEditorDirtyStateChanged(IJBEditor var1, boolean var2);
    }
}

