/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jubula.client.core.businessprocess.db.TestSuiteBP;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.utils.Languages;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.businessprocess.WorkingLanguageBP;
import org.eclipse.jubula.client.ui.rcp.utils.Utils;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;

public class ChooseLanguageHandler
extends AbstractHandler
implements IElementUpdater {
    public static final String LANGUAGE = "org.eclipse.jubula.client.ui.rcp.commands.ChooseLanguageCommand.parameter.language";

    public Object execute(ExecutionEvent event) {
        Locale defaultLanguage;
        IProjectPO project;
        Map map = event.getParameters();
        String lang = (String)map.get(LANGUAGE);
        Locale loc = Languages.getInstance().getLocale(lang);
        if (loc == null && (project = GeneralStorage.getInstance().getProject()) != null && (defaultLanguage = project.getDefaultLanguage()) != null) {
            loc = defaultLanguage;
        }
        if (loc != null && loc.equals(WorkingLanguageBP.getInstance().getWorkingLanguage())) {
            return null;
        }
        if (this.showUnsavedTestSuiteEditors(loc)) {
            WorkingLanguageBP.getInstance().setCurrentLanguage(loc);
            DataEventDispatcher.getInstance().fireLanguageChanged(loc);
        }
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        String lang = (String)parameters.get(LANGUAGE);
        if (lang != null && lang.equals(WorkingLanguageBP.getInstance().getWorkingLanguage().getDisplayName())) {
            element.setChecked(true);
        } else {
            element.setChecked(false);
        }
    }

    private boolean showUnsavedTestSuiteEditors(Locale lang) {
        String editorNames;
        IProjectPO project = GeneralStorage.getInstance().getProject();
        ArrayList<String> editorsToSave = new ArrayList<String>();
        ArrayList<String> editorsToClose = new ArrayList<String>();
        String preLine = " - ";
        for (ITestSuitePO testSuite : TestSuiteBP.getListOfTestSuites((IProjectPO)project)) {
            IEditorPart editor = Utils.getEditorByPO((IPersistentObject)testSuite);
            if (testSuite.getAut() != null && !WorkingLanguageBP.getInstance().isTestSuiteLanguage(lang, testSuite) && editor != null && !editor.isDirty()) {
                editorsToClose.add(editor.getTitle());
            }
            if (editor == null || !editor.isDirty()) continue;
            editorsToSave.add(editor.getTitle());
        }
        if (editorsToSave.isEmpty()) {
            if (editorsToClose.isEmpty()) {
                return true;
            }
            editorNames = "";
            for (String name : editorsToClose) {
                editorNames = String.valueOf(editorNames) + preLine + name + "\n";
            }
            ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.I_EDITORS_TO_CLOSE, (Object[])new Object[]{editorNames}, null);
            for (String name : editorsToClose) {
                IEditorPart editor = Plugin.getEditorByTitle(name);
                Plugin.getActivePage().closeEditor(editor, false);
            }
            return true;
        }
        if (!editorsToSave.isEmpty()) {
            editorNames = "";
            for (String name : editorsToSave) {
                editorNames = String.valueOf(editorNames) + preLine + name + "\n";
            }
            ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.I_EDITORS_TO_SAVE, (Object[])new Object[]{editorNames}, null);
            return false;
        }
        return true;
    }
}

