/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jubula.client.core.businessprocess.db.TestSuiteBP;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.ProjectPM;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.dialogs.InputDialog;
import org.eclipse.jubula.client.ui.rcp.handlers.AbstractNewHandler;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.tools.internal.exception.ProjectDeletedException;
import org.eclipse.swt.widgets.Control;

public class NewTestSuiteHandler
extends AbstractNewHandler {
    public Object executeImpl(ExecutionEvent event) {
        this.newTestSuite(event);
        return null;
    }

    public void newTestSuite(ExecutionEvent event) {
        INodePO finalTSParent = this.getParentNode(event);
        InputDialog dialog = this.newTestSuitePopUp();
        if (dialog.getReturnCode() == 1) {
            return;
        }
        try {
            ITestSuitePO testSuite = NodeMaker.createTestSuitePO((String)dialog.getName());
            this.setDefaultValuesToTestSuite(testSuite);
            NodePM.addAndPersistChildNode((INodePO)finalTSParent, (INodePO)testSuite, null);
            DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)testSuite, DataEventDispatcher.DataState.Added, DataEventDispatcher.UpdateState.all);
        }
        catch (PMException e) {
            PMExceptionHandler.handlePMExceptionForMasterSession(e);
        }
        catch (ProjectDeletedException projectDeletedException) {
            PMExceptionHandler.handleProjectDeletedException();
        }
    }

    private void setDefaultValuesToTestSuite(ITestSuitePO testSuite) {
        IProjectPO project = GeneralStorage.getInstance().getProject();
        int autListSize = project.getAutMainList().size();
        if (autListSize == 0 || autListSize > 1) {
            return;
        }
        IAUTMainPO aut = (IAUTMainPO)project.getAutMainList().toArray()[0];
        testSuite.setAut(aut);
        int autConfigListLength = aut.getAutConfigSet().size();
        if (autConfigListLength == 0 || autConfigListLength > 1) {
            return;
        }
    }

    private InputDialog newTestSuitePopUp() {
        final IProjectPO project = GeneralStorage.getInstance().getProject();
        int testSuiteCount = TestSuiteBP.getListOfTestSuites((IProjectPO)project).size();
        String str = "";
        if (testSuiteCount > 0) {
            str = String.valueOf(str) + testSuiteCount;
        }
        str = "New Test Suite" + str;
        InputDialog dialog = new InputDialog(this.getActiveShell(), Messages.NewTestSuiteActionTSTitle, str, Messages.NewTestSuiteActionTSMessage, Messages.NewTestSuiteActionTSLabel, Messages.NewTestSuiteActionTSError, Messages.NewTestSuiteActionDoubleTSName, "newTestSuiteDialog.gif", Messages.NewTestSuiteActionTSShell, false){

            @Override
            protected boolean isInputAllowed() {
                String newName = this.getInputFieldText();
                return !ProjectPM.doesTestSuiteExists((Long)project.getId(), (String)newName);
            }
        };
        dialog.setHelpAvailable(true);
        dialog.create();
        DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
        Plugin.getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.jubula.client.ua.help.dialogTestsuiteNewContextId");
        dialog.open();
        return dialog;
    }
}

