/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.commands;

import java.awt.Color;
import java.awt.Point;
import java.awt.image.BufferedImage;
import org.eclipse.jubula.communication.internal.ICommand;
import org.eclipse.jubula.communication.internal.message.Message;
import org.eclipse.jubula.communication.internal.message.TakeScreenshotMessage;
import org.eclipse.jubula.communication.internal.message.TakeScreenshotResponseMessage;
import org.eclipse.jubula.rc.common.AUTServer;
import org.eclipse.jubula.rc.common.driver.IRobot;
import org.eclipse.jubula.tools.internal.serialisation.SerializedImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TakeScreenshotCommand
implements ICommand {
    private static final int TOTAL_LINE_LENGTH = 11;
    private static final int LINE_LENGTH_PER_DIRECTION = 5;
    private static final Logger LOG = LoggerFactory.getLogger(TakeScreenshotCommand.class);
    private TakeScreenshotMessage m_message;

    public Message execute() {
        TakeScreenshotResponseMessage response = new TakeScreenshotResponseMessage();
        IRobot robot = AUTServer.getInstance().getRobot();
        BufferedImage createScreenCapture = robot.createFullScreenCapture();
        Point currentPointingDevicePosition = robot.getCurrentMousePosition();
        if (currentPointingDevicePosition != null) {
            int pdX = currentPointingDevicePosition.x;
            int pdY = currentPointingDevicePosition.y;
            int xStart = pdX - 5;
            int yStart = pdY - 5;
            int i = 0;
            while (i < 11) {
                int j = 0;
                while (j < 11) {
                    this.invertPixelAtPoint(createScreenCapture, xStart + i, yStart + j);
                    ++j;
                }
                ++i;
            }
        }
        SerializedImage computedSerializeImage = SerializedImage.computeSerializeImage((BufferedImage)createScreenCapture);
        response.setScreenshot(computedSerializeImage);
        return response;
    }

    private void invertPixelAtPoint(BufferedImage image, int x, int y) {
        if (x < 0 || y < 0) {
            return;
        }
        if (x >= image.getWidth() || y >= image.getHeight()) {
            return;
        }
        int rgb = image.getRGB(x, y);
        Color origPxColor = new Color(rgb);
        Color newPxColor = new Color(255 - origPxColor.getRed(), 255 - origPxColor.getGreen(), 255 - origPxColor.getBlue());
        image.setRGB(x, y, newPxColor.getRGB());
    }

    public void timeout() {
        LOG.error(String.valueOf(this.getClass().getName()) + ".timeout() called");
    }

    public void setMessage(Message message) {
        this.m_message = (TakeScreenshotMessage)message;
    }

    public Message getMessage() {
        return this.m_message;
    }
}

