/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.tester;

import java.awt.Rectangle;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.DragAndDropHelper;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.table.Cell;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.common.tester.AbstractTextInputSupportTester;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.ITableComponent;
import org.eclipse.jubula.rc.common.util.IndexConverter;
import org.eclipse.jubula.rc.common.util.MatchUtil;
import org.eclipse.jubula.rc.common.util.Verifier;
import org.eclipse.jubula.toolkit.enums.ValueSets;
import org.eclipse.jubula.tools.internal.objects.event.EventFactory;

public abstract class AbstractTableTester
extends AbstractTextInputSupportTester {
    private static AutServerLogger log = new AutServerLogger(AbstractTableTester.class);

    public static AutServerLogger getLog() {
        return log;
    }

    private Object getRealTable() {
        return this.getComponent().getRealComponent();
    }

    private ITableComponent getTableAdapter() {
        return (ITableComponent)this.getComponent();
    }

    public void rcVerifyText(String text) throws StepExecutionException {
        this.rcVerifyText(text, MatchUtil.DEFAULT_OPERATOR);
    }

    public void rcVerifyText(String text, String operator) throws StepExecutionException {
        ITableComponent adapter = this.getTableAdapter();
        Cell cell = adapter.getSelectedCell();
        int implRow = cell.getRow();
        int implCol = cell.getCol();
        this.checkRowColBounds(implRow, implCol);
        adapter.scrollCellToVisible(implRow, implCol);
        String current = this.getCellText(implRow, implCol);
        Verifier.match(current, text, operator);
    }

    public void rcVerifyText(String text, String operator, String row, String rowOperator, String col, String colOperator) throws StepExecutionException {
        String current;
        ITableComponent adapter = this.getTableAdapter();
        int implRow = adapter.getRowFromString(row, rowOperator);
        int implCol = adapter.getColumnFromString(col, colOperator);
        if (implRow == -1 && implCol > -1) {
            current = adapter.getColumnHeaderText(implCol);
        } else {
            this.checkRowColBounds(implRow, implCol);
            adapter.scrollCellToVisible(implRow, implCol);
            current = this.getCellText(implRow, implCol);
        }
        Verifier.match(current, text, operator);
    }

    public void rcSelectCell(String row, String rowOperator, String col, String colOperator, int clickCount, int xPos, String xUnits, int yPos, String yUnits, String extendSelection, int button) throws StepExecutionException {
        Rectangle cellBounds;
        ITableComponent adapter = this.getTableAdapter();
        int implRow = adapter.getRowFromString(row, rowOperator);
        int implCol = adapter.getColumnFromString(col, colOperator);
        boolean isExtendSelection = extendSelection.equals(ValueSets.BinaryChoice.yes.rcValue());
        if (log.isDebugEnabled()) {
            log.debug("Selecting row, col: " + row + ", " + col);
        }
        Object source = this.getRealTable();
        if (implRow == -1 && implCol > -1) {
            cellBounds = adapter.getHeaderBounds(implCol);
            source = adapter.getTableHeader();
        } else {
            cellBounds = adapter.scrollCellToVisible(implRow, implCol);
        }
        Object o = this.getSpecificRectangle(cellBounds);
        ClickOptions clickOptions = ClickOptions.create();
        clickOptions.setClickCount(clickCount).setScrollToVisible(false);
        clickOptions.setMouseButton(button);
        try {
            if (isExtendSelection) {
                this.getRobot().keyPress(this.getRealTable(), this.getExtendSelectionModifier());
            }
            this.getRobot().click(source, o, clickOptions, xPos, xUnits.equalsIgnoreCase(ValueSets.Unit.pixel.rcValue()), yPos, yUnits.equalsIgnoreCase(ValueSets.Unit.pixel.rcValue()));
        }
        finally {
            if (isExtendSelection) {
                this.getRobot().keyRelease(this.getRealTable(), this.getExtendSelectionModifier());
            }
        }
    }

    protected Object getSpecificRectangle(Rectangle rectangle) {
        return rectangle;
    }

    public void rcVerifyValueInColumn(String col, String colOperator, String value, String operator, String searchType, boolean exists) throws StepExecutionException {
        ITableComponent adapter = this.getTableAdapter();
        int implCol = adapter.getColumnFromString(col, colOperator);
        boolean valueExists = this.isValueExisting(adapter, implCol, value, operator, searchType);
        Verifier.equals(exists, valueExists);
    }

    private boolean isValueExisting(ITableComponent adapter, int implCol, String value, String operator, String searchType) {
        int rowCount = adapter.getRowCount();
        int i = this.getStartingRowIndex(searchType);
        while (i < rowCount) {
            if (MatchUtil.getInstance().match(this.getCellText(i, implCol), value, operator)) {
                return true;
            }
            ++i;
        }
        if (adapter.isHeaderVisible()) {
            String header = adapter.getColumnHeaderText(implCol);
            if (MatchUtil.getInstance().match(header, value, operator)) {
                return true;
            }
        }
        return false;
    }

    public void rcVerifyValueInRow(String row, String rowOperator, String value, String operator, String searchType, boolean exists) throws StepExecutionException {
        ITableComponent adapter = this.getTableAdapter();
        int implRow = adapter.getRowFromString(row, rowOperator);
        boolean valueIsExisting = false;
        if (implRow == -1) {
            int k = this.getStartingColIndex(searchType);
            while (k < adapter.getColumnCount()) {
                if (MatchUtil.getInstance().match(adapter.getColumnHeaderText(k), value, operator)) {
                    valueIsExisting = true;
                    break;
                }
                ++k;
            }
        } else {
            int columnCount = adapter.getColumnCount();
            if (columnCount > 0) {
                int i = this.getStartingColIndex(searchType);
                while (i < columnCount) {
                    if (MatchUtil.getInstance().match(this.getCellText(implRow, i), value, operator)) {
                        valueIsExisting = true;
                        break;
                    }
                    ++i;
                }
            } else if (MatchUtil.getInstance().match(adapter.getRowText(implRow), value, operator)) {
                valueIsExisting = true;
            }
        }
        Verifier.equals(exists, valueIsExisting);
    }

    public void rcVerifyEditable(boolean editable, String row, String rowOperator, String col, String colOperator) {
        if (this.getTableAdapter().getRowFromString(row, rowOperator) == -1) {
            throw new StepExecutionException("Unsupported Header Action", EventFactory.createActionError((String)"TestErrorEvent.UnsupportedHeaderAction"));
        }
        this.selectCell(row, rowOperator, col, colOperator, ClickOptions.create(), ValueSets.BinaryChoice.no.rcValue());
        this.rcVerifyEditable(editable);
    }

    private void selectCell(String row, String rowOperator, String col, String colOperator, ClickOptions co, String extendSelection) {
        this.rcSelectCell(row, rowOperator, col, colOperator, co.getClickCount(), 50, ValueSets.Unit.percent.rcValue(), 50, ValueSets.Unit.percent.rcValue(), extendSelection, co.getMouseButton());
    }

    public void rcVerifyTextAtMousePosition(String text, String operator) throws StepExecutionException {
        if (this.isMouseOnHeader()) {
            throw new StepExecutionException("Unsupported Header Action", EventFactory.createActionError((String)"TestErrorEvent.UnsupportedHeaderAction"));
        }
        Cell cell = this.getCellAtMousePosition();
        this.rcVerifyText(text, operator, Integer.toString(IndexConverter.toUserIndex(cell.getRow())), MatchUtil.EQUALS, Integer.toString(IndexConverter.toUserIndex(cell.getCol())), MatchUtil.EQUALS);
    }

    public void rcVerifyEditableSelected(boolean editable) {
        this.rcVerifyEditable(editable);
    }

    public void rcVerifyEditable(boolean editable) {
        Cell cell = this.getTableAdapter().getSelectedCell();
        Verifier.equals(editable, this.getTableAdapter().isCellEditable(cell.getRow(), cell.getCol()));
    }

    public void rcVerifyEditableMousePosition(boolean editable) {
        if (this.isMouseOnHeader()) {
            throw new StepExecutionException("Unsupported Header Action", EventFactory.createActionError((String)"TestErrorEvent.UnsupportedHeaderAction"));
        }
        Cell cell = this.getCellAtMousePosition();
        boolean isEditable = this.getTableAdapter().isCellEditable(cell.getRow(), cell.getCol());
        Verifier.equals(editable, isEditable);
    }

    public void rcSelectRowByValue(String col, String colOperator, String value, String regexOp, int clickCount, String extendSelection, String searchType, int button) {
        this.selectRowByValue(col, colOperator, value, regexOp, extendSelection, searchType, ClickOptions.create().setClickCount(clickCount).setMouseButton(button));
    }

    protected void selectRowByValue(String col, String colOperator, String value, String regexOp, String extendSelection, String searchType, ClickOptions co) {
        ITableComponent adapter = this.getTableAdapter();
        int implCol = adapter.getColumnFromString(col, colOperator);
        Integer implRow = null;
        int rowCount = adapter.getRowCount();
        int i = this.getStartingRowIndex(searchType);
        while (i < rowCount) {
            if (MatchUtil.getInstance().match(this.getCellText(i, implCol), value, regexOp)) {
                implRow = new Integer(i);
                break;
            }
            ++i;
        }
        if (implRow == null) {
            String header = adapter.getColumnHeaderText(implCol);
            if (MatchUtil.getInstance().match(header, value, regexOp)) {
                implRow = new Integer(-1);
            }
        }
        if (implRow == null) {
            throw new StepExecutionException("no such row found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
        String userIdxRow = new Integer(IndexConverter.toUserIndex(implRow)).toString();
        String userIdxCol = new Integer(IndexConverter.toUserIndex(implCol)).toString();
        this.selectCell(userIdxRow, MatchUtil.EQUALS, userIdxCol, colOperator, co, extendSelection);
    }

    public void rcSelectCellByColValue(String row, String rowOperator, String value, String regex, int clickCount, String extendSelection, String searchType, int button) {
        this.selectCellByColValue(row, rowOperator, value, regex, extendSelection, searchType, ClickOptions.create().setClickCount(clickCount).setMouseButton(button));
    }

    protected void selectCellByColValue(String row, String rowOperator, String value, String regex, String extendSelection, String searchType, ClickOptions co) {
        int i;
        ITableComponent adapter = this.getTableAdapter();
        int implRow = adapter.getRowFromString(row, rowOperator);
        int colCount = adapter.getColumnCount();
        Integer implCol = null;
        if (implRow == -1) {
            i = this.getStartingColIndex(searchType);
            while (i < colCount) {
                if (MatchUtil.getInstance().match(adapter.getColumnHeaderText(i), value, regex)) {
                    implCol = new Integer(i);
                    break;
                }
                ++i;
            }
        } else {
            i = this.getStartingColIndex(searchType);
            while (i < colCount) {
                if (MatchUtil.getInstance().match(this.getCellText(implRow, i), value, regex)) {
                    implCol = new Integer(i);
                    break;
                }
                ++i;
            }
        }
        if (implCol == null) {
            throw new StepExecutionException("no such cell found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
        String usrIdxRowStr = new Integer(IndexConverter.toUserIndex(implRow)).toString();
        String usrIdxColStr = new Integer(IndexConverter.toUserIndex(implCol)).toString();
        this.selectCell(usrIdxRowStr, rowOperator, usrIdxColStr, MatchUtil.EQUALS, co, extendSelection);
    }

    public String rcReadValue(String variable, String row, String rowOperator, String col, String colOperator) {
        ITableComponent adapter = this.getTableAdapter();
        int implRow = adapter.getRowFromString(row, rowOperator);
        int implCol = adapter.getColumnFromString(col, colOperator);
        if (implRow == -1 && implCol > -1) {
            return adapter.getColumnHeaderText(implCol);
        }
        this.checkRowColBounds(implRow, implCol);
        adapter.scrollCellToVisible(implRow, implCol);
        return this.getCellText(implRow, implCol);
    }

    public String rcReadValueAtMousePosition(String variable) {
        Cell cellAtMousePosition = this.getCellAtMousePosition();
        return this.getCellText(cellAtMousePosition.getRow(), cellAtMousePosition.getCol());
    }

    public void rcClick(int count, int button) {
        ITableComponent adapter = this.getTableAdapter();
        Cell cell = null;
        if (this.isMouseOverCell()) {
            cell = this.getCellAtMousePosition();
        } else if (adapter.hasCellSelection()) {
            cell = adapter.getSelectedCell();
        }
        if (cell != null) {
            Rectangle cellRect = adapter.scrollCellToVisible(cell.getRow(), cell.getCol());
            Object robotSpecifcRectangle = this.getSpecificRectangle(cellRect);
            this.getRobot().click(this.getRealTable(), robotSpecifcRectangle, ClickOptions.create().setClickCount(count).setMouseButton(button));
        } else {
            super.rcClick(count, button);
        }
    }

    public void rcMove(String direction, int cellCount, int clickCount, int xPos, String xUnits, int yPos, String yUnits, String extendSelection) throws StepExecutionException {
        if (this.isMouseOnHeader()) {
            throw new StepExecutionException("Unsupported Header Action", EventFactory.createActionError((String)"TestErrorEvent.UnsupportedHeaderAction"));
        }
        Cell currCell = null;
        try {
            currCell = this.getCellAtMousePosition();
        }
        catch (StepExecutionException stepExecutionException) {
            currCell = this.getTableAdapter().getSelectedCell();
        }
        int newCol = currCell.getCol();
        int newRow = currCell.getRow();
        if (ValueSets.Direction.up.rcValue().equalsIgnoreCase(direction)) {
            newRow -= cellCount;
        } else if (ValueSets.Direction.down.rcValue().equalsIgnoreCase(direction)) {
            newRow += cellCount;
        } else if (ValueSets.Direction.left.rcValue().equalsIgnoreCase(direction)) {
            newCol -= cellCount;
        } else if (ValueSets.Direction.right.rcValue().equalsIgnoreCase(direction)) {
            newCol += cellCount;
        }
        newRow = IndexConverter.toUserIndex(newRow);
        newCol = IndexConverter.toUserIndex(newCol);
        String row = Integer.toString(newRow);
        String col = Integer.toString(newCol);
        this.rcSelectCell(row, MatchUtil.DEFAULT_OPERATOR, col, MatchUtil.DEFAULT_OPERATOR, clickCount, xPos, xUnits, yPos, yUnits, extendSelection, ValueSets.InteractionMode.primary.rcIntValue());
    }

    public void rcInputText(String text) throws StepExecutionException {
        this.inputText(text, false);
    }

    public void rcInputText(String text, String row, String rowOperator, String col, String colOperator) throws StepExecutionException {
        if (this.getTableAdapter().getRowFromString(row, rowOperator) == -1) {
            throw new StepExecutionException("Unsupported Header Action", EventFactory.createActionError((String)"TestErrorEvent.UnsupportedHeaderAction"));
        }
        this.selectCell(row, rowOperator, col, colOperator, ClickOptions.create().setClickCount(1), ValueSets.BinaryChoice.no.rcValue());
        this.rcInputText(text);
    }

    public void rcReplaceText(String text) throws StepExecutionException {
        this.inputText(text, true);
    }

    public void rcReplaceText(String text, String row, String rowOperator, String col, String colOperator) {
        if (this.getTableAdapter().getRowFromString(row, rowOperator) == -1) {
            throw new StepExecutionException("Unsupported Header Action", EventFactory.createActionError((String)"TestErrorEvent.UnsupportedHeaderAction"));
        }
        this.selectCell(row, rowOperator, col, colOperator, ClickOptions.create().setClickCount(1), ValueSets.BinaryChoice.no.rcValue());
        this.inputText(text, true);
    }

    public void rcDragCell(int mouseButton, String modifier, String row, String rowOperator, String col, String colOperator, int xPos, String xUnits, int yPos, String yUnits) throws StepExecutionException {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        dndHelper.setModifier(modifier);
        dndHelper.setMouseButton(mouseButton);
        dndHelper.setDragComponent(null);
        this.rcSelectCell(row, rowOperator, col, colOperator, 0, xPos, xUnits, yPos, yUnits, ValueSets.BinaryChoice.no.rcValue(), 1);
        this.pressOrReleaseModifiers(modifier, true);
        this.getRobot().mousePress(null, null, mouseButton);
    }

    public void rcDropCell(String row, String rowOperator, String col, String colOperator, int xPos, String xUnits, int yPos, String yUnits, int delayBeforeDrop) throws StepExecutionException {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        try {
            this.rcSelectCell(row, rowOperator, col, colOperator, 0, xPos, xUnits, yPos, yUnits, ValueSets.BinaryChoice.no.rcValue(), 1);
            AbstractTableTester.waitBeforeDrop(delayBeforeDrop);
        }
        finally {
            this.getRobot().mouseRelease(null, null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
        }
    }

    public void rcDragRowByValue(int mouseButton, String modifier, String col, String colOperator, String value, String regexOp, String searchType) {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        dndHelper.setModifier(modifier);
        dndHelper.setMouseButton(mouseButton);
        this.rcSelectRowByValue(col, colOperator, value, regexOp, 1, ValueSets.BinaryChoice.no.rcValue(), searchType, 1);
        this.pressOrReleaseModifiers(modifier, true);
        this.getRobot().mousePress(null, null, mouseButton);
    }

    public void rcDropRowByValue(String col, String colOperator, String value, String regexOp, String searchType, int delayBeforeDrop) {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        try {
            this.selectRowByValue(col, colOperator, value, regexOp, ValueSets.BinaryChoice.no.rcValue(), searchType, ClickOptions.create().setClickCount(0));
            AbstractTableTester.waitBeforeDrop(delayBeforeDrop);
        }
        finally {
            this.getRobot().mouseRelease(null, null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
        }
    }

    public void rcDragCellByColValue(int mouseButton, String modifier, String row, String rowOperator, String value, String regex, String searchType) {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        dndHelper.setModifier(modifier);
        dndHelper.setMouseButton(mouseButton);
        this.selectCellByColValue(row, rowOperator, value, regex, ValueSets.BinaryChoice.no.rcValue(), searchType, ClickOptions.create().setClickCount(0));
        this.pressOrReleaseModifiers(modifier, true);
        this.getRobot().mousePress(null, null, mouseButton);
    }

    public void rcDropCellByColValue(String row, String rowOperator, String value, String regex, String searchType, int delayBeforeDrop) {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        try {
            this.selectCellByColValue(row, rowOperator, value, regex, ValueSets.BinaryChoice.no.rcValue(), searchType, ClickOptions.create().setClickCount(0));
            AbstractTableTester.waitBeforeDrop(delayBeforeDrop);
        }
        finally {
            this.getRobot().mouseRelease(null, null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
        }
    }

    private String getCellText(int row, int column) {
        return this.getTableAdapter().getCellText(row, column);
    }

    private void checkBounds(int value, int count) {
        if (value < 0 || value >= count) {
            throw new StepExecutionException("Invalid row/column: " + value, EventFactory.createActionError((String)"TestErrorEvent.InvalidIndexOrHeader"));
        }
    }

    protected void checkRowColBounds(int row, int column) throws StepExecutionException {
        ITableComponent adapter = this.getTableAdapter();
        this.checkBounds(row, adapter.getRowCount());
        int colCount = adapter.getColumnCount();
        if (colCount > 0 || column > 0) {
            this.checkBounds(column, colCount);
        }
    }

    private int getStartingColIndex(String searchType) {
        int startingIndex = 0;
        if (searchType.equalsIgnoreCase(ValueSets.SearchType.relative.rcValue())) {
            startingIndex = this.getTableAdapter().getSelectedCell().getCol() + 1;
        }
        return startingIndex;
    }

    private int getStartingRowIndex(String searchType) {
        int startingIndex = 0;
        if (searchType.equalsIgnoreCase(ValueSets.SearchType.relative.rcValue())) {
            startingIndex = this.getTableAdapter().getSelectedCell().getRow() + 1;
        }
        return startingIndex;
    }

    private void inputText(String text, boolean replace) throws StepExecutionException {
        ITableComponent adapter = this.getTableAdapter();
        Cell cell = adapter.getSelectedCell();
        Rectangle rectangle = adapter.scrollCellToVisible(cell.getRow(), cell.getCol());
        Object editor = this.activateEditor(cell, rectangle);
        editor = this.setEditorToReplaceMode(editor, replace);
        this.getRobot().type(editor, text);
    }

    private boolean isMouseOverCell() {
        try {
            this.getCellAtMousePosition();
        }
        catch (StepExecutionException stepExecutionException) {
            return false;
        }
        return true;
    }

    protected abstract Object setEditorToReplaceMode(Object var1, boolean var2);

    protected abstract Object activateEditor(Cell var1, Rectangle var2);

    protected abstract int getExtendSelectionModifier();

    protected abstract Cell getCellAtMousePosition() throws StepExecutionException;

    protected abstract Object getNodeAtMousePosition() throws StepExecutionException;

    protected abstract boolean isMouseOnHeader();

    public void rcCheckPropertyAtMousePosition(String name, String value, String operator) {
        Object cell = this.getNodeAtMousePosition();
        ITableComponent bean = this.getTableAdapter();
        String propToStr = bean.getPropertyValueOfCell(name, cell);
        Verifier.match(propToStr, value, operator);
    }
}

