/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.javafx.listener.sync;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.stage.Stage;
import org.eclipse.jubula.rc.javafx.driver.EventThreadQueuerJavaFXImpl;
import org.eclipse.jubula.rc.javafx.listener.sync.IStageResizeSync;
import org.eclipse.jubula.rc.javafx.util.concurrent.JBExecutors;

class StageResizeTimeoutSync
implements IStageResizeSync {
    private final ReentrantLock m_lock = new ReentrantLock();
    private final ScheduledExecutorService m_executor = JBExecutors.newSingleDaemonThreadScheduledExecutor(StageResizeTimeoutSync.class.getSimpleName());
    private Locker m_locker = new Locker();

    StageResizeTimeoutSync() {
    }

    @Override
    public void register(Stage stage) {
        stage.maximizedProperty().addListener((ChangeListener)this.m_locker);
        this.m_locker.lock();
    }

    @Override
    public void deregister(Stage stage) {
        stage.maximizedProperty().removeListener((ChangeListener)this.m_locker);
    }

    @Override
    public void await() {
        EventThreadQueuerJavaFXImpl.checkNotEventThread();
        EventThreadQueuerJavaFXImpl.waitForIdle();
        this.m_lock.lock();
        this.m_lock.unlock();
    }

    private class Locker
    implements ChangeListener<Boolean> {
        private Unlocker m_unlocker;

        private Locker() {
            this.m_unlocker = new Unlocker();
        }

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            this.lock();
        }

        public void lock() {
            EventThreadQueuerJavaFXImpl.checkEventThread();
            StageResizeTimeoutSync.this.m_lock.lock();
            StageResizeTimeoutSync.this.m_executor.schedule(this.m_unlocker, 2000L, TimeUnit.MILLISECONDS);
        }
    }

    private class Unlocker
    implements Runnable {
        private Unlocker() {
        }

        @Override
        public void run() {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    StageResizeTimeoutSync.this.m_lock.unlock();
                }
            });
        }
    }
}

