/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.javafx.util;

import java.util.HashMap;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.paint.Color;
import org.eclipse.jubula.tools.internal.utils.EnvironmentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HighlightNode {
    private static Logger log = LoggerFactory.getLogger(HighlightNode.class);
    private static final String OBJECT_MAPPING_COLOR_VAR = "TEST_OBJECT_MAPPING_COLOR";
    private static Map<Node, Effect> oldEffects = new HashMap<Node, Effect>();
    private static Color shadowColor = Color.GREEN;

    static {
        try {
            String value = EnvironmentUtils.getProcessOrSystemProperty((String)OBJECT_MAPPING_COLOR_VAR);
            if (value != null) {
                shadowColor = Color.valueOf((String)value);
            }
        }
        catch (Exception e) {
            log.warn("Could not parse color for object mapping", (Throwable)e);
        }
    }

    private HighlightNode() {
    }

    public static void drawHighlight(Node n) {
        if (n.effectProperty().isBound()) {
            return;
        }
        if (n.getEffect() != null) {
            oldEffects.put(n, n.getEffect());
        }
        n.setEffect((Effect)new InnerShadow(10.0, shadowColor));
    }

    public static void removeHighlight(Node n) {
        if (n.effectProperty().isBound()) {
            return;
        }
        Effect oldEffect = oldEffects.remove(n);
        n.setEffect(oldEffect);
    }
}

