/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.javafx.util;

import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.Parent;

public class NodeTraverseHelper {
    private NodeTraverseHelper() {
    }

    private static <T> List<T> findInstancesOf(Parent parent, Class<T> type, List<T> r) {
        List<T> result = r;
        for (Node object : parent.getChildrenUnmodifiable()) {
            if (type.isAssignableFrom(object.getClass())) {
                result.add(object);
            }
            if (!(object instanceof Parent)) continue;
            result = NodeTraverseHelper.findInstancesOf((Parent)object, type, result);
        }
        return result;
    }

    public static <T> List<T> getInstancesOf(Parent parent, Class<T> type) {
        return NodeTraverseHelper.findInstancesOf(parent, type, new ArrayList());
    }

    public static boolean isChildOf(Node node, Parent parent) {
        boolean result = false;
        for (Node n : parent.getChildrenUnmodifiable()) {
            if (result) continue;
            if (n == node) {
                return true;
            }
            if (!(n instanceof Parent)) continue;
            result = NodeTraverseHelper.isChildOf(node, (Parent)n);
        }
        return result;
    }

    public static boolean isVisible(Node node) {
        if (node == null) {
            return false;
        }
        Node tmp = node;
        while (tmp != null) {
            if (!tmp.isVisible()) {
                return false;
            }
            tmp = tmp.getParent();
        }
        return true;
    }
}

