/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.rcp.e3.gef.tester;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.Validate;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IRobot;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.tester.WidgetTester;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.IComponent;
import org.eclipse.jubula.rc.common.util.Comparer;
import org.eclipse.jubula.rc.common.util.MatchUtil;
import org.eclipse.jubula.rc.common.util.MenuUtilBase;
import org.eclipse.jubula.rc.common.util.Verifier;
import org.eclipse.jubula.rc.rcp.e3.gef.factory.DefaultEditPartAdapterFactory;
import org.eclipse.jubula.rc.rcp.e3.gef.identifier.IDirectionalEditPartAnchorIdentifier;
import org.eclipse.jubula.rc.rcp.e3.gef.identifier.IEditPartIdentifier;
import org.eclipse.jubula.rc.rcp.e3.gef.util.FigureCanvasUtil;
import org.eclipse.jubula.rc.swt.driver.DragAndDropHelperSwt;
import org.eclipse.jubula.rc.swt.driver.RobotFactoryConfig;
import org.eclipse.jubula.rc.swt.tester.CAPUtil;
import org.eclipse.jubula.rc.swt.tester.adapter.ControlAdapter;
import org.eclipse.jubula.toolkit.enums.ValueSets;
import org.eclipse.jubula.tools.internal.objects.event.EventFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class FigureCanvasTester
extends WidgetTester {
    private GraphicalViewer m_viewer = null;

    private GraphicalViewer getViewer() {
        return this.m_viewer;
    }

    private Control getViewerControl() {
        return this.getViewer().getControl();
    }

    private RootEditPart getRootEditPart() {
        return this.getViewer().getRootEditPart();
    }

    private RootEditPart getPaletteRoot() {
        return this.getViewer().getEditDomain().getPaletteViewer().getRootEditPart();
    }

    private GraphicalEditPart findPaletteEditPart(String textPath, String operator) {
        String[] pathItems = MenuUtilBase.splitPath((String)textPath);
        boolean isExisting = true;
        EditPart currentEditPart = this.getPaletteRoot().getContents();
        int i = 0;
        while (i < pathItems.length && currentEditPart != null) {
            List effectiveChildren = currentEditPart.getChildren();
            EditPart[] children = effectiveChildren.toArray(new EditPart[effectiveChildren.size()]);
            boolean itemFound = false;
            int j = 0;
            while (j < children.length && !itemFound) {
                String entryLabel;
                Object model = children[j].getModel();
                if (model instanceof PaletteEntry && (entryLabel = ((PaletteEntry)model).getLabel()) != null && MatchUtil.getInstance().match(entryLabel, pathItems[i], operator)) {
                    itemFound = true;
                    currentEditPart = children[j];
                }
                ++j;
            }
            if (!itemFound) {
                isExisting = false;
                break;
            }
            ++i;
        }
        return isExisting && currentEditPart instanceof GraphicalEditPart ? (GraphicalEditPart)currentEditPart : null;
    }

    public void setComponent(final Object graphicsComponent) {
        Composite composite = (Composite)new RobotFactoryConfig().getRobotFactory().getEventThreadQueuer().invokeAndWait(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".setComponent", new IRunnable(){

            public Object run() throws StepExecutionException {
                FigureCanvas figureCanvas;
                FigureCanvas parent = figureCanvas = (FigureCanvas)graphicsComponent;
                while (parent != null && !(parent.getData("TEST_GEF_VIEWER") instanceof GraphicalViewer)) {
                    parent = parent.getParent();
                }
                if (parent != null) {
                    FigureCanvasTester.this.m_viewer = (GraphicalViewer)parent.getData("TEST_GEF_VIEWER");
                    return parent;
                }
                return null;
            }
        });
        this.setAdapter((IComponent)new ControlAdapter((Object)composite));
    }

    public void rcCheckFigureExists(String textPath, String operator, boolean exists) {
        boolean isExisting;
        boolean bl = isExisting = FigureCanvasUtil.findFigure(this.findEditPart(textPath, operator)) != null;
        if (!isExisting) {
            isExisting = this.findConnectionAnchor(textPath, operator) != null;
        }
        Verifier.equals((boolean)exists, (boolean)isExisting);
    }

    public void rcVerifyFigureProperty(String textPath, String textPathOperator, String propertyName, String expectedPropValue, String valueOperator) {
        IFigure figure = FigureCanvasUtil.findFigure(this.findEditPart(textPath, textPathOperator));
        this.nullCheckFigure(figure);
        String propToStr = this.getPropertyFromFigure(propertyName, figure);
        Verifier.match((String)propToStr, (String)expectedPropValue, (String)valueOperator);
    }

    private void nullCheckFigure(IFigure figure) {
        if (figure == null) {
            throw new StepExecutionException("No figure could be found for the given text path.", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
    }

    public void rcCheckToolExists(String textPath, String operator, boolean exists) {
        boolean isExisting = this.findPaletteFigure(textPath, operator) != null;
        Verifier.equals((boolean)exists, (boolean)isExisting);
    }

    public void rcClickFigure(String textPath, String operator, int count, int button) {
        IFigure figure = FigureCanvasUtil.findFigure(this.findEditPart(textPath, operator));
        this.nullCheckFigure(figure);
        this.clickFigure(count, button, figure);
    }

    public void rcClickConnection(String sourceTextPath, String sourceOperator, String targetTextPath, String targetOperator, int count, int button) {
        IFigure connectionFigure = this.getConnectionFigure(sourceTextPath, sourceOperator, targetTextPath, targetOperator);
        this.nullCheckFigure(connectionFigure);
        this.clickFigure(count, button, connectionFigure);
    }

    private void clickFigure(int count, int button, IFigure figure) {
        ClickOptions clickOptions = ClickOptions.create().setScrollToVisible(false).setClickCount(count).setMouseButton(button);
        if (figure instanceof Connection) {
            Point midpoint = ((Connection)figure).getPoints().getMidpoint();
            figure.translateToAbsolute((Translatable)midpoint);
            this.getRobot().click((Object)this.getViewerControl(), null, clickOptions, midpoint.x, true, midpoint.y, true);
        } else {
            this.getRobot().click((Object)this.getViewerControl(), (Object)this.getBounds(figure), clickOptions);
        }
    }

    private IFigure getConnectionFigure(String sourceTextPath, String sourceOperator, String targetTextPath, String targetOperator) {
        int i;
        ConnectionAnchor sourceConnectionAnchor = this.findConnectionAnchor(sourceTextPath, sourceOperator);
        GraphicalEditPart sourceEditPart = this.getPartWithAnchor(sourceTextPath, sourceOperator, sourceConnectionAnchor != null);
        ConnectionAnchor targetConnectionAnchor = this.findConnectionAnchor(targetTextPath, targetOperator);
        GraphicalEditPart targetEditPart = this.getPartWithAnchor(targetTextPath, targetOperator, targetConnectionAnchor != null);
        ConnectionEditPart connectionEditPart = null;
        if (sourceEditPart != null) {
            ConnectionEditPart[] sourceConnections = this.getSourceConnectionEditParts(sourceEditPart);
            i = 0;
            while (i < sourceConnections.length) {
                ConnectionEditPart connection;
                if (sourceConnections[i].getTarget() == targetEditPart && (connection = this.checkConnectionWithAnchor(sourceConnections[i], sourceConnectionAnchor, targetConnectionAnchor)) != null) {
                    connectionEditPart = connection;
                    break;
                }
                ++i;
            }
        } else if (targetEditPart != null) {
            ConnectionEditPart[] targetConnections = this.getTargetConnectionEditParts(targetEditPart);
            i = 0;
            while (i < targetConnections.length && connectionEditPart == null) {
                ConnectionEditPart connection;
                if (targetConnections[i].getSource() == targetEditPart && (connection = this.checkConnectionWithAnchor(targetConnections[i], sourceConnectionAnchor, targetConnectionAnchor)) != null) {
                    connectionEditPart = connection;
                    break;
                }
                ++i;
            }
        } else {
            throw new StepExecutionException("No figures could be found for the given text paths.", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
        IFigure connectionFigure = FigureCanvasUtil.findFigure(connectionEditPart);
        if (connectionFigure == null) {
            String missingEnd = sourceEditPart == null ? "source" : "target";
            throw new StepExecutionException("No connection could be found for the given " + missingEnd + " figure.", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
        this.revealEditPart((EditPart)connectionEditPart);
        return connectionFigure;
    }

    public void rcClickInFigure(String textPath, String operator, int count, int button, int xPos, String xUnits, int yPos, String yUnits) throws StepExecutionException {
        this.getRobot().click((Object)this.getViewerControl(), (Object)this.getFigureBoundsChecked(textPath, operator), ClickOptions.create().setScrollToVisible(false).setClickCount(count).setMouseButton(button), xPos, xUnits.equalsIgnoreCase(ValueSets.Unit.pixel.rcValue()), yPos, yUnits.equalsIgnoreCase(ValueSets.Unit.pixel.rcValue()));
    }

    public void rcDragFigure(String textPath, String operator, int mouseButton, String modifier, int xPos, String xUnits, int yPos, String yUnits) {
        DragAndDropHelperSwt dndHelper = DragAndDropHelperSwt.getInstance();
        dndHelper.setMouseButton(mouseButton);
        dndHelper.setModifier(modifier);
        dndHelper.setDragComponent(null);
        this.rcClickInFigure(textPath, operator, 0, mouseButton, xPos, xUnits, yPos, yUnits);
    }

    public void rcDropOnFigure(final String textPath, final String operator, final int xPos, final String xUnits, final int yPos, final String yUnits, int delayBeforeDrop) {
        final DragAndDropHelperSwt dndHelper = DragAndDropHelperSwt.getInstance();
        final IRobot robot = this.getRobot();
        String modifier = dndHelper.getModifier();
        final int mouseButton = dndHelper.getMouseButton();
        try {
            this.pressOrReleaseModifiers(modifier, true);
            this.getEventThreadQueuer().invokeAndWait("gdStartDragFigure", new IRunnable(){

                public Object run() throws StepExecutionException {
                    robot.mousePress((Object)dndHelper.getDragComponent(), null, mouseButton);
                    CAPUtil.shakeMouse();
                    FigureCanvasTester.this.rcClickInFigure(textPath, operator, 0, mouseButton, xPos, xUnits, yPos, yUnits);
                    return null;
                }
            });
            FigureCanvasTester.waitBeforeDrop((int)delayBeforeDrop);
        }
        finally {
            this.getRobot().mouseRelease(null, null, mouseButton);
            this.pressOrReleaseModifiers(modifier, false);
        }
    }

    private org.eclipse.swt.graphics.Rectangle getFigureBoundsChecked(String textPath, String operator) {
        GraphicalEditPart editPart = this.findEditPart(textPath, operator);
        IFigure figure = FigureCanvasUtil.findFigure(editPart);
        ConnectionAnchor anchor = null;
        if (figure == null) {
            anchor = this.findConnectionAnchor(textPath, operator);
            if (anchor != null) {
                String[] pathItems = MenuUtilBase.splitPath((String)textPath);
                String[] editPartPathItems = new String[pathItems.length - 1];
                System.arraycopy(pathItems, 0, editPartPathItems, 0, editPartPathItems.length);
                editPart = this.findEditPart(operator, editPartPathItems);
            }
            if (anchor == null || FigureCanvasUtil.findFigure(editPart) == null) {
                throw new StepExecutionException("No figure could be found for the given text path.", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
            }
        }
        this.revealEditPart((EditPart)editPart);
        return figure != null ? this.getBounds(figure) : this.getBounds(anchor);
    }

    public void rcSelectTool(String textPath, String operator, int count) {
        Control paletteControl = this.getPaletteControl();
        IFigure figure = this.findPaletteFigureChecked(textPath, operator);
        this.getRobot().click((Object)paletteControl, (Object)this.getBounds(figure), ClickOptions.create().setScrollToVisible(false).setClickCount(count));
    }

    private Control getPaletteControl() {
        EditDomain editDomain = this.getViewer().getEditDomain();
        if (editDomain == null) {
            return null;
        }
        PaletteViewer paletteViewer = editDomain.getPaletteViewer();
        if (paletteViewer == null) {
            return null;
        }
        return paletteViewer.getControl();
    }

    private org.eclipse.swt.graphics.Rectangle getBounds(IFigure figure) {
        Rectangle figureBounds = new Rectangle(figure.getBounds());
        figure.translateToAbsolute((Translatable)figureBounds);
        return new org.eclipse.swt.graphics.Rectangle(figureBounds.x, figureBounds.y, figureBounds.width, figureBounds.height);
    }

    private org.eclipse.swt.graphics.Rectangle getBounds(ConnectionAnchor anchor) {
        Validate.notNull((Object)anchor);
        Point refPoint = anchor.getReferencePoint();
        return new org.eclipse.swt.graphics.Rectangle(refPoint.x - 1, refPoint.y - 1, 3, 3);
    }

    private GraphicalEditPart findEditPart(String textPath, String operator) {
        String[] pathItems = MenuUtilBase.splitPath((String)textPath);
        return this.findEditPart(operator, pathItems);
    }

    private GraphicalEditPart findEditPart(String operator, String[] pathItems) {
        boolean isExisting = true;
        EditPart currentEditPart = this.getRootEditPart().getContents();
        int i = 0;
        while (i < pathItems.length && currentEditPart != null) {
            ArrayList childrens = new ArrayList(currentEditPart.getChildren());
            if (currentEditPart instanceof GraphicalEditPart) {
                GraphicalEditPart graph = (GraphicalEditPart)currentEditPart;
                childrens.addAll(graph.getSourceConnections());
            }
            EditPart[] children = childrens.toArray(new EditPart[childrens.size()]);
            boolean itemFound = false;
            int j = 0;
            while (j < children.length && !itemFound) {
                String figureId;
                IEditPartIdentifier childFigureIdentifier = DefaultEditPartAdapterFactory.loadFigureIdentifier(children[j]);
                if (children[j] instanceof ConnectionEditPart) {
                    String figureId2;
                    ConnectionEditPart connection = (ConnectionEditPart)children[j];
                    Map.Entry<String, ConnectionAnchor> anchorWithIdentifier = FigureCanvasUtil.getConnectionAnchor(connection);
                    if (anchorWithIdentifier != null && MatchUtil.getInstance().match(anchorWithIdentifier.getKey(), pathItems[i], operator) && childFigureIdentifier != null && (figureId2 = childFigureIdentifier.getIdentifier()) != null && pathItems.length >= i + 2 && MatchUtil.getInstance().match(figureId2, pathItems[i + 1], operator)) {
                        itemFound = true;
                        currentEditPart = children[j];
                        ++i;
                    }
                } else if (childFigureIdentifier != null && (figureId = childFigureIdentifier.getIdentifier()) != null && MatchUtil.getInstance().match(figureId, pathItems[i], operator)) {
                    itemFound = true;
                    currentEditPart = children[j];
                }
                ++j;
            }
            if (!itemFound) {
                isExisting = false;
                break;
            }
            ++i;
        }
        return isExisting && currentEditPart instanceof GraphicalEditPart ? (GraphicalEditPart)currentEditPart : null;
    }

    private IFigure findPaletteFigure(String textPath, String operator) {
        GraphicalEditPart editPart = this.findPaletteEditPart(textPath, operator);
        this.revealEditPart((EditPart)editPart);
        return FigureCanvasUtil.findFigure(editPart);
    }

    private IFigure findPaletteFigureChecked(String textPath, String operator) {
        IFigure figure = this.findPaletteFigure(textPath, operator);
        if (figure == null) {
            throw new StepExecutionException("No palette figure could be found for the given text path.", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
        return figure;
    }

    private ConnectionAnchor findConnectionAnchor(String textPath, String operator) {
        String[] pathItems = MenuUtilBase.splitPath((String)textPath);
        String[] editPartPathItems = new String[pathItems.length - 1];
        System.arraycopy(pathItems, 0, editPartPathItems, 0, editPartPathItems.length);
        GraphicalEditPart editPart = this.findEditPart(operator, editPartPathItems);
        if (editPart != null) {
            Map<String, ConnectionAnchor> anchorMap;
            String anchorPathItem = pathItems[pathItems.length - 1];
            IEditPartIdentifier editPartIdentifier = DefaultEditPartAdapterFactory.loadFigureIdentifier((EditPart)editPart);
            if (editPartIdentifier != null && (anchorMap = editPartIdentifier.getConnectionAnchors()) != null) {
                for (String anchorMapKey : anchorMap.keySet()) {
                    ConnectionAnchor anchorMapValue = anchorMap.get(anchorMapKey);
                    if (!(anchorMapKey instanceof String) || !(anchorMapValue instanceof ConnectionAnchor) || !MatchUtil.getInstance().match(anchorMapKey, anchorPathItem, operator)) continue;
                    return anchorMapValue;
                }
            }
        }
        return null;
    }

    private void revealEditPart(final EditPart editPart) {
        if (editPart != null) {
            this.getEventThreadQueuer().invokeAndWait(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".revealEditPart", new IRunnable(){

                public Object run() throws StepExecutionException {
                    editPart.getViewer().reveal(editPart);
                    return null;
                }
            });
        }
    }

    public void rcCheckConnectionExists(String sourceTextPath, String sourceOperator, String targetTextPath, String targetOperator, boolean exists) {
        boolean found = true;
        try {
            this.getConnectionFigure(sourceTextPath, sourceOperator, targetTextPath, targetOperator);
        }
        catch (StepExecutionException stepExecutionException) {
            found = false;
        }
        Verifier.equals((boolean)exists, (boolean)found);
    }

    private GraphicalEditPart getPartWithAnchor(String path, String operator, boolean pathWithAnchor) {
        String[] pathItems = MenuUtilBase.splitPath((String)path);
        if (pathWithAnchor) {
            String[] editPartPathItems = new String[pathItems.length - 1];
            System.arraycopy(pathItems, 0, editPartPathItems, 0, editPartPathItems.length);
            pathItems = editPartPathItems;
        }
        return this.findEditPart(operator, pathItems);
    }

    private ConnectionEditPart checkConnectionWithAnchor(ConnectionEditPart connection, ConnectionAnchor sourceConnectionAnchor, ConnectionAnchor targetConnectionAnchor) {
        NodeEditPart node;
        ConnectionAnchor anchor;
        EditPart source = connection.getSource();
        EditPart target = connection.getTarget();
        boolean isSourceCorrect = false;
        boolean isTargetCorrect = false;
        if (source instanceof NodeEditPart && sourceConnectionAnchor != null && sourceConnectionAnchor == (anchor = (node = (NodeEditPart)source).getSourceConnectionAnchor(connection))) {
            isSourceCorrect = true;
        }
        if (target instanceof NodeEditPart && targetConnectionAnchor != null && targetConnectionAnchor == (anchor = (node = (NodeEditPart)target).getTargetConnectionAnchor(connection))) {
            isTargetCorrect = true;
        }
        if (isSourceCorrect && isTargetCorrect || isSourceCorrect && targetConnectionAnchor == null || isTargetCorrect && sourceConnectionAnchor == null || targetConnectionAnchor == null && sourceConnectionAnchor == null) {
            return connection;
        }
        return null;
    }

    public void rcCheckNumberOfAnchors(String textPath, String operator, String anchorType, int count, String comparisonMethod) {
        GraphicalEditPart editPart = this.findEditPart(textPath, operator);
        if (editPart == null) {
            throw new StepExecutionException("No Edit Part could be found for the given text path.", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
        IEditPartIdentifier editPartIdentifier = DefaultEditPartAdapterFactory.loadFigureIdentifier((EditPart)editPart);
        int connectionCount = 0;
        if (anchorType.equals(ValueSets.AnchorType.both.rcValue())) {
            connectionCount = editPartIdentifier.getConnectionAnchors().size();
        } else if (editPartIdentifier instanceof IDirectionalEditPartAnchorIdentifier) {
            IDirectionalEditPartAnchorIdentifier extended = (IDirectionalEditPartAnchorIdentifier)((Object)editPartIdentifier);
            if (anchorType.equals(ValueSets.AnchorType.incoming.rcValue())) {
                connectionCount = extended.getIncomingConnectionAnchors().size();
            } else if (anchorType.equals(ValueSets.AnchorType.outgoing.rcValue())) {
                connectionCount = extended.getOutgoingConnectionAnchors().size();
            }
        } else {
            throw new StepExecutionException("GraphicalEditPart does not support the anchor type" + anchorType, EventFactory.createActionError());
        }
        Comparer.compare((String)Integer.toString(connectionCount), (String)Integer.toString(count), (String)comparisonMethod);
    }

    public void rcCheckAnchorConnection(String textPath, String operator, boolean hasConnection) {
        ConnectionEditPart connectiontest;
        ConnectionAnchor anchor = this.findConnectionAnchor(textPath, operator);
        if (anchor == null) {
            throw new StepExecutionException("No Anchor could be found for the given text path.", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
        GraphicalEditPart anchorEditPart = this.getPartWithAnchor(textPath, operator, true);
        ConnectionEditPart[] sourceConnections = this.getSourceConnectionEditParts(anchorEditPart);
        ConnectionEditPart[] targetConnections = this.getTargetConnectionEditParts(anchorEditPart);
        boolean connection = false;
        int i = 0;
        while (i < sourceConnections.length) {
            connectiontest = this.checkConnectionWithAnchor(sourceConnections[i], anchor, null);
            if (connectiontest != null) {
                connection = true;
                break;
            }
            ++i;
        }
        if (!connection) {
            i = 0;
            while (i < targetConnections.length) {
                connectiontest = this.checkConnectionWithAnchor(targetConnections[i], null, anchor);
                if (connectiontest != null) {
                    connection = true;
                    break;
                }
                ++i;
            }
        }
        Verifier.equals((boolean)hasConnection, (boolean)connection);
    }

    private ConnectionEditPart[] getSourceConnectionEditParts(GraphicalEditPart editPart) {
        List sourceConnectionList = editPart.getSourceConnections();
        ConnectionEditPart[] sourceConnections = sourceConnectionList.toArray(new ConnectionEditPart[sourceConnectionList.size()]);
        return sourceConnections;
    }

    private ConnectionEditPart[] getTargetConnectionEditParts(GraphicalEditPart editPart) {
        List targetConnectionList = editPart.getSourceConnections();
        ConnectionEditPart[] targetConnections = targetConnectionList.toArray(new ConnectionEditPart[targetConnectionList.size()]);
        return targetConnections;
    }

    public void rcVerifyConnectionProperty(String sourceTextPath, String sourceOperator, String targetTextPath, String targetOperator, String propertyName, String expectedPropValue, String valueOperator) {
        IFigure figure = this.getConnectionFigure(sourceTextPath, sourceOperator, targetTextPath, targetOperator);
        String propToStr = this.getPropertyFromFigure(propertyName, figure);
        Verifier.match((String)propToStr, (String)expectedPropValue, (String)valueOperator);
    }

    private String getPropertyFromFigure(final String propertyName, final IFigure figure) {
        Object prop = this.getEventThreadQueuer().invokeAndWait("getProperty", (IRunnable)new IRunnable<Object>(){

            public Object run() throws StepExecutionException {
                try {
                    return PropertyUtils.getProperty((Object)figure, (String)propertyName);
                }
                catch (IllegalAccessException e) {
                    throw new StepExecutionException(e.getMessage(), EventFactory.createActionError((String)"TestErrorEvent.PropertyNotAccessable"));
                }
                catch (InvocationTargetException e) {
                    throw new StepExecutionException(e.getMessage(), EventFactory.createActionError((String)"TestErrorEvent.PropertyNotAccessable"));
                }
                catch (NoSuchMethodException e) {
                    throw new StepExecutionException(e.getMessage(), EventFactory.createActionError((String)"TestErrorEvent.PropertyNotAccessable"));
                }
            }
        });
        String propToStr = String.valueOf(prop);
        return propToStr;
    }
}

