/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swing.driver;

import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.rc.common.driver.IEventThreadQueuer;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.driver.RunnableWrapper;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventThreadQueuerAwtImpl
implements IEventThreadQueuer {
    private static AutServerLogger log = new AutServerLogger(EventThreadQueuerAwtImpl.class);

    public <V> V invokeAndWait(String name, IRunnable<V> runnable) throws StepExecutionException {
        Validate.notNull(runnable, (String)"runnable must not be null");
        RunnableWrapper wrapper = new RunnableWrapper(name, runnable);
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                wrapper.run();
            } else {
                SwingUtilities.invokeAndWait((Runnable)wrapper);
            }
            StepExecutionException exception = wrapper.getException();
            if (exception != null) {
                throw new InvocationTargetException(exception);
            }
        }
        catch (InterruptedException ie) {
            log.error((Object)ie);
            throw new StepExecutionException((Throwable)ie);
        }
        catch (InvocationTargetException ite) {
            Throwable thrown = ite.getTargetException();
            if (thrown instanceof StepExecutionException) {
                if (log.isInfoEnabled()) {
                    log.info((Object)ite);
                }
                throw (StepExecutionException)thrown;
            }
            log.error((Object)("exception thrown by '" + wrapper.getName() + "':"), thrown);
            throw new StepExecutionException(thrown);
        }
        return (V)wrapper.getResult();
    }

    public void invokeLater(String name, Runnable runnable) throws StepExecutionException {
        Validate.notNull((Object)runnable, (String)"runnable must not be null");
        SwingUtilities.invokeLater(runnable);
    }
}

