/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.app.testexec.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jubula.app.testexec.i18n.Messages;
import org.eclipse.jubula.autagent.AutStarter;
import org.eclipse.jubula.client.cmd.AbstractCmdlineClient;
import org.eclipse.jubula.client.cmd.JobConfiguration;
import org.eclipse.jubula.client.core.ClientTest;
import org.eclipse.jubula.client.core.IClientTest;
import org.eclipse.jubula.client.core.agent.AutAgentRegistration;
import org.eclipse.jubula.client.core.agent.AutRegistrationEvent;
import org.eclipse.jubula.client.core.agent.IAutRegistrationListener;
import org.eclipse.jubula.client.core.businessprocess.ExternalTestDataBP;
import org.eclipse.jubula.client.core.businessprocess.ITestExecutionEventListener;
import org.eclipse.jubula.client.core.businessprocess.TestExecution;
import org.eclipse.jubula.client.core.businessprocess.TestExecutionEvent;
import org.eclipse.jubula.client.core.businessprocess.compcheck.CompletenessGuard;
import org.eclipse.jubula.client.core.businessprocess.problems.IProblem;
import org.eclipse.jubula.client.core.businessprocess.problems.ProblemFactory;
import org.eclipse.jubula.client.core.constants.TestExecutionConstants;
import org.eclipse.jubula.client.core.events.AUTEvent;
import org.eclipse.jubula.client.core.events.AUTServerEvent;
import org.eclipse.jubula.client.core.events.AutAgentEvent;
import org.eclipse.jubula.client.core.events.IAUTEventListener;
import org.eclipse.jubula.client.core.events.IAUTServerEventListener;
import org.eclipse.jubula.client.core.events.IServerEventListener;
import org.eclipse.jubula.client.core.model.IAUTConfigPO;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.IExecStackModificationListener;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.IRefTestSuitePO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.ProjectVersion;
import org.eclipse.jubula.client.core.model.ReentryProperty;
import org.eclipse.jubula.client.core.persistence.DatabaseConnectionInfo;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.core.persistence.ProjectPM;
import org.eclipse.jubula.client.core.utils.AbstractNonPostOperatingTreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeTraverserContext;
import org.eclipse.jubula.client.core.utils.NodeNameUtil;
import org.eclipse.jubula.client.core.utils.TreeTraverser;
import org.eclipse.jubula.client.internal.AutAgentConnection;
import org.eclipse.jubula.toolkit.common.exception.ToolkitPluginException;
import org.eclipse.jubula.tools.internal.exception.CommunicationException;
import org.eclipse.jubula.tools.internal.exception.JBException;
import org.eclipse.jubula.tools.internal.i18n.I18n;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.internal.registration.AutIdentifier;
import org.eclipse.jubula.tools.internal.utils.FileUtils;
import org.eclipse.jubula.tools.internal.utils.IsAliveThread;
import org.eclipse.jubula.tools.internal.utils.NetUtil;
import org.eclipse.jubula.tools.internal.utils.TimeUtil;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionController
implements IAUTServerEventListener,
IServerEventListener,
IAUTEventListener,
ITestExecutionEventListener,
IAutRegistrationListener {
    private static final String AUT_STARTUP_DELAY_VAR = "TEST_AUT_STARTUP_DELAY";
    private static final int AUT_STARTUP_DELAY_DEFAULT = 5000;
    private static final Logger LOG = LoggerFactory.getLogger(ExecutionController.class);
    private static ExecutionController instance;
    private JobConfiguration m_job;
    private boolean m_idle = false;
    private boolean m_isTestSuiteRunning = false;
    private boolean m_isFirstAutStart = true;
    private boolean m_noErrorWhileExecution = true;
    private boolean m_shutdown = false;
    private boolean m_stopProcessing = false;
    private TestExecutionWatcher m_progress = new TestExecutionWatcher();
    private AutIdentifier m_startedAutId = null;

    private ExecutionController() {
        IClientTest clientTest = ClientTest.instance();
        clientTest.addAUTServerEventListener((IAUTServerEventListener)this);
        clientTest.addAutAgentEventListener((IServerEventListener)this);
        clientTest.addTestEventListener((IAUTEventListener)this);
        clientTest.addTestExecutionEventListener((ITestExecutionEventListener)this);
        AutAgentRegistration.getInstance().addListener((IAutRegistrationListener)this);
    }

    public static ExecutionController getInstance() {
        if (instance == null) {
            instance = new ExecutionController();
        }
        return instance;
    }

    public JobConfiguration initJob(File configFile) throws IOException {
        if (configFile != null) {
            BufferedReader in = null;
            StringWriter writer = new StringWriter();
            try {
                in = new BufferedReader(new FileReader(configFile));
                String line = null;
                while ((line = in.readLine()) != null) {
                    writer.write(line);
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
            String xml = writer.toString();
            this.m_job = JobConfiguration.readFromXML((String)xml);
        } else {
            this.m_job = new JobConfiguration();
        }
        return this.m_job;
    }

    public boolean executeJob() throws CommunicationException {
        WatchdogTimer timer;
        block12: {
            IClientTest clientTest;
            String noRun = this.m_job.getNoRunOptMode();
            if (AbstractCmdlineClient.isNoRun()) {
                this.sysOut("\t" + NLS.bind((String)Messages.ExecutionControllerNoRunExecutionBegin, (Object)TestExecutionConstants.RunSteps.valueOf((String)noRun.toUpperCase()).getDescription()));
            }
            timer = null;
            if (this.m_job.getTimeout() > 0) {
                timer = new WatchdogTimer(this.m_job.getTimeout());
                timer.start();
            }
            if (!this.prepareAUTAgentConnection(clientTest = ClientTest.instance())) {
                return false;
            }
            if (TestExecution.shouldExecutionStop((String)noRun, (TestExecutionConstants.RunSteps)TestExecutionConstants.RunSteps.CAA)) {
                return true;
            }
            clientTest.setScreenshotXMLFlag(this.m_job.isXMLScreenshot());
            this.prepareDBConnection();
            if (TestExecution.shouldExecutionStop((String)noRun, (TestExecutionConstants.RunSteps)TestExecutionConstants.RunSteps.CDB)) {
                return true;
            }
            this.loadProject();
            if (TestExecution.shouldExecutionStop((String)noRun, (TestExecutionConstants.RunSteps)TestExecutionConstants.RunSteps.LP)) {
                return true;
            }
            this.checkTestCompleteness();
            if (TestExecution.shouldExecutionStop((String)noRun, (TestExecutionConstants.RunSteps)TestExecutionConstants.RunSteps.CC)) {
                return true;
            }
            this.m_idle = true;
            if (this.m_shutdown) {
                this.sysOut(Messages.ReceivedShutdownCommand);
                this.endTestExecution();
            }
            this.ensureAutIsStarted(this.m_job.getActualTestSuite(), this.m_job.getAutConfig());
            if (!TestExecution.shouldExecutionStop((String)noRun, (TestExecutionConstants.RunSteps)TestExecutionConstants.RunSteps.SA)) break block12;
            return true;
        }
        try {
            this.doTest(this.m_job.getTestJob() != null);
        }
        catch (ToolkitPluginException toolkitPluginException) {
            this.sysErr(NLS.bind((String)Messages.ExecutionControllerAUT, (Object)Messages.ErrorMessageAUT_TOOLKIT_NOT_AVAILABLE));
        }
        if (timer != null) {
            timer.abort();
        }
        return this.isNoErrorWhileExecution();
    }

    private void doTest(boolean testJobIsSpecified) {
        if (testJobIsSpecified) {
            this.doTestJob();
            return;
        }
        this.doTestSuite();
    }

    private boolean startEmbeddedAutAgent(int port) throws CommunicationException {
        AutStarter autAgentInstance = AutStarter.getInstance();
        if (autAgentInstance.getCommunicator() == null) {
            try {
                this.sysOut(I18n.getString((String)"AUTAgent.EmbeddedAUTAgentStart", (Object[])new String[]{String.valueOf(port)}));
                autAgentInstance.start(port, false, AutStarter.Verbosity.QUIET, false);
                return true;
            }
            catch (Exception e) {
                LOG.error(e.getLocalizedMessage(), (Throwable)e);
                return false;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private void doTestSuite() {
        ** GOTO lbl11
        {
            TimeUtil.delay((long)50L);
            do {
                if (this.m_idle && !this.m_stopProcessing) continue block0;
                if (this.m_job.getActualTestSuite() == null || this.m_stopProcessing || this.m_idle || this.m_isFirstAutStart) continue;
                ts = this.m_job.getActualTestSuite();
                this.m_idle = true;
                this.sysOut("\t" + NLS.bind((String)Messages.ExecutionControllerTestSuiteBegin, (Object)ts.getName()));
                ClientTest.instance().startTestSuite(ts, this.m_startedAutId != null ? this.m_startedAutId : this.m_job.getAutId(), this.m_job.isAutoScreenshot(), null, this.m_job.getNoRunOptMode(), null);
lbl11:
                // 3 sources

            } while (this.m_job.getActualTestSuite() != null && !this.m_stopProcessing);
        }
        this.waitForReportingToFinish(1800000L);
    }

    private void doTestJob() {
        String tjName = this.m_job.getTestJob().getName();
        this.sysOut(NLS.bind((String)Messages.ExecutionControllerTestJobBegin, (Object)tjName));
        this.sysOut(NLS.bind((String)Messages.ExecutionControllerTestJobExpectedTestSuites, (Object[])new Object[]{tjName, this.m_job.getTestJob().getNodeListSize()}));
        List executedTestSuites = ClientTest.instance().startTestJob(this.m_job.getTestJob(), this.m_job.isAutoScreenshot(), this.m_job.getNoRunOptMode());
        this.sysOut(NLS.bind((String)Messages.ExecutionControllerTestJobExecutedTestSuites, (Object[])new Object[]{tjName, executedTestSuites.size()}));
        Iterator tsIterator = this.m_job.getTestJob().getNodeListIterator();
        this.waitForReportingToFinish(1800000L);
        while (tsIterator.hasNext()) {
            INodePO testsuite = (INodePO)tsIterator.next();
            if (executedTestSuites.contains(testsuite)) continue;
            this.sysErr(NLS.bind((String)Messages.ExecutionControllerTestJobUnsuccessfulTestSuites, (Object[])new Object[]{tjName, testsuite.getName()}));
        }
    }

    private void waitForReportingToFinish(long timeout) {
        long endtime = System.currentTimeMillis() + timeout;
        TimeUtil.delay((long)500L);
        while (ClientTest.instance().isReportingRunning()) {
            TimeUtil.delay((long)250L);
            if (endtime - System.currentTimeMillis() >= 0L) continue;
            return;
        }
    }

    private void stopProcessing() {
        this.m_stopProcessing = true;
    }

    private boolean prepareAUTAgentConnection(IClientTest clientTest) throws CommunicationException {
        int autAgentPortNumber = this.m_job.getPort();
        if (StringUtils.isEmpty((String)this.m_job.getServer())) {
            if (autAgentPortNumber == 0) {
                autAgentPortNumber = NetUtil.getFreePort();
            }
            this.m_job.setEmbeddedAutAgentHostName();
            if (!this.startEmbeddedAutAgent(autAgentPortNumber)) {
                this.endTestExecution();
                return false;
            }
        }
        String autAgentHostName = this.m_job.getServer();
        this.sysOut(NLS.bind((String)Messages.ConnectingToAUTAgent, (Object[])new Object[]{autAgentHostName, autAgentPortNumber}));
        clientTest.connectToAutAgent(autAgentHostName, String.valueOf(autAgentPortNumber));
        if (!AutAgentConnection.getInstance().isConnected()) {
            throw new CommunicationException(Messages.ConnectionToAUTAgentFailed, MessageIDs.E_COMMUNICATOR_CONNECTION);
        }
        return true;
    }

    private void prepareDBConnection() {
        this.setLogDir();
        ExternalTestDataBP.setDataDir((File)new File(this.m_job.getDataDir()));
        Persistor.setDbConnectionName((DatabaseConnectionInfo)this.m_job.getDbscheme());
        Persistor.setUser((String)this.m_job.getDbuser());
        Persistor.setPw((String)this.m_job.getDbpw());
        Persistor.setUrl((String)this.m_job.getDb());
        if (!Persistor.init()) {
            throw new IllegalArgumentException(Messages.ExecutionControllerInvalidDBDataError, null);
        }
    }

    private void setLogDir() {
        if (StringUtils.isNotEmpty((String)this.m_job.getResultDir())) {
            Validate.isTrue((boolean)FileUtils.isValidPath((String)this.m_job.getResultDir()), (String)Messages.ExecutionControllerLogPathError);
            ClientTest.instance().setLogPath(this.m_job.getResultDir());
        }
        if (StringUtils.isNotBlank((String)this.m_job.getFileName())) {
            String filePath = String.valueOf(this.m_job.getResultDir()) + "/" + this.m_job.getFileName();
            boolean isWritable = FileUtils.isWritableFile((String)(String.valueOf(filePath) + ".xml"));
            if (isWritable) {
                isWritable = FileUtils.isWritableFile((String)(String.valueOf(filePath) + ".html"));
            }
            Validate.isTrue((boolean)isWritable, (String)Messages.ExecutionControllerResultNameError);
            ClientTest.instance().setFileName(this.m_job.getFileName());
        }
    }

    private void ensureAutIsStarted(ITestSuitePO ts, IAUTConfigPO autConf) throws ToolkitPluginException {
        if (ts != null && autConf != null) {
            IAUTMainPO aut = ts.getAut();
            if (ts != null) {
                AutIdentifier autToStart = new AutIdentifier((String)autConf.getConfigMap().get("AUT_ID"));
                AUTStartListener asl = new AUTStartListener(autToStart);
                IClientTest clientTest = ClientTest.instance();
                clientTest.addTestEventListener((IAUTEventListener)asl);
                clientTest.addAUTServerEventListener((IAUTServerEventListener)asl);
                AutAgentRegistration.getInstance().addListener((IAutRegistrationListener)asl);
                this.sysOut(NLS.bind((String)Messages.ExecutionControllerAUT, (Object)NLS.bind((String)Messages.ExecutionControllerAUTStart, (Object)aut.getName(), (Object)autConf.getName())));
                clientTest.startAut(aut, autConf);
                this.m_startedAutId = autToStart;
                while (!asl.autStarted() && !asl.hasAutStartFailed()) {
                    TimeUtil.delay((long)500L);
                }
                this.waitExternalTime();
            }
        } else {
            this.m_idle = false;
            this.m_isFirstAutStart = false;
        }
    }

    private void waitExternalTime() {
        TimeUtil.delayDefaultOrExternalTime((long)5000L, (String)AUT_STARTUP_DELAY_VAR);
    }

    private void loadProject() {
        this.sysOut(String.valueOf(Messages.ExecutionControllerDatabase) + NLS.bind((String)Messages.ExecutionControllerLoadingProject, (Object[])new Object[]{this.m_job.getProjectName(), this.m_job.getProjectVersion()}));
        try {
            IProjectPO actualProject = ProjectPM.loadProjectByNameAndVersion((String)this.m_job.getProjectName(), (ProjectVersion)this.m_job.getProjectVersion());
            if (actualProject != null) {
                ProjectPM.loadProjectInROSession((IProjectPO)actualProject);
                IProjectPO currentProject = GeneralStorage.getInstance().getProject();
                this.m_job.setProject(currentProject);
                this.sysOut(String.valueOf(Messages.ExecutionControllerDatabase) + NLS.bind((String)Messages.ExecutionControllerProjectLoaded, (Object)this.m_job.getProjectName()));
            }
            this.m_job.checkProjectExistence();
        }
        catch (JBException jBException) {}
    }

    private void checkTestCompleteness() {
        this.sysOut(Messages.ExecutionControllerProjectCompleteness);
        this.m_job.initAndValidate();
        boolean noErrors = true;
        HashSet distinctListOfTs = new HashSet();
        distinctListOfTs.addAll(this.m_job.getTestSuites());
        for (ITestSuitePO ts : distinctListOfTs) {
            boolean noError = true;
            CompletenessGuard.checkAll((INodePO)ts, (IProgressMonitor)new NullProgressMonitor());
            this.sysOut(NLS.bind((String)Messages.ExecutionControllerTestSuiteCompleteness, (Object)ts.getName()));
            CollectAllErrorsOperation op = new CollectAllErrorsOperation();
            TreeTraverser traverser = new TreeTraverser((INodePO)ts, (ITreeNodeOperation)op);
            traverser.traverse(true);
            for (IProblem problem : op.getErrorsToShow()) {
                if (problem.hasUserMessage()) {
                    this.sysOut(problem.getUserMessage());
                }
                noError = false;
            }
            if (noError) {
                this.sysOut(Messages.ExecutionControllerTestSuiteCompletenessOk);
                continue;
            }
            this.sysOut(Messages.ExecutionControllerTestSuiteCompletenessNOk);
            noErrors = false;
        }
        Validate.isTrue((boolean)noErrors, (String)Messages.ExecutionControllerProjectCompletenessFailed);
    }

    public void stateChanged(AUTServerEvent event) {
        switch (event.getState()) {
            case 6: {
                this.sysErr(Messages.ExecutionControllerInvalidJarError);
                this.stopProcessing();
                this.m_idle = false;
                break;
            }
            case 7: {
                this.sysErr(Messages.ExecutionControllerInvalidJREError);
                this.stopProcessing();
                this.m_idle = false;
                break;
            }
            case 11: {
                this.sysErr(Messages.ExecutionControllerServerNotInstantiated);
                this.stopProcessing();
                this.m_idle = false;
                break;
            }
            case 5: {
                this.sysErr(Messages.ExecutionControllerInvalidMainError);
                this.stopProcessing();
                this.m_idle = false;
                break;
            }
            case 3: 
            case 4: {
                this.sysErr(Messages.ExecutionControllerAUTStartError);
                this.stopProcessing();
                this.m_idle = false;
                break;
            }
            case 2: {
                this.stopProcessing();
                this.m_idle = false;
                break;
            }
            case 12: {
                this.sysErr(Messages.ExecutionControllerDotNetInstallProblem);
                this.stopProcessing();
                this.m_idle = false;
                break;
            }
        }
    }

    public void stateChanged(AutAgentEvent event) {
        this.sysOut(NLS.bind((String)Messages.ExecutionControllerServer, (Object)event));
        switch (event.getState()) {
            case 2: {
                break;
            }
        }
    }

    public void stateChanged(AUTEvent event) {
        switch (event.getState()) {
            case 1: {
                this.sysOut(NLS.bind((String)Messages.ExecutionControllerAUT, (Object)Messages.ExecutionControllerAUTConnectionEstablished));
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.sysErr(Messages.ExecutionControllerAUTStartError);
                this.stopProcessing();
                break;
            }
            case 2: {
                if (this.m_isTestSuiteRunning) {
                    this.sysErr(Messages.ExecutionControllerAUTConnectionLost);
                    ClientTest.instance().stopTestExecution();
                } else {
                    this.sysOut(NLS.bind((String)Messages.ExecutionControllerAUT, (Object)Messages.ExecutionControllerAUTDisconnected));
                }
                this.stopProcessing();
                break;
            }
            case 8: {
                return;
            }
        }
        if (this.m_isFirstAutStart) {
            this.m_idle = false;
            this.m_isFirstAutStart = false;
        }
    }

    private void sysOut(String text) {
        AbstractCmdlineClient.printConsoleLn((String)text, (boolean)true);
    }

    private void sysErr(String text) {
        AbstractCmdlineClient.printlnConsoleError((String)text);
    }

    public void stateChanged(TestExecutionEvent event) {
        Exception exception = event.getException();
        if (exception instanceof JBException) {
            String errorMsg = exception.getMessage();
            this.sysErr(errorMsg);
            TestExecution.getInstance().stopExecution();
            this.stopProcessing();
        }
        switch (event.getState()) {
            case TEST_EXEC_RESULT_TREE_READY: {
                TestExecution.getInstance().getTrav().addExecStackModificationListener((IExecStackModificationListener)this.m_progress);
                break;
            }
            case TEST_EXEC_START: 
            case TEST_EXEC_RESTART: {
                this.m_isTestSuiteRunning = true;
                break;
            }
            case TEST_EXEC_FINISHED: {
                this.sysOut(Messages.ExecutionControllerTestSuiteEnd);
                this.m_job.getNextTestSuite();
                this.m_isTestSuiteRunning = false;
                break;
            }
            case TEST_EXEC_PAUSED: {
                TestExecution.getInstance().pauseExecution(TestExecution.PauseMode.UNPAUSE);
                break;
            }
            case TEST_EXEC_STOP: 
            case TEST_EXEC_FAILED: 
            case TEST_EXEC_ERROR: {
                this.m_job.getNextTestSuite();
                this.m_isTestSuiteRunning = false;
                break;
            }
        }
    }

    public void endTestExecution() {
        this.m_idle = false;
    }

    public void setJob(JobConfiguration job) {
        this.m_job = job;
    }

    public void handleAutRegistration(AutRegistrationEvent event) {
        if ((event.getAutId().equals((Object)this.m_startedAutId) || event.getAutId().equals((Object)this.m_job.getAutId())) && event.getStatus() == AutRegistrationEvent.RegistrationStatus.Register && this.m_isFirstAutStart) {
            this.m_idle = false;
            this.m_isFirstAutStart = false;
        }
    }

    protected void setNoErrorWhileExecution(boolean noErrorWhileExecution) {
        this.m_noErrorWhileExecution = noErrorWhileExecution;
    }

    protected boolean isNoErrorWhileExecution() {
        return this.m_noErrorWhileExecution;
    }

    public class AUTStartListener
    implements IAUTEventListener,
    IAUTServerEventListener,
    IAutRegistrationListener {
        private boolean m_autStarted = false;
        private boolean m_autStartFailed = false;
        private Timer m_startFailedTimer = new Timer();
        private long m_autStartTimeout = 300000L;
        private AutIdentifier m_autToStart;

        public AUTStartListener(AutIdentifier autToStart) {
            this.m_autToStart = autToStart;
            this.m_startFailedTimer.schedule(new TimerTask(){

                public void run() {
                    AUTStartListener.this.setAutStartFailed(true);
                    AUTStartListener.this.removeListener();
                }
            }, this.m_autStartTimeout);
        }

        public synchronized boolean autStarted() {
            return this.m_autStarted;
        }

        public synchronized void stateChanged(AUTEvent event) {
            switch (event.getState()) {
                case 1: {
                    this.m_autStarted = true;
                    this.dispose();
                    break;
                }
            }
        }

        public synchronized boolean hasAutStartFailed() {
            return this.m_autStartFailed;
        }

        public void stateChanged(AUTServerEvent event) {
            switch (event.getState()) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 11: 
                case 12: 
                case 13: {
                    this.setAutStartFailed(true);
                    this.dispose();
                    break;
                }
            }
        }

        protected synchronized void setAutStartFailed(boolean autStartFailed) {
            this.m_autStartFailed = autStartFailed;
        }

        private void dispose() {
            this.m_startFailedTimer.cancel();
            this.removeListener();
        }

        protected void removeListener() {
            IClientTest clientTest = ClientTest.instance();
            clientTest.removeTestEventListener((IAUTEventListener)this);
            clientTest.removeAUTServerEventListener((IAUTServerEventListener)this);
            AutAgentRegistration.getInstance().removeListener((IAutRegistrationListener)this);
        }

        public void handleAutRegistration(AutRegistrationEvent event) {
            if (event.getAutId().equals((Object)this.m_autToStart) && event.getStatus() == AutRegistrationEvent.RegistrationStatus.Register) {
                this.m_autStarted = true;
                this.dispose();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CollectAllErrorsOperation
    extends AbstractNonPostOperatingTreeNodeOperation<INodePO> {
        private Set<IProblem> m_errorsToShow = new HashSet<IProblem>();

        private CollectAllErrorsOperation() {
        }

        public boolean operate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
            if (ProblemFactory.hasProblem((INodePO)node)) {
                for (IProblem problem : node.getProblems()) {
                    if (problem.getStatus().getSeverity() != 4) continue;
                    this.getErrorsToShow().add(problem);
                }
            }
            return node.isActive();
        }

        public Set<IProblem> getErrorsToShow() {
            return this.m_errorsToShow;
        }
    }

    protected class TestExecutionWatcher
    implements IExecStackModificationListener {
        protected TestExecutionWatcher() {
        }

        public void stackIncremented(INodePO node) {
            String nodeType = "";
            String name = String.valueOf(node.getName());
            if (node instanceof IEventExecTestCasePO) {
                IEventExecTestCasePO evPo = (IEventExecTestCasePO)node;
                if (evPo.getReentryProp() != ReentryProperty.RETRY) {
                    ExecutionController.this.setNoErrorWhileExecution(false);
                }
                nodeType = Messages.EventHandler;
            } else if (node instanceof IRefTestSuitePO) {
                nodeType = Messages.TestSuite;
                name = NodeNameUtil.getText((IRefTestSuitePO)((IRefTestSuitePO)node));
            } else if (node instanceof IExecTestCasePO) {
                nodeType = Messages.TestCase;
                name = NodeNameUtil.getText((IExecTestCasePO)((IExecTestCasePO)node), (boolean)false);
            }
            StringBuilder sb = new StringBuilder(nodeType);
            sb.append(":");
            sb.append(" ");
            sb.append(name);
            ExecutionController.this.sysOut(sb.toString());
        }

        public void stackDecremented() {
        }

        public void nextDataSetIteration() {
        }

        public void nextCap(ICapPO cap) {
            ExecutionController.this.sysOut("\t" + Messages.Step + ":" + " " + String.valueOf(cap.getName()));
        }

        public void retryCap(ICapPO cap) {
            ExecutionController.this.sysOut("\t" + Messages.RetryStep + ":" + " " + String.valueOf(cap.getName()));
        }
    }

    private final class WatchdogTimer
    extends IsAliveThread {
        private long m_stoptime;
        private boolean m_abort;

        public WatchdogTimer(int timeout) {
            super(Messages.WatchdogTimer);
            this.m_abort = false;
            this.setDaemon(true);
            this.m_stoptime = new Date().getTime();
            this.m_stoptime += (long)(timeout * 1000);
        }

        public void run() {
            do {
                TimeUtil.delay((long)1000L);
                if (!this.m_abort) continue;
                return;
            } while (new Date().getTime() < this.m_stoptime);
            ExecutionController.this.sysErr(Messages.ExecutionControllerAbort);
            ClientTest.instance().stopTestExecution();
            ExecutionController.this.stopProcessing();
            TimeUtil.delay((long)30000L);
            if (!this.m_abort) {
                System.exit(1);
            }
        }

        public void abort() {
            this.m_abort = true;
            this.interrupt();
        }
    }
}

