/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.app.testexec.core;

import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.app.testexec.core.ExecutionController;
import org.eclipse.jubula.app.testexec.i18n.Messages;
import org.eclipse.jubula.client.cmd.AbstractCmdlineClient;
import org.eclipse.jubula.client.cmd.JobConfiguration;
import org.eclipse.jubula.tools.internal.exception.CommunicationException;
import org.eclipse.jubula.tools.internal.exception.JBFatalException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestexecClient
extends AbstractCmdlineClient {
    private static Logger log = LoggerFactory.getLogger(TestexecClient.class);
    private static AbstractCmdlineClient instance = null;

    private TestexecClient() {
    }

    public static AbstractCmdlineClient getInstance() {
        if (instance == null) {
            instance = new TestexecClient();
        }
        return instance;
    }

    protected void preRun() {
        ExecutionController.getInstance().setJob(this.getJob());
    }

    public int doRun() {
        int exitCode = 0;
        try {
            ExecutionController controller = ExecutionController.getInstance();
            if (!controller.executeJob()) {
                exitCode = 1;
            }
        }
        catch (CommunicationException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            TestexecClient.printlnConsoleError((String)e.getMessage());
        }
        catch (IllegalArgumentException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            TestexecClient.printlnConsoleError((String)e.getMessage());
        }
        catch (JBFatalException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            TestexecClient.printlnConsoleError((String)e.getMessage());
        }
        catch (Throwable t) {
            log.error("An unexpected error occured in command-line-client: ", t);
            TestexecClient.printlnConsoleError((String)t.getMessage());
        }
        this.shutdown();
        return exitCode;
    }

    protected void extendOptions(Options options, boolean req) {
        options.addOption(TestexecClient.createOption((String)"server", (boolean)true, (String)"hostname", (String)org.eclipse.jubula.client.cmd.i18n.Messages.ClientServerOpt, (boolean)false));
        options.addOption(TestexecClient.createOption((String)"port", (boolean)true, (String)"port_number", (String)org.eclipse.jubula.client.cmd.i18n.Messages.ClientPortOpt, (boolean)false));
        options.addOption(TestexecClient.createOption((String)"project", (boolean)true, (String)"project_name", (String)org.eclipse.jubula.client.cmd.i18n.Messages.ClientProjectOpt, (boolean)req));
        options.addOption(TestexecClient.createOption((String)"version", (boolean)true, (String)"project_version", (String)org.eclipse.jubula.client.cmd.i18n.Messages.ClientProjectVersionOpt, (boolean)req));
        options.addOption(TestexecClient.createOption((String)"resultdir", (boolean)true, (String)"resultdir", (String)org.eclipse.jubula.client.cmd.i18n.Messages.ClientResultdirOpt, (boolean)false));
        options.addOption(TestexecClient.createOption((String)"resultname", (boolean)true, (String)"resultname", (String)org.eclipse.jubula.client.cmd.i18n.Messages.ClientResultnameOpt, (boolean)false));
        OptionGroup autOptionGroup = new OptionGroup();
        autOptionGroup.setRequired(false);
        autOptionGroup.addOption(TestexecClient.createOption((String)"autconfig", (boolean)true, (String)"autconfig", (String)org.eclipse.jubula.client.cmd.i18n.Messages.ClientAutconfigOpt, (boolean)req));
        autOptionGroup.addOption(TestexecClient.createOption((String)"autid", (boolean)true, (String)"autid", (String)org.eclipse.jubula.client.cmd.i18n.Messages.ClientAutIdOpt, (boolean)req));
        options.addOptionGroup(autOptionGroup);
        OptionGroup testExecutionGroup = new OptionGroup();
        testExecutionGroup.setRequired(req);
        testExecutionGroup.addOption(TestexecClient.createOption((String)"testjob", (boolean)true, (String)"testjob", (String)org.eclipse.jubula.client.cmd.i18n.Messages.ClientTestJobOpt, (boolean)req));
        testExecutionGroup.addOption(TestexecClient.createOption((String)"testsuite", (boolean)true, (String)"testsuite", (String)org.eclipse.jubula.client.cmd.i18n.Messages.ClientTestSuiteOpt, (boolean)req));
        options.addOptionGroup(testExecutionGroup);
        options.addOption(TestexecClient.createOption((String)"datadir", (boolean)true, (String)"datadir_path", (String)org.eclipse.jubula.client.cmd.i18n.Messages.ClientDataFile, (boolean)false));
        Option noRunOption = TestexecClient.createOption((String)"n", (boolean)true, (String)"norun_mode", (String)org.eclipse.jubula.client.cmd.i18n.Messages.ClientNoRunOpt, (boolean)false);
        noRunOption.setOptionalArg(true);
        options.addOption(noRunOption);
        options.addOption(TestexecClient.createOption((String)"s", (boolean)false, (String)"", (String)org.eclipse.jubula.client.cmd.i18n.Messages.ClientAutoScreenshot, (boolean)false));
        options.addOption(TestexecClient.createOption((String)"sx", (boolean)false, (String)"", (String)org.eclipse.jubula.client.cmd.i18n.Messages.ClientNoXmlScreenshot, (boolean)false));
        options.addOption(TestexecClient.createOption((String)"timeout", (boolean)true, (String)"timeout", (String)org.eclipse.jubula.client.cmd.i18n.Messages.ClientTimeout, (boolean)false));
    }

    protected void extendValidate(JobConfiguration job, StringBuilder errorMsgs, StringBuilder errorInvalidArgsMsg) {
        if (job.getProjectName() == null) {
            this.appendError(errorMsgs, "project", "project_name");
        }
        if (job.getProjectVersion() == null) {
            this.appendError(errorMsgs, "version", "project_version");
        }
        if (job.getProjectVersion() != null && job.getProjectVersion().getMajorNumber() == null && job.getProjectVersion().getVersionQualifier() == null) {
            this.appendValidationError(errorInvalidArgsMsg, "version", "project_version");
        }
        if (job.getPort() == -2) {
            this.appendError(errorMsgs, "port", "port_number");
        }
        if (job.getServer() != null && job.getPort() == 0) {
            this.appendError(errorMsgs, "port", "port_number");
        }
        if (job.getAutConfigName() == null && job.getAutId() == null && job.getTestJobName() == null) {
            this.appendError(errorMsgs, "autconfig", "autconfig");
            this.appendError(errorMsgs, "autid", "autid");
        }
        if (job.getTestSuiteNames().isEmpty() && job.getTestJobName() == null) {
            this.appendError(errorMsgs, "testsuite", "testsuite");
            this.appendError(errorMsgs, "testjob", "testjob");
        }
        if (job.getTimeout() < 0) {
            this.appendError(errorMsgs, "timeout", "timeout");
        }
        if (!StringUtils.isEmpty((String)job.getNoRunOptMode()) && job.getNoRunOptMode().equals("invalid argument")) {
            this.appendValidationError(errorInvalidArgsMsg, "n", "norun_mode");
        }
        if (!StringUtils.isEmpty((String)job.getFileName()) && job.getFileName().equals("invalid argument")) {
            this.appendValidationError(errorInvalidArgsMsg, "resultname", "resultname");
        }
    }

    public String getCmdlineClientExecName() {
        return Messages.ClientNameShort;
    }
}

