/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.api.converter.ui.handlers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jubula.client.api.converter.CTDSGenerator;
import org.eclipse.jubula.client.api.converter.CTDSInfo;
import org.eclipse.jubula.client.api.converter.NodeGenerator;
import org.eclipse.jubula.client.api.converter.NodeInfo;
import org.eclipse.jubula.client.api.converter.exceptions.InvalidNodeNameException;
import org.eclipse.jubula.client.api.converter.exceptions.MinorConversionException;
import org.eclipse.jubula.client.api.converter.exceptions.StopConversionException;
import org.eclipse.jubula.client.api.converter.ui.i18n.Messages;
import org.eclipse.jubula.client.core.errorhandling.ErrorMessagePresenter;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.ICategoryPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.IReusedProjectPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.IExecPersistable;
import org.eclipse.jubula.client.core.persistence.ProjectPM;
import org.eclipse.jubula.client.ui.handlers.AbstractHandler;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.utils.Utils;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.internal.exception.JBException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertProjectHandler
extends AbstractHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ConvertProjectHandler.class);
    private static String genPath;
    private static String genPackage;

    public Object executeImpl(ExecutionEvent event) {
        DirectoryDialog directoryDialog = this.createDirectoryDialog();
        genPath = directoryDialog.open();
        if (genPath != null) {
            Utils.storeLastDirPath((String)directoryDialog.getFilterPath());
            File directory = new File(genPath);
            if (directory.list().length == 0) {
                InputDialog inputDialog = new InputDialog(this.getActiveShell(), Messages.InputDialogName, Messages.InputDialogMessage, "", (IInputValidator)new PackageNameValidator());
                if (inputDialog.open() == 0) {
                    genPackage = inputDialog.getValue();
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    try {
                        workbench.getProgressService().run(true, true, (IRunnableWithProgress)new ConvertProjectOperation());
                    }
                    catch (InterruptedException | InvocationTargetException e) {
                        LOG.error(Messages.ErrorWhileConverting, (Throwable)e);
                    }
                }
            } else {
                ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_NON_EMPTY_DIRECTORY);
            }
        }
        return null;
    }

    private DirectoryDialog createDirectoryDialog() {
        DirectoryDialog directoryDialog = new DirectoryDialog(this.getActiveShell(), 8192);
        String filterPath = Utils.getLastDirPath();
        directoryDialog.setFilterPath(filterPath);
        return directoryDialog;
    }

    private static class ConvertProjectOperation
    implements IRunnableWithProgress {
        private static IProgressMonitor progressMonitor;
        private static String defaultToolkit;
        private static Map<String, NodeInfo> uuidToNodeInfoMap;
        private static Set<IProjectPO> projects;
        private static int workUnits;

        private ConvertProjectOperation() {
        }

        public void run(IProgressMonitor monitor) {
            progressMonitor = monitor;
            IProjectPO project = GeneralStorage.getInstance().getProject();
            progressMonitor.setTaskName(Messages.PreparingConvertProjectTaskName);
            String basePath = String.valueOf(genPath) + "/" + genPackage.replace(".", "/");
            uuidToNodeInfoMap = new HashMap<String, NodeInfo>();
            NodeInfo.setUuidToNodeInfoMap(uuidToNodeInfoMap);
            projects = new HashSet<IProjectPO>();
            workUnits = 0;
            if (project != null) {
                defaultToolkit = this.determineDefaultToolkit(project);
                this.addProjectsToConvert(project);
                try {
                    for (IProjectPO p : projects) {
                        this.determineClassNamesForProject(p, basePath);
                    }
                    progressMonitor.beginTask(Messages.PreparingConvertProjectTaskName, workUnits);
                    for (IProjectPO p : projects) {
                        progressMonitor.setTaskName(NLS.bind((String)Messages.ConvertProjectTaskName, (Object)p.getName()));
                        this.handleProject(p, basePath);
                    }
                }
                catch (StopConversionException e) {
                    progressMonitor.setCanceled(true);
                    if (!e.wasManuallyTriggered()) {
                        ErrorHandlingUtil.createMessageDialog((JBException)new JBException(e.getMessage(), (Throwable)e, MessageIDs.E_CONVERSION_ABORTED_ERROR));
                    }
                    return;
                }
            }
            progressMonitor.done();
        }

        private void addProjectsToConvert(IProjectPO project) {
            projects.add(project);
            for (IReusedProjectPO reusedProject : project.getUsedProjects()) {
                try {
                    IProjectPO usedProject = ProjectPM.loadReusedProjectInMasterSession((IReusedProjectPO)reusedProject);
                    this.addProjectsToConvert(usedProject);
                }
                catch (JBException e) {
                    ErrorHandlingUtil.createMessageDialog((JBException)new JBException(e.getMessage(), (Throwable)e, MessageIDs.E_LOAD_PROJECT));
                }
            }
        }

        private void determineClassNamesForProject(IProjectPO project, String basePath) throws StopConversionException {
            String path;
            String projectName = "";
            try {
                projectName = org.eclipse.jubula.client.api.converter.utils.Utils.translateToPackageName((INodePO)project);
            }
            catch (InvalidNodeNameException invalidNodeNameException) {
                this.displayErrorForInvalidName((INodePO)project);
                throw new StopConversionException();
            }
            String projectPath = String.valueOf(basePath) + "/" + projectName;
            for (INodePO node : project.getExecObjCont().getExecObjList()) {
                if (progressMonitor.isCanceled()) {
                    throw new StopConversionException();
                }
                path = String.valueOf(projectPath) + "/" + "testsuites";
                this.determineClassNamesForNode(node, path);
            }
            for (INodePO node : project.getSpecObjCont().getSpecObjList()) {
                if (progressMonitor.isCanceled()) {
                    throw new StopConversionException();
                }
                path = String.valueOf(projectPath) + "/" + "testcases";
                this.determineClassNamesForNode(node, path);
            }
        }

        private void determineClassNamesForNode(INodePO node, String basePath) throws StopConversionException {
            ++workUnits;
            if (node instanceof ICategoryPO) {
                NodeInfo nodeInfo2;
                ICategoryPO category = (ICategoryPO)node;
                String path = "";
                try {
                    path = String.valueOf(basePath) + "/" + org.eclipse.jubula.client.api.converter.utils.Utils.translateToPackageName((INodePO)category);
                }
                catch (InvalidNodeNameException invalidNodeNameException) {
                    this.displayErrorForInvalidName((INodePO)category);
                    throw new StopConversionException();
                }
                for (NodeInfo nodeInfo2 : uuidToNodeInfoMap.values()) {
                    if (!nodeInfo2.getFqFileName().equals(path)) continue;
                    this.displayErrorForDuplicate(node);
                    throw new StopConversionException();
                }
                nodeInfo2 = new NodeInfo(path, node, genPackage, defaultToolkit);
                uuidToNodeInfoMap.put(node.getGuid(), nodeInfo2);
                for (INodePO child : node.getUnmodifiableNodeList()) {
                    this.determineClassNamesForNode(child, path);
                }
            } else {
                NodeInfo nodeInfo3;
                String className = "";
                try {
                    className = org.eclipse.jubula.client.api.converter.utils.Utils.determineClassName((IPersistentObject)node);
                }
                catch (InvalidNodeNameException invalidNodeNameException) {
                    this.displayErrorForInvalidName(node);
                    throw new StopConversionException();
                }
                String fileName = String.valueOf(basePath) + "/" + className + ".java";
                for (NodeInfo nodeInfo3 : uuidToNodeInfoMap.values()) {
                    if (!nodeInfo3.getFqFileName().equals(fileName)) continue;
                    Plugin.getDefault().writeErrorLineToConsole("Duplicate filename error:" + fileName, true);
                }
                nodeInfo3 = new NodeInfo(fileName, node, genPackage, defaultToolkit);
                uuidToNodeInfoMap.put(node.getGuid(), nodeInfo3);
            }
        }

        private String determineDefaultToolkit(IProjectPO project) {
            String toolkit = null;
            IAUTMainPO firstAUT = null;
            try {
                firstAUT = (IAUTMainPO)project.getAutCont().getAutMainList().iterator().next();
            }
            catch (NoSuchElementException noSuchElementException) {
                ErrorMessagePresenter.getPresenter().showErrorMessage(new JBException(Messages.NoAutInProject, MessageIDs.E_NO_AUT_IN_PROJECT), null, null);
                progressMonitor.setCanceled(true);
            }
            if (firstAUT != null) {
                toolkit = firstAUT.getToolkit();
            }
            if (toolkit.equals("com.bredexsw.guidancer.RcpToolkitPlugin")) {
                toolkit = "com.bredexsw.guidancer.SwtToolkitPlugin";
            }
            return toolkit;
        }

        private void handleProject(IProjectPO project, String basePath) throws StopConversionException {
            this.createCentralTestDataClass(project, basePath);
            for (IExecPersistable node : project.getExecObjCont().getExecObjList()) {
                this.handleNode((INodePO)node);
            }
            for (IExecPersistable node : project.getSpecObjCont().getSpecObjList()) {
                this.handleNode((INodePO)node);
            }
        }

        private void handleNode(INodePO node) throws StopConversionException {
            if (progressMonitor.isCanceled()) {
                throw new StopConversionException(true);
            }
            progressMonitor.worked(1);
            NodeInfo info = uuidToNodeInfoMap.get(node.getGuid());
            File file = new File(info.getFqFileName());
            if (node instanceof ICategoryPO) {
                file.mkdirs();
                for (INodePO child : node.getUnmodifiableNodeList()) {
                    this.handleNode(child);
                }
            } else {
                try {
                    file.getParentFile().mkdirs();
                    file.createNewFile();
                    NodeGenerator gen = new NodeGenerator();
                    try {
                        String content = gen.generate((Object)info);
                        this.writeContentToFile(file, content);
                    }
                    catch (MinorConversionException e) {
                        Plugin.getDefault().writeLineToConsole(NLS.bind((String)Messages.InvalidNode, (Object[])new String[]{node.getName(), e.getMessage()}), true);
                        file.delete();
                    }
                }
                catch (IOException e) {
                    ErrorHandlingUtil.createMessageDialog((JBException)new JBException(e.getMessage(), (Throwable)e, MessageIDs.E_FILE_NO_PERMISSION));
                    throw new StopConversionException();
                }
            }
        }

        private void writeContentToFile(File file, String content) throws IOException {
            FileOutputStream fop = new FileOutputStream(file);
            byte[] contentInBytes = content.getBytes();
            IOUtils.write((byte[])contentInBytes, (OutputStream)fop);
        }

        private void displayErrorForDuplicate(INodePO node) {
            String fqNodeName = org.eclipse.jubula.client.api.converter.utils.Utils.getFullyQualifiedName((INodePO)node);
            ErrorMessagePresenter.getPresenter().showErrorMessage(new JBException(NLS.bind((String)Messages.DuplicateNode, (Object[])new String[]{fqNodeName}), MessageIDs.E_DUPLICATE_NODE), (Object[])new String[]{fqNodeName}, null);
            progressMonitor.setCanceled(true);
        }

        private void displayErrorForInvalidName(INodePO node) {
            String fqNodeName = org.eclipse.jubula.client.api.converter.utils.Utils.getFullyQualifiedName((INodePO)node);
            ErrorMessagePresenter.getPresenter().showErrorMessage(new JBException(NLS.bind((String)Messages.InvalidNodeName, (Object[])new String[]{fqNodeName}), MessageIDs.E_INVALID_NODE_NAME), (Object[])new String[]{fqNodeName}, null);
            progressMonitor.setCanceled(true);
        }

        private void createCentralTestDataClass(IProjectPO project, String basePath) {
            String projectName = "";
            try {
                projectName = org.eclipse.jubula.client.api.converter.utils.Utils.translateToPackageName((INodePO)project);
            }
            catch (InvalidNodeNameException invalidNodeNameException) {
                this.displayErrorForInvalidName((INodePO)project);
            }
            String className = "CTDS.java";
            String projectPath = String.valueOf(basePath) + "/" + projectName;
            File projectDir = new File(projectPath);
            projectDir.mkdirs();
            String fileName = String.valueOf(projectPath) + "/" + className;
            File file = new File(fileName);
            try {
                file.createNewFile();
                CTDSGenerator gen = new CTDSGenerator();
                CTDSInfo info = new CTDSInfo(className, project, genPackage);
                String content = gen.generate((Object)info);
                this.writeContentToFile(file, content);
            }
            catch (IOException e) {
                ErrorHandlingUtil.createMessageDialog((JBException)new JBException(e.getMessage(), (Throwable)e, MessageIDs.E_FILE_NO_PERMISSION));
            }
        }
    }

    private static class PackageNameValidator
    implements IInputValidator {
        private PackageNameValidator() {
        }

        public String isValid(String newText) {
            if (newText.isEmpty()) {
                return Messages.NoPackageNameSpecified;
            }
            Pattern p = Pattern.compile("^[a-zA-Z_][\\w]*(\\.[a-zA-Z_][\\w]*)*$");
            if (!p.matcher(newText).matches()) {
                return Messages.InvalidPackageName;
            }
            return null;
        }
    }
}

