/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.api.converter;

import java.util.ArrayList;
import java.util.ListIterator;
import org.eclipse.jubula.client.api.converter.CTDSInfo;
import org.eclipse.jubula.client.api.converter.exceptions.InvalidNodeNameException;
import org.eclipse.jubula.client.api.converter.utils.ParamUtils;
import org.eclipse.jubula.client.api.converter.utils.Utils;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ITestDataCategoryPO;
import org.eclipse.jubula.client.core.model.ITestDataCubePO;
import org.eclipse.jubula.toolkit.api.gen.internal.utils.NameLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CTDSGenerator {
    protected static String nl;
    public final String NL = nl == null ? System.getProperties().getProperty("line.separator") : nl;
    protected final String TEXT_1 = "package ";
    protected final String TEXT_2 = ";" + this.NL + this.NL + "import java.util.ArrayList;" + this.NL + "import java.util.List;" + this.NL + this.NL + "import org.eclipse.jubula.qa.api.converter.target.rcp.VariableStore;" + this.NL + this.NL + "public class ";
    protected final String TEXT_3 = " {" + this.NL;
    protected final String TEXT_4 = String.valueOf(this.NL) + "    public static class ";
    protected final String TEXT_5 = " {";
    protected final String TEXT_6 = String.valueOf(this.NL) + "        public ";
    protected final String TEXT_7 = " ";
    protected final String TEXT_8 = ";";
    protected final String TEXT_9 = String.valueOf(this.NL) + "    " + this.NL + "        public static List<";
    protected final String TEXT_10 = "> data = new ArrayList<";
    protected final String TEXT_11 = ">();" + this.NL + "        " + this.NL + "        static {";
    protected final String TEXT_12 = String.valueOf(this.NL) + "            data.add(new ";
    protected final String TEXT_13 = "(";
    protected final String TEXT_14 = String.valueOf(this.NL) + "                // Initializing parameter \"";
    protected final String TEXT_15 = "\"";
    protected final String TEXT_16 = String.valueOf(this.NL) + "                ";
    protected final String TEXT_17 = String.valueOf(this.NL) + "                ";
    protected final String TEXT_18 = ", ";
    protected final String TEXT_19 = "));";
    protected final String TEXT_20 = String.valueOf(this.NL) + "            ";
    protected final String TEXT_21 = " ";
    protected final String TEXT_22 = " = new ";
    protected final String TEXT_23 = "();";
    protected final String TEXT_24 = String.valueOf(this.NL) + "                ";
    protected final String TEXT_25 = ".";
    protected final String TEXT_26 = " = ";
    protected final String TEXT_27 = String.valueOf(this.NL) + "                    ;";
    protected final String TEXT_28 = String.valueOf(this.NL) + "            data.add(";
    protected final String TEXT_29 = ");";
    protected final String TEXT_30 = String.valueOf(this.NL) + "        }" + this.NL + "    ";
    protected final String TEXT_31 = String.valueOf(this.NL) + "        private ";
    protected final String TEXT_32 = " (";
    protected final String TEXT_33 = String.valueOf(this.NL) + "            ";
    protected final String TEXT_34 = " _";
    protected final String TEXT_35 = ",";
    protected final String TEXT_36 = String.valueOf(this.NL) + "        ) {";
    protected final String TEXT_37 = String.valueOf(this.NL) + "            ";
    protected final String TEXT_38 = " = _";
    protected final String TEXT_39 = ";";
    protected final String TEXT_40 = String.valueOf(this.NL) + "        }";
    protected final String TEXT_41 = String.valueOf(this.NL) + "        private ";
    protected final String TEXT_42 = " () {" + this.NL + "            super();" + this.NL + "        }";
    protected final String TEXT_43 = String.valueOf(this.NL) + "    }" + this.NL + "    ";
    protected final String TEXT_44 = String.valueOf(this.NL) + this.NL + "}";

    public static synchronized CTDSGenerator create(String lineSeparator) {
        nl = lineSeparator;
        CTDSGenerator result = new CTDSGenerator();
        nl = null;
        return result;
    }

    public String generate(Object argument) {
        StringBuffer stringBuffer = new StringBuffer();
        Logger log = LoggerFactory.getLogger(CTDSGenerator.class);
        CTDSInfo info = (CTDSInfo)argument;
        String className = info.getClassName();
        IProjectPO project = info.getProject();
        String projectName = null;
        try {
            projectName = Utils.translateToPackageName((INodePO)project);
        }
        catch (InvalidNodeNameException e) {
            log.error("Invalid Project Name", (Throwable)e);
        }
        String packageName = Utils.getProjectPath(info.getPackageBasePath(), projectName);
        NameLoader nameLoader = NameLoader.getInstance();
        ITestDataCategoryPO testDataRoot = project.getTestDataCubeCont();
        ArrayList<ITestDataCubePO> testCubes = new ArrayList<ITestDataCubePO>();
        Utils.fillCTDSList(testDataRoot, testCubes);
        stringBuffer.append("package ");
        stringBuffer.append(packageName);
        stringBuffer.append(this.TEXT_2);
        stringBuffer.append(className);
        stringBuffer.append(this.TEXT_3);
        for (ITestDataCubePO testCube : testCubes) {
            String testCubeName = null;
            try {
                testCubeName = Utils.determineClassName((IPersistentObject)testCube);
            }
            catch (InvalidNodeNameException e) {
                log.error("Invalid Data Set Name", (Throwable)e);
            }
            int parameterCount = 0;
            stringBuffer.append(this.TEXT_4);
            stringBuffer.append(testCubeName);
            stringBuffer.append(" {");
            for (IParamDescriptionPO param : testCube.getParameterList()) {
                ++parameterCount;
                String paramName = param.getName();
                String paramType = nameLoader.findTypeForParameter(param.getType(), "");
                stringBuffer.append(this.TEXT_6);
                stringBuffer.append(paramType);
                stringBuffer.append(" ");
                stringBuffer.append(paramName);
                stringBuffer.append(";");
            }
            Boolean testCubeSizeOkay = parameterCount < 256;
            stringBuffer.append(this.TEXT_9);
            stringBuffer.append(testCubeName);
            stringBuffer.append("> data = new ArrayList<");
            stringBuffer.append(testCubeName);
            stringBuffer.append(this.TEXT_11);
            int row = 0;
            while (row < testCube.getDataManager().getDataSetCount()) {
                if (testCubeSizeOkay.booleanValue()) {
                    stringBuffer.append(this.TEXT_12);
                    stringBuffer.append(testCubeName);
                    stringBuffer.append("(");
                    ListIterator paramIterator = testCube.getParameterListIter();
                    while (paramIterator.hasNext()) {
                        IParamDescriptionPO param = (IParamDescriptionPO)paramIterator.next();
                        String paramValue = ParamUtils.getValueForParam((IParameterInterfacePO)testCube, param, row);
                        stringBuffer.append(this.TEXT_14);
                        stringBuffer.append(param.getName());
                        stringBuffer.append("\"");
                        stringBuffer.append(this.TEXT_16);
                        stringBuffer.append(paramValue);
                        stringBuffer.append(this.TEXT_17);
                        if (!paramIterator.hasNext()) continue;
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append("));");
                } else {
                    String objName = "entry_" + row;
                    stringBuffer.append(this.TEXT_20);
                    stringBuffer.append(testCubeName);
                    stringBuffer.append(" ");
                    stringBuffer.append(objName);
                    stringBuffer.append(" = new ");
                    stringBuffer.append(testCubeName);
                    stringBuffer.append("();");
                    ListIterator paramIterator = testCube.getParameterListIter();
                    while (paramIterator.hasNext()) {
                        IParamDescriptionPO param = (IParamDescriptionPO)paramIterator.next();
                        String paramValue = ParamUtils.getValueForParam((IParameterInterfacePO)testCube, param, row);
                        String paramName = param.getName();
                        stringBuffer.append(this.TEXT_24);
                        stringBuffer.append(objName);
                        stringBuffer.append(".");
                        stringBuffer.append(paramName);
                        stringBuffer.append(" = ");
                        stringBuffer.append(paramValue);
                        stringBuffer.append(this.TEXT_27);
                    }
                    stringBuffer.append(this.TEXT_28);
                    stringBuffer.append(objName);
                    stringBuffer.append(");");
                }
                ++row;
            }
            stringBuffer.append(this.TEXT_30);
            if (testCubeSizeOkay.booleanValue()) {
                stringBuffer.append(this.TEXT_31);
                stringBuffer.append(testCubeName);
                stringBuffer.append(" (");
                ListIterator paramIterator = testCube.getParameterListIter();
                while (paramIterator.hasNext()) {
                    IParamDescriptionPO param = (IParamDescriptionPO)paramIterator.next();
                    String paramName = param.getName();
                    String paramType = nameLoader.findTypeForParameter(param.getType(), "");
                    stringBuffer.append(this.TEXT_33);
                    stringBuffer.append(paramType);
                    stringBuffer.append(" _");
                    stringBuffer.append(paramName);
                    if (!paramIterator.hasNext()) continue;
                    stringBuffer.append(",");
                }
                stringBuffer.append(this.TEXT_36);
                for (IParamDescriptionPO param : testCube.getParameterList()) {
                    String paramName = param.getName();
                    stringBuffer.append(this.TEXT_37);
                    stringBuffer.append(paramName);
                    stringBuffer.append(" = _");
                    stringBuffer.append(paramName);
                    stringBuffer.append(";");
                }
                stringBuffer.append(this.TEXT_40);
            } else {
                stringBuffer.append(this.TEXT_41);
                stringBuffer.append(testCubeName);
                stringBuffer.append(this.TEXT_42);
            }
            stringBuffer.append(this.TEXT_43);
        }
        stringBuffer.append(this.TEXT_44);
        return stringBuffer.toString();
    }
}

