/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.controllers;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.PMAlreadyLockedException;
import org.eclipse.jubula.client.core.persistence.PMDirtyVersionException;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PMExtProjDeletedException;
import org.eclipse.jubula.client.core.persistence.PMObjectDeletedException;
import org.eclipse.jubula.client.core.persistence.PMSaveException;
import org.eclipse.jubula.client.ui.rcp.editors.IJBEditor;
import org.eclipse.jubula.client.ui.rcp.editors.JBEditorHelper;
import org.eclipse.jubula.client.ui.rcp.handlers.project.RefreshProjectHandler;
import org.eclipse.jubula.client.ui.rcp.utils.Utils;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.internal.exception.JBException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class PMExceptionHandler {
    private PMExceptionHandler() {
    }

    public static void handlePMExceptionForMasterSession(PMException e) {
        if (e instanceof PMDirtyVersionException || e instanceof PMObjectDeletedException || e instanceof PMSaveException) {
            ErrorHandlingUtil.createMessageDialog((Integer)e.getErrorId());
            try {
                PlatformUI.getWorkbench().getProgressService().run(true, false, (IRunnableWithProgress)new RefreshProjectHandler.RefreshProjectOperation());
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
        } else if (e instanceof PMExtProjDeletedException) {
            ErrorHandlingUtil.createMessageDialog((Integer)e.getErrorId());
        } else if (e instanceof PMAlreadyLockedException) {
            boolean result = false;
            if (((PMAlreadyLockedException)((Object)e)).getLockedObject() != null) {
                result = PMExceptionHandler.handleLockedObject(((PMAlreadyLockedException)((Object)e)).getLockedObject());
            }
            if (!result) {
                ErrorHandlingUtil.createMessageDialog((Integer)e.getErrorId());
            }
        } else {
            GeneralStorage.handleFatalError((Throwable)e);
        }
    }

    public static void handlePMExceptionForEditor(PMException exc, IJBEditor editor) {
        if (exc instanceof PMDirtyVersionException || exc instanceof PMObjectDeletedException) {
            ErrorHandlingUtil.createMessageDialog((JBException)((Object)exc));
            try {
                PlatformUI.getWorkbench().getProgressService().run(true, false, (IRunnableWithProgress)new RefreshProjectHandler.RefreshProjectOperation());
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
        } else if (exc instanceof PMAlreadyLockedException) {
            PMExceptionHandler.handlePMAlreadyLockedException((PMAlreadyLockedException)((Object)exc), null);
        } else if (exc instanceof PMObjectDeletedException) {
            ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_DELETED_OBJECT);
        } else {
            ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_DATABASE_GENERAL);
            if (editor != null) {
                editor.getSite().getPage().closeEditor((IEditorPart)editor, false);
            }
        }
    }

    public static void handlePMAlreadyLockedException(PMAlreadyLockedException exc, String[] details) {
        ErrorHandlingUtil.createMessageDialog((JBException)((Object)exc), null, (String[])details);
    }

    public static void handleProjectDeletedException() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IProjectPO oldProj = GeneralStorage.getInstance().getProject();
                ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_CURRENT_PROJ_DEL);
                Utils.clearClient();
                GeneralStorage.getInstance().setProject(null);
                if (oldProj != null) {
                    DataEventDispatcher ded = DataEventDispatcher.getInstance();
                    ded.fireDataChangedListener((IPersistentObject)oldProj, DataEventDispatcher.DataState.Deleted, DataEventDispatcher.UpdateState.all);
                }
            }
        });
    }

    private static boolean handleLockedObject(IPersistentObject po) {
        boolean result = false;
        IEditorPart editor = JBEditorHelper.findEditor2LockedObj(po);
        if (editor != null) {
            ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.I_LOCK_OBJ_1, (Object[])new Object[]{po.getName(), editor.getTitle()}, null);
            result = true;
        }
        return result;
    }
}

