/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.controllers.dnd;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.ICompNamesPairPO;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParamNodePO;
import org.eclipse.jubula.client.core.model.IRefTestSuitePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.LocalSelectionTransfer;
import org.eclipse.jubula.client.ui.rcp.editors.AbstractJBEditor;

public abstract class AbstractEditorDndSupport {
    protected static void postDropAction(INodePO node, AbstractJBEditor targetEditor) {
        targetEditor.setFocus();
        targetEditor.refresh();
        targetEditor.getEditorHelper().setDirty(true);
        if (node != null) {
            targetEditor.setSelection((ISelection)new StructuredSelection((Object)node));
        }
        LocalSelectionTransfer.getInstance().setSelection(null);
    }

    protected static INodePO moveNode(INodePO node, INodePO target) {
        int newPos = target.getParentNode().indexOf(target);
        node.getParentNode().removeNode(node);
        target.getParentNode().addNode(newPos, node);
        return node;
    }

    protected static void fillExec(IExecTestCasePO origExec, IExecTestCasePO newExec) {
        AbstractEditorDndSupport.fillParamNode((IParamNodePO)origExec, (IParamNodePO)newExec);
        newExec.setName(origExec.getRealName());
        ISpecTestCasePO origSpecTC = origExec.getSpecTestCase();
        if (!origExec.getDataManager().equals(origSpecTC.getDataManager())) {
            newExec.setHasReferencedTD(false);
            if (newExec.getDataManager().getUniqueIds().isEmpty()) {
                origExec.getDataManager().deepCopy(newExec.getDataManager());
            }
        } else {
            newExec.setHasReferencedTD(true);
        }
        for (ICompNamesPairPO origPair : origExec.getCompNamesPairs()) {
            ICompNamesPairPO newPair = PoMaker.createCompNamesPairPO((String)origPair.getFirstName(), (String)origPair.getSecondName(), (String)origPair.getType());
            newPair.setPropagated(origPair.isPropagated());
            newExec.addCompNamesPair(newPair);
        }
        if (newExec instanceof IEventExecTestCasePO || origExec instanceof IEventExecTestCasePO) {
            IEventExecTestCasePO newEvent = (IEventExecTestCasePO)newExec;
            IEventExecTestCasePO origEvent = (IEventExecTestCasePO)origExec;
            newEvent.setEventType(origEvent.getEventType());
            newEvent.setReentryProp(origEvent.getReentryProp());
            newEvent.setMaxRetries(origEvent.getMaxRetries());
        }
    }

    protected static void fillCap(ICapPO origCap, ICapPO newCap) {
        AbstractEditorDndSupport.fillParamNode((IParamNodePO)origCap, (IParamNodePO)newCap);
        newCap.setComponentName(origCap.getComponentName());
        newCap.setComponentType(origCap.getComponentType());
        newCap.setActionName(origCap.getActionName());
        origCap.getDataManager().deepCopy(newCap.getDataManager());
    }

    protected static void fillRefTestSuit(IRefTestSuitePO origRefTS, IRefTestSuitePO newRefTS) {
        AbstractEditorDndSupport.fillNode((INodePO)origRefTS, (INodePO)newRefTS);
        newRefTS.setName(origRefTS.getRealName());
        newRefTS.setTestSuiteAutID(origRefTS.getTestSuiteAutID());
    }

    protected static void fillNode(INodePO origNode, INodePO newNode) {
        newNode.setActive(origNode.isActive());
        newNode.setComment(origNode.getComment());
        newNode.setGenerated(origNode.isGenerated());
        newNode.setDescription(origNode.getDescription());
        newNode.setToolkitLevel(origNode.getToolkitLevel());
    }

    protected static void fillParamNode(IParamNodePO origNode, IParamNodePO newNode) {
        AbstractEditorDndSupport.fillNode((INodePO)origNode, (INodePO)newNode);
        newNode.setName(origNode.getName());
        newNode.setDataFile(origNode.getDataFile());
        newNode.setReferencedDataCube(origNode.getReferencedDataCube());
    }

    public static boolean validateCopy(IStructuredSelection toDrop, INodePO dropTarget, Class<?> enabledClass, Class<?> disabledClass) {
        if (toDrop == null || toDrop.isEmpty() || dropTarget == null) {
            return false;
        }
        Object[] objectArray = toDrop.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (!enabledClass.isAssignableFrom(obj.getClass())) {
                return false;
            }
            if (disabledClass != null && disabledClass.isAssignableFrom(obj.getClass())) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

