/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.dialogs;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesBP;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.client.ui.utils.LayoutUtil;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.internal.exception.JBException;
import org.eclipse.jubula.tools.internal.i18n.CompSystemI18n;
import org.eclipse.jubula.tools.internal.xml.businessmodell.CompSystem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CompNameExistsDialog
extends TitleAreaDialog {
    private IComponentNamePO m_persCompName;
    private IComponentNamePO m_existingCompName;
    private String m_newName = "";
    private Label m_typeLabel;
    private Text m_nameField;

    public CompNameExistsDialog(Shell parentShell, IComponentNamePO persCompName, IComponentNamePO existingCompName) {
        super(parentShell);
        this.m_persCompName = persCompName;
        this.m_existingCompName = existingCompName;
        this.m_newName = persCompName.getName();
    }

    protected Control createDialogArea(Composite parent) {
        super.createDialogArea(parent);
        String dialogTitle = Messages.CompNameExistsDialogDialogTitle;
        this.setTitle(dialogTitle);
        this.setMessage(Messages.CompNameExistsDialogDefaultDlgMessage);
        this.getShell().setText(dialogTitle);
        GridLayout gridLayoutParent = new GridLayout();
        gridLayoutParent.numColumns = 1;
        parent.setLayout((Layout)gridLayoutParent);
        LayoutUtil.createSeparator((Composite)parent);
        Composite area = new Composite(parent, 0);
        GridLayout areaLayout = new GridLayout();
        area.setLayout((Layout)areaLayout);
        GridData areaGridData = new GridData();
        areaGridData.grabExcessVerticalSpace = true;
        areaGridData.horizontalAlignment = 4;
        areaGridData.verticalAlignment = 4;
        area.setLayoutData((Object)areaGridData);
        try {
            this.createInput(area);
        }
        catch (JBException e) {
            ErrorHandlingUtil.createMessageDialog((JBException)e, null, null);
            this.cancelPressed();
        }
        return area;
    }

    private void createInput(Composite parent) throws JBException {
        Composite nameFieldArea = new Composite(parent, 0);
        GridLayout areaLayout = new GridLayout(1, false);
        nameFieldArea.setLayout((Layout)areaLayout);
        GridData tableAreaGridData = new GridData();
        tableAreaGridData.horizontalAlignment = 4;
        nameFieldArea.setLayoutData((Object)tableAreaGridData);
        Label messageLabel = new Label(nameFieldArea, 0);
        String componentType = CompSystemI18n.getString((String)this.m_existingCompName.getComponentType());
        messageLabel.setText(Messages.CompNameExistsDialogCompAlreadyExistsInProj);
        this.m_typeLabel = new Label(nameFieldArea, 0);
        this.m_typeLabel.setText(String.valueOf(Messages.CompNameExistsDialogComponentType) + componentType);
        Label messageLabel2 = new Label(nameFieldArea, 0);
        messageLabel2.setText(Messages.CompNameExistsDialogPressOkOrEnter);
        this.m_nameField = new Text(nameFieldArea, 2052);
        GridData nameFieldGridData = new GridData();
        nameFieldGridData.grabExcessHorizontalSpace = true;
        nameFieldGridData.horizontalAlignment = 4;
        this.m_nameField.setLayoutData((Object)nameFieldGridData);
        this.m_nameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CompNameExistsDialog.this.m_newName = CompNameExistsDialog.this.m_nameField.getText();
            }
        });
        this.m_nameField.setText(this.m_persCompName.getName());
        this.isNameOK();
        this.m_nameField.selectAll();
    }

    protected Point getInitialSize() {
        return super.getInitialSize();
    }

    public String getNewName() {
        return this.m_newName;
    }

    protected void okPressed() {
        try {
            if (this.isNameOK()) {
                super.okPressed();
            }
        }
        catch (JBException e) {
            ErrorHandlingUtil.createMessageDialog((JBException)e, null, null);
            this.cancelPressed();
        }
    }

    private boolean isNameOK() throws JBException {
        if ("".equals(this.m_newName)) {
            this.setErrorMessage(Messages.CompNameExistsDialogTypeComponentName);
            return false;
        }
        ComponentNamesBP compNameBP = ComponentNamesBP.getInstance();
        String newNameGuid = compNameBP.getGuidForName(this.m_newName);
        if (newNameGuid == null) {
            return true;
        }
        String projGuid = GeneralStorage.getInstance().getProject().getGuid();
        IComponentNamePO newCompNamePo = compNameBP.getCompNamePo(newNameGuid, projGuid);
        if (newCompNamePo == null) {
            return true;
        }
        String persType = this.m_persCompName.getComponentType();
        String newType = newCompNamePo.getComponentType();
        CompSystem compSystem = ComponentBuilder.getInstance().getCompSystem();
        if (compSystem.isRealizing(persType, newType)) {
            return true;
        }
        String newTypeI18n = CompSystemI18n.getString((String)newType);
        this.setErrorMessage(Messages.CompNameExistsDialogCompNameNotCompatible);
        this.m_typeLabel.setText(String.valueOf(Messages.CompNameExistsDialogComponentType) + newTypeI18n);
        this.m_nameField.selectAll();
        return false;
    }
}

