/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.dialogs;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jubula.client.core.model.ICommentPO;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.LayoutUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewCommentDialog
extends TitleAreaDialog {
    private static final int VERTICAL_SPACING = 2;
    private static final int MARGIN_WIDTH = 10;
    private static final int MARGIN_HEIGHT = 10;
    private static final int WIDTH_HINT = 300;
    private static final int HORIZONTAL_SPAN = 3;
    private Text m_commentTextField;
    private String m_commentText;
    private ICommentPO m_comment;

    public NewCommentDialog(Shell parentShell) {
        super(parentShell);
    }

    public NewCommentDialog(Shell parentShell, ICommentPO comment) {
        this(parentShell);
        this.m_comment = comment;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.NewCommentDialogTitle);
        this.setMessage(Messages.NewCommentDialogMessage);
        this.getShell().setText(Messages.NewCommentDialogTitle);
        GridLayout gridLayoutParent = new GridLayout();
        gridLayoutParent.numColumns = 1;
        gridLayoutParent.verticalSpacing = 2;
        gridLayoutParent.marginWidth = 10;
        gridLayoutParent.marginHeight = 10;
        parent.setLayout((Layout)gridLayoutParent);
        Composite area = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        area.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.widthHint = 300;
        area.setLayoutData((Object)gridData);
        this.createFields(area);
        Plugin.getHelpSystem().setHelp((Control)area, "org.eclipse.jubula.client.ua.help.newCommentDialogContextId");
        return area;
    }

    protected void okPressed() {
        this.m_commentText = this.m_commentTextField.getText();
        this.setReturnCode(0);
        this.close();
    }

    public boolean close() {
        return super.close();
    }

    private void createFields(Composite area) {
        this.createCommentTextField(area);
    }

    private void createCommentTextField(Composite area) {
        this.m_commentTextField = new Text(area, 2626);
        if (this.m_comment != null) {
            this.m_commentTextField.setText(this.m_comment.getName());
        }
        GridData gridData = this.newGridData();
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        LayoutUtil.addToolTipAndMaxWidth((GridData)gridData, (Control)this.m_commentTextField);
        this.m_commentTextField.setLayoutData((Object)gridData);
        LayoutUtil.setMaxChar((Text)this.m_commentTextField, (int)4000);
    }

    private GridData newGridData() {
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 3;
        return gridData;
    }

    public String getCommentText() {
        return this.m_commentText;
    }
}

