/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.handlers.AbstractMergeComponentNameHandler;
import org.eclipse.jubula.tools.internal.exception.ProjectDeletedException;

public class MergeComponentNameInViewHandler
extends AbstractMergeComponentNameHandler {
    public Object executeImpl(ExecutionEvent event) {
        Set<IComponentNamePO> compNames = this.getComponentNames(this.getSelection());
        IComponentNamePO selectedCompNamePo = this.openDialog(compNames);
        if (selectedCompNamePo == null) {
            return null;
        }
        EntityManager masterSession = GeneralStorage.getInstance().getMasterSession();
        Persistor persistor = Persistor.instance();
        EntityTransaction tx = persistor.getTransaction(masterSession);
        HashSet<IComponentNamePO> inSessionCompNames = new HashSet<IComponentNamePO>();
        try {
            for (IComponentNamePO cn : compNames) {
                IComponentNamePO compName = (IComponentNamePO)masterSession.find(cn.getClass(), (Object)cn.getId());
                masterSession.refresh((Object)compName);
                persistor.lockPO(masterSession, (IPersistentObject)compName);
                inSessionCompNames.add(compName);
            }
            this.performOperation(inSessionCompNames, selectedCompNamePo);
            persistor.commitTransaction(masterSession, tx);
            this.fireChangeEvents(inSessionCompNames);
        }
        catch (PMException e) {
            PMExceptionHandler.handlePMExceptionForMasterSession(e);
        }
        catch (ProjectDeletedException projectDeletedException) {
            PMExceptionHandler.handleProjectDeletedException();
        }
        return null;
    }
}

