/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers.project;

import java.net.URL;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jubula.client.ui.handlers.project.AbstractProjectHandler;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.businessprocess.ImportFileBP;
import org.eclipse.jubula.client.ui.rcp.dialogs.ImportProjectDialog;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class ImportProjectHandler
extends AbstractProjectHandler {
    public Object executeImpl(ExecutionEvent event) {
        if (Plugin.getDefault().showSaveEditorDialog(this.getActiveShell())) {
            this.showImportDialog();
        }
        Plugin.stopLongRunning();
        return null;
    }

    void showImportDialog() {
        ImportProjectDialog importProjectWizard = new ImportProjectDialog();
        WizardDialog dialog = new WizardDialog(this.getActiveShell(), (IWizard)importProjectWizard){

            protected void createButtonsForButtonBar(Composite parent) {
                super.createButtonsForButtonBar(parent);
                Button finishButton = this.getButton(16);
                finishButton.setText(IDialogConstants.OK_LABEL);
            }
        };
        importProjectWizard.setWindowTitle(Messages.ImportProjectDialogTitle);
        dialog.setHelpAvailable(true);
        int val = dialog.open();
        if (val == 0) {
            this.importProjects(importProjectWizard.getImportInfoProvider());
        }
    }

    public void importProjects(ImportFileBP.IProjectImportInfoProvider importInfo) {
        List<URL> fileURLs = importInfo.getFileURLs();
        boolean openProject = importInfo.getIsOpenProject();
        ImportFileBP.getInstance().importProject(0, fileURLs, openProject);
    }
}

