/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.propertytester;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IRefTestSuitePO;
import org.eclipse.jubula.client.core.propertytester.AbstractBooleanPropertyTester;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.LocalSelectionClipboardTransfer;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.TCEditorDndSupport;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.TJEditorDndSupport;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.TSEditorDndSupport;
import org.eclipse.jubula.client.ui.rcp.editors.AbstractJBEditor;
import org.eclipse.jubula.client.ui.rcp.editors.TestCaseEditor;
import org.eclipse.jubula.client.ui.rcp.editors.TestJobEditor;
import org.eclipse.jubula.client.ui.rcp.editors.TestSuiteEditor;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.IEditorPart;

public class AbstractJBCollectionPropertyTester
extends AbstractBooleanPropertyTester {
    public static final String IS_PASTE_ALLOWED = "isPasteAllowed";
    public static final String IS_COPY_ALLOWED = "isCopyAllowed";
    public static final String IS_CUT_ALLOWED = "isCutAllowed";
    private static final String[] PROPERTIES = new String[]{"isPasteAllowed", "isCopyAllowed", "isCutAllowed"};

    public boolean testImpl(Object receiver, String property, Object[] args) {
        Collection selectionContents = (Collection)receiver;
        if (property.equals(IS_PASTE_ALLOWED)) {
            return this.testIsPasteAllowed(selectionContents);
        }
        if (property.equals(IS_COPY_ALLOWED)) {
            return this.testIsCopyCutAllowed(selectionContents, false);
        }
        if (property.equals(IS_CUT_ALLOWED)) {
            return this.testIsCopyCutAllowed(selectionContents, true);
        }
        return false;
    }

    private boolean testIsCopyCutAllowed(Collection<? extends Object> selectionContents, boolean isItCut) {
        IEditorPart activeEditor = Plugin.getActiveEditor();
        if (!(activeEditor instanceof AbstractJBEditor) || selectionContents == null || selectionContents.isEmpty() || activeEditor.isDirty() && !isItCut) {
            return false;
        }
        boolean isEnable = false;
        ArrayList classes = new ArrayList();
        if (activeEditor instanceof TestCaseEditor) {
            classes.add(IExecTestCasePO.class);
            classes.add(ICapPO.class);
            isEnable = this.getCopyActionEnablement(selectionContents, classes, isItCut);
        } else if (activeEditor instanceof TestSuiteEditor) {
            classes.add(IExecTestCasePO.class);
            isEnable = this.getCopyActionEnablement(selectionContents, classes, isItCut);
        } else if (activeEditor instanceof TestJobEditor) {
            classes.add(IRefTestSuitePO.class);
            isEnable = this.getCopyActionEnablement(selectionContents, classes, isItCut);
        }
        return isEnable;
    }

    private boolean testIsPasteAllowed(Collection<? extends Object> selectionContents) {
        LocalSelectionClipboardTransfer transfer = LocalSelectionClipboardTransfer.getInstance();
        IEditorPart activeEditor = Plugin.getActiveEditor();
        if (!(activeEditor instanceof AbstractJBEditor) || selectionContents == null || selectionContents.isEmpty()) {
            return false;
        }
        AbstractJBEditor aJBEditor = (AbstractJBEditor)activeEditor;
        Object toDrop = aJBEditor.getEditorHelper().getClipboard().getContents((Transfer)transfer);
        if (toDrop == null || !(toDrop instanceof IStructuredSelection) || aJBEditor.getSelection() == null || !(aJBEditor.getSelection() instanceof IStructuredSelection) || transfer.getIsItCut() && !aJBEditor.getTreeViewer().equals(transfer.getSource())) {
            return false;
        }
        IStructuredSelection targetSel = (IStructuredSelection)aJBEditor.getSelection();
        boolean isEnable = false;
        if (aJBEditor instanceof TestCaseEditor) {
            isEnable = this.getPasteActionEnablementForTCE((IStructuredSelection)toDrop, targetSel);
        } else if (aJBEditor instanceof TestSuiteEditor) {
            isEnable = this.getPasteActionEnablementForTSE((IStructuredSelection)toDrop, targetSel);
        } else if (aJBEditor instanceof TestJobEditor) {
            isEnable = this.getPasteActionEnablementForTJE((IStructuredSelection)toDrop, targetSel);
        }
        return isEnable;
    }

    private boolean getCopyActionEnablement(Collection<? extends Object> selectionContents, List<Class<?>> checkedClasses, boolean isItCut) {
        for (Object object : selectionContents) {
            if (object == null || object instanceof IEventExecTestCasePO && isItCut) {
                return false;
            }
            boolean contains = false;
            for (Class<?> checkedClass : checkedClasses) {
                if (!checkedClass.isAssignableFrom(object.getClass())) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            return false;
        }
        return true;
    }

    private boolean getPasteActionEnablementForTCE(IStructuredSelection toDrop, IStructuredSelection targetSel) {
        for (Object target : targetSel.toList()) {
            if (target != null && target instanceof INodePO && TCEditorDndSupport.validateCopy(toDrop, (INodePO)target)) continue;
            return false;
        }
        return true;
    }

    private boolean getPasteActionEnablementForTSE(IStructuredSelection toDrop, IStructuredSelection targetSel) {
        for (Object target : targetSel.toList()) {
            if (target != null && target instanceof INodePO && TSEditorDndSupport.validateCopy(toDrop, (INodePO)target)) continue;
            return false;
        }
        return true;
    }

    private boolean getPasteActionEnablementForTJE(IStructuredSelection toDrop, IStructuredSelection targetSel) {
        for (Object target : targetSel.toList()) {
            if (target != null && target instanceof INodePO && TJEditorDndSupport.validateCopy(toDrop, (INodePO)target)) continue;
            return false;
        }
        return true;
    }

    public Class<? extends Object> getType() {
        return Collection.class;
    }

    public String[] getProperties() {
        return PROPERTIES;
    }
}

