/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.widgets;

import org.apache.commons.lang.ObjectUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.businessprocess.ICompNameValidator;
import org.eclipse.jubula.client.core.model.ICompNamesPairPO;
import org.eclipse.jubula.client.ui.rcp.databinding.validators.ComponentNameValidator;

public class CompNameCellValidator
implements ICellEditorValidator {
    private CheckboxTableViewer m_tableViewer;
    private ICompNameValidator m_validationDelegate;

    public CompNameCellValidator(CheckboxTableViewer tableViewer, ICompNameValidator validationDelegate) {
        this.m_tableViewer = tableViewer;
        this.m_validationDelegate = validationDelegate;
    }

    public String isValid(Object value) {
        String checkableName = ObjectUtils.toString((Object)value);
        IStatus status = ComponentNameValidator.isValidComponentNameString(checkableName);
        if (!status.isOK()) {
            return status.getMessage();
        }
        if (this.m_tableViewer.getSelection() == null || this.m_tableViewer.getSelection().isEmpty() || !(this.m_tableViewer.getSelection() instanceof IStructuredSelection)) {
            return null;
        }
        ICompNamesPairPO compNamesPair = (ICompNamesPairPO)((IStructuredSelection)this.m_tableViewer.getSelection()).getFirstElement();
        return this.m_validationDelegate.isValid(compNamesPair.getType(), checkableName);
    }
}

